@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.neptune.kotlin

import com.pulumi.aws.neptune.ClusterArgs.builder
import com.pulumi.aws.neptune.kotlin.inputs.ClusterServerlessV2ScalingConfigurationArgs
import com.pulumi.aws.neptune.kotlin.inputs.ClusterServerlessV2ScalingConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Neptune Cluster Resource. A Cluster Resource defines attributes that are
 * applied to the entire cluster of Neptune Cluster Instances.
 * Changes to a Neptune Cluster can occur when you manually change a
 * parameter, such as `backup_retention_period`, and are reflected in the next maintenance
 * window. Because of this, this provider may report a difference in its planning
 * phase because a modification has not yet taken place. You can use the
 * `apply_immediately` flag to instruct the service to apply the change immediately
 * (see documentation below).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _default = new aws.neptune.Cluster("default", {
 *     clusterIdentifier: "neptune-cluster-demo",
 *     engine: "neptune",
 *     backupRetentionPeriod: 5,
 *     preferredBackupWindow: "07:00-09:00",
 *     skipFinalSnapshot: true,
 *     iamDatabaseAuthenticationEnabled: true,
 *     applyImmediately: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * default = aws.neptune.Cluster("default",
 *     cluster_identifier="neptune-cluster-demo",
 *     engine="neptune",
 *     backup_retention_period=5,
 *     preferred_backup_window="07:00-09:00",
 *     skip_final_snapshot=True,
 *     iam_database_authentication_enabled=True,
 *     apply_immediately=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.Neptune.Cluster("default", new()
 *     {
 *         ClusterIdentifier = "neptune-cluster-demo",
 *         Engine = "neptune",
 *         BackupRetentionPeriod = 5,
 *         PreferredBackupWindow = "07:00-09:00",
 *         SkipFinalSnapshot = true,
 *         IamDatabaseAuthenticationEnabled = true,
 *         ApplyImmediately = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/neptune"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := neptune.NewCluster(ctx, "default", &neptune.ClusterArgs{
 * 			ClusterIdentifier:                pulumi.String("neptune-cluster-demo"),
 * 			Engine:                           pulumi.String("neptune"),
 * 			BackupRetentionPeriod:            pulumi.Int(5),
 * 			PreferredBackupWindow:            pulumi.String("07:00-09:00"),
 * 			SkipFinalSnapshot:                pulumi.Bool(true),
 * 			IamDatabaseAuthenticationEnabled: pulumi.Bool(true),
 * 			ApplyImmediately:                 pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.neptune.Cluster;
 * import com.pulumi.aws.neptune.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Cluster("default", ClusterArgs.builder()
 *             .clusterIdentifier("neptune-cluster-demo")
 *             .engine("neptune")
 *             .backupRetentionPeriod(5)
 *             .preferredBackupWindow("07:00-09:00")
 *             .skipFinalSnapshot(true)
 *             .iamDatabaseAuthenticationEnabled(true)
 *             .applyImmediately(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: aws:neptune:Cluster
 *     properties:
 *       clusterIdentifier: neptune-cluster-demo
 *       engine: neptune
 *       backupRetentionPeriod: 5
 *       preferredBackupWindow: 07:00-09:00
 *       skipFinalSnapshot: true
 *       iamDatabaseAuthenticationEnabled: true
 *       applyImmediately: true
 * ```
 * <!--End PulumiCodeChooser -->
 * > **Note:** AWS Neptune does not support user name/password–based access control.
 * See the AWS [Docs](https://docs.aws.amazon.com/neptune/latest/userguide/limits.html) for more information.
 * ## Import
 * Using `pulumi import`, import `aws_neptune_cluster` using the cluster identifier. For example:
 * ```sh
 * $ pulumi import aws:neptune/cluster:Cluster example my-cluster
 * ```
 * @property allowMajorVersionUpgrade Specifies whether upgrades between different major versions are allowed. You must set it to `true` when providing an `engine_version` parameter that uses a different major version than the DB cluster's current version. Default is `false`.
 * @property applyImmediately Specifies whether any cluster modifications are applied immediately, or during the next maintenance window. Default is `false`.
 * @property availabilityZones A list of EC2 Availability Zones that instances in the Neptune cluster can be created in.
 * @property backupRetentionPeriod The days to retain backups for. Default `1`
 * @property clusterIdentifier The cluster identifier. If omitted, this provider will assign a random, unique identifier.
 * @property clusterIdentifierPrefix Creates a unique cluster identifier beginning with the specified prefix. Conflicts with `cluster_identifier`.
 * @property copyTagsToSnapshot If set to true, tags are copied to any snapshot of the DB cluster that is created.
 * @property deletionProtection A value that indicates whether the DB cluster has deletion protection enabled.The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
 * @property enableCloudwatchLogsExports A list of the log types this DB cluster is configured to export to Cloudwatch Logs. Currently only supports `audit` and `slowquery`.
 * @property engine The name of the database engine to be used for this Neptune cluster. Defaults to `neptune`.
 * @property engineVersion The database engine version.
 * @property finalSnapshotIdentifier The name of your final Neptune snapshot when this Neptune cluster is deleted. If omitted, no final snapshot will be made.
 * @property globalClusterIdentifier The global cluster identifier specified on `aws.neptune.GlobalCluster`.
 * @property iamDatabaseAuthenticationEnabled Specifies whether or not mappings of AWS Identity and Access Management (IAM) accounts to database accounts is enabled.
 * @property iamRoles A List of ARNs for the IAM roles to associate to the Neptune Cluster.
 * @property kmsKeyArn The ARN for the KMS encryption key. When specifying `kms_key_arn`, `storage_encrypted` needs to be set to true.
 * @property neptuneClusterParameterGroupName A cluster parameter group to associate with the cluster.
 * @property neptuneInstanceParameterGroupName The name of the DB parameter group to apply to all instances of the DB cluster.
 * @property neptuneSubnetGroupName A Neptune subnet group to associate with this Neptune instance.
 * @property port The port on which the Neptune accepts connections. Default is `8182`.
 * @property preferredBackupWindow The daily time range during which automated backups are created if automated backups are enabled using the BackupRetentionPeriod parameter. Time in UTC. Default: A 30-minute window selected at random from an 8-hour block of time per regionE.g., 04:00-09:00
 * @property preferredMaintenanceWindow The weekly time range during which system maintenance can occur, in (UTC) e.g., wed:04:00-wed:04:30
 * @property replicationSourceIdentifier ARN of a source Neptune cluster or Neptune instance if this Neptune cluster is to be created as a Read Replica.
 * @property serverlessV2ScalingConfiguration If set, create the Neptune cluster as a serverless one. See Serverless for example block attributes.
 * @property skipFinalSnapshot Determines whether a final Neptune snapshot is created before the Neptune cluster is deleted. If true is specified, no Neptune snapshot is created. If false is specified, a Neptune snapshot is created before the Neptune cluster is deleted, using the value from `final_snapshot_identifier`. Default is `false`.
 * @property snapshotIdentifier Specifies whether or not to create this cluster from a snapshot. You can use either the name or ARN when specifying a Neptune cluster snapshot, or the ARN when specifying a Neptune snapshot. Automated snapshots **should not** be used for this attribute, unless from a different cluster. Automated snapshots are deleted as part of cluster destruction when the resource is replaced.
 * @property storageEncrypted Specifies whether the Neptune cluster is encrypted. The default is `false` if not specified.
 * @property storageType Storage type associated with the cluster `standard/iopt1`. Default: `standard`
 * @property tags A map of tags to assign to the Neptune cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcSecurityGroupIds List of VPC security groups to associate with the Cluster
 */
public data class ClusterArgs(
    public val allowMajorVersionUpgrade: Output<Boolean>? = null,
    public val applyImmediately: Output<Boolean>? = null,
    public val availabilityZones: Output<List<String>>? = null,
    public val backupRetentionPeriod: Output<Int>? = null,
    public val clusterIdentifier: Output<String>? = null,
    public val clusterIdentifierPrefix: Output<String>? = null,
    public val copyTagsToSnapshot: Output<Boolean>? = null,
    public val deletionProtection: Output<Boolean>? = null,
    public val enableCloudwatchLogsExports: Output<List<String>>? = null,
    public val engine: Output<String>? = null,
    public val engineVersion: Output<String>? = null,
    public val finalSnapshotIdentifier: Output<String>? = null,
    public val globalClusterIdentifier: Output<String>? = null,
    public val iamDatabaseAuthenticationEnabled: Output<Boolean>? = null,
    public val iamRoles: Output<List<String>>? = null,
    public val kmsKeyArn: Output<String>? = null,
    public val neptuneClusterParameterGroupName: Output<String>? = null,
    public val neptuneInstanceParameterGroupName: Output<String>? = null,
    public val neptuneSubnetGroupName: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val preferredBackupWindow: Output<String>? = null,
    public val preferredMaintenanceWindow: Output<String>? = null,
    public val replicationSourceIdentifier: Output<String>? = null,
    public val serverlessV2ScalingConfiguration: Output<ClusterServerlessV2ScalingConfigurationArgs>? =
        null,
    public val skipFinalSnapshot: Output<Boolean>? = null,
    public val snapshotIdentifier: Output<String>? = null,
    public val storageEncrypted: Output<Boolean>? = null,
    public val storageType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcSecurityGroupIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.neptune.ClusterArgs> {
    override fun toJava(): com.pulumi.aws.neptune.ClusterArgs =
        com.pulumi.aws.neptune.ClusterArgs.builder()
            .allowMajorVersionUpgrade(allowMajorVersionUpgrade?.applyValue({ args0 -> args0 }))
            .applyImmediately(applyImmediately?.applyValue({ args0 -> args0 }))
            .availabilityZones(availabilityZones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .backupRetentionPeriod(backupRetentionPeriod?.applyValue({ args0 -> args0 }))
            .clusterIdentifier(clusterIdentifier?.applyValue({ args0 -> args0 }))
            .clusterIdentifierPrefix(clusterIdentifierPrefix?.applyValue({ args0 -> args0 }))
            .copyTagsToSnapshot(copyTagsToSnapshot?.applyValue({ args0 -> args0 }))
            .deletionProtection(deletionProtection?.applyValue({ args0 -> args0 }))
            .enableCloudwatchLogsExports(
                enableCloudwatchLogsExports?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .engine(engine?.applyValue({ args0 -> args0 }))
            .engineVersion(engineVersion?.applyValue({ args0 -> args0 }))
            .finalSnapshotIdentifier(finalSnapshotIdentifier?.applyValue({ args0 -> args0 }))
            .globalClusterIdentifier(globalClusterIdentifier?.applyValue({ args0 -> args0 }))
            .iamDatabaseAuthenticationEnabled(iamDatabaseAuthenticationEnabled?.applyValue({ args0 -> args0 }))
            .iamRoles(iamRoles?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .kmsKeyArn(kmsKeyArn?.applyValue({ args0 -> args0 }))
            .neptuneClusterParameterGroupName(neptuneClusterParameterGroupName?.applyValue({ args0 -> args0 }))
            .neptuneInstanceParameterGroupName(
                neptuneInstanceParameterGroupName?.applyValue({ args0 ->
                    args0
                }),
            )
            .neptuneSubnetGroupName(neptuneSubnetGroupName?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .preferredBackupWindow(preferredBackupWindow?.applyValue({ args0 -> args0 }))
            .preferredMaintenanceWindow(preferredMaintenanceWindow?.applyValue({ args0 -> args0 }))
            .replicationSourceIdentifier(replicationSourceIdentifier?.applyValue({ args0 -> args0 }))
            .serverlessV2ScalingConfiguration(
                serverlessV2ScalingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .skipFinalSnapshot(skipFinalSnapshot?.applyValue({ args0 -> args0 }))
            .snapshotIdentifier(snapshotIdentifier?.applyValue({ args0 -> args0 }))
            .storageEncrypted(storageEncrypted?.applyValue({ args0 -> args0 }))
            .storageType(storageType?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcSecurityGroupIds(
                vpcSecurityGroupIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [ClusterArgs].
 */
@PulumiTagMarker
public class ClusterArgsBuilder internal constructor() {
    private var allowMajorVersionUpgrade: Output<Boolean>? = null

    private var applyImmediately: Output<Boolean>? = null

    private var availabilityZones: Output<List<String>>? = null

    private var backupRetentionPeriod: Output<Int>? = null

    private var clusterIdentifier: Output<String>? = null

    private var clusterIdentifierPrefix: Output<String>? = null

    private var copyTagsToSnapshot: Output<Boolean>? = null

    private var deletionProtection: Output<Boolean>? = null

    private var enableCloudwatchLogsExports: Output<List<String>>? = null

    private var engine: Output<String>? = null

    private var engineVersion: Output<String>? = null

    private var finalSnapshotIdentifier: Output<String>? = null

    private var globalClusterIdentifier: Output<String>? = null

    private var iamDatabaseAuthenticationEnabled: Output<Boolean>? = null

    private var iamRoles: Output<List<String>>? = null

    private var kmsKeyArn: Output<String>? = null

    private var neptuneClusterParameterGroupName: Output<String>? = null

    private var neptuneInstanceParameterGroupName: Output<String>? = null

    private var neptuneSubnetGroupName: Output<String>? = null

    private var port: Output<Int>? = null

    private var preferredBackupWindow: Output<String>? = null

    private var preferredMaintenanceWindow: Output<String>? = null

    private var replicationSourceIdentifier: Output<String>? = null

    private var serverlessV2ScalingConfiguration: Output<ClusterServerlessV2ScalingConfigurationArgs>? =
        null

    private var skipFinalSnapshot: Output<Boolean>? = null

    private var snapshotIdentifier: Output<String>? = null

    private var storageEncrypted: Output<Boolean>? = null

    private var storageType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcSecurityGroupIds: Output<List<String>>? = null

    /**
     * @param value Specifies whether upgrades between different major versions are allowed. You must set it to `true` when providing an `engine_version` parameter that uses a different major version than the DB cluster's current version. Default is `false`.
     */
    @JvmName("jphiyagxwlsohcva")
    public suspend fun allowMajorVersionUpgrade(`value`: Output<Boolean>) {
        this.allowMajorVersionUpgrade = value
    }

    /**
     * @param value Specifies whether any cluster modifications are applied immediately, or during the next maintenance window. Default is `false`.
     */
    @JvmName("yihihvdnfkgbxkvi")
    public suspend fun applyImmediately(`value`: Output<Boolean>) {
        this.applyImmediately = value
    }

    /**
     * @param value A list of EC2 Availability Zones that instances in the Neptune cluster can be created in.
     */
    @JvmName("qfjyhrgdyxqyyujx")
    public suspend fun availabilityZones(`value`: Output<List<String>>) {
        this.availabilityZones = value
    }

    @JvmName("nyocbdckrxhwonuk")
    public suspend fun availabilityZones(vararg values: Output<String>) {
        this.availabilityZones = Output.all(values.asList())
    }

    /**
     * @param values A list of EC2 Availability Zones that instances in the Neptune cluster can be created in.
     */
    @JvmName("wtfdpettbhjekqwl")
    public suspend fun availabilityZones(values: List<Output<String>>) {
        this.availabilityZones = Output.all(values)
    }

    /**
     * @param value The days to retain backups for. Default `1`
     */
    @JvmName("bekxtnsejabpqhtx")
    public suspend fun backupRetentionPeriod(`value`: Output<Int>) {
        this.backupRetentionPeriod = value
    }

    /**
     * @param value The cluster identifier. If omitted, this provider will assign a random, unique identifier.
     */
    @JvmName("yymjeatycafvvsjk")
    public suspend fun clusterIdentifier(`value`: Output<String>) {
        this.clusterIdentifier = value
    }

    /**
     * @param value Creates a unique cluster identifier beginning with the specified prefix. Conflicts with `cluster_identifier`.
     */
    @JvmName("nuywpyapwsrkhpit")
    public suspend fun clusterIdentifierPrefix(`value`: Output<String>) {
        this.clusterIdentifierPrefix = value
    }

    /**
     * @param value If set to true, tags are copied to any snapshot of the DB cluster that is created.
     */
    @JvmName("vjxnbgxrykjfgnsf")
    public suspend fun copyTagsToSnapshot(`value`: Output<Boolean>) {
        this.copyTagsToSnapshot = value
    }

    /**
     * @param value A value that indicates whether the DB cluster has deletion protection enabled.The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
     */
    @JvmName("wgmqvmhvuedeeupw")
    public suspend fun deletionProtection(`value`: Output<Boolean>) {
        this.deletionProtection = value
    }

    /**
     * @param value A list of the log types this DB cluster is configured to export to Cloudwatch Logs. Currently only supports `audit` and `slowquery`.
     */
    @JvmName("hgqmlvuljdyyhria")
    public suspend fun enableCloudwatchLogsExports(`value`: Output<List<String>>) {
        this.enableCloudwatchLogsExports = value
    }

    @JvmName("stjbkkqslddecxmc")
    public suspend fun enableCloudwatchLogsExports(vararg values: Output<String>) {
        this.enableCloudwatchLogsExports = Output.all(values.asList())
    }

    /**
     * @param values A list of the log types this DB cluster is configured to export to Cloudwatch Logs. Currently only supports `audit` and `slowquery`.
     */
    @JvmName("skjhmcpomytmeymr")
    public suspend fun enableCloudwatchLogsExports(values: List<Output<String>>) {
        this.enableCloudwatchLogsExports = Output.all(values)
    }

    /**
     * @param value The name of the database engine to be used for this Neptune cluster. Defaults to `neptune`.
     */
    @JvmName("wysxdwqpwhacapci")
    public suspend fun engine(`value`: Output<String>) {
        this.engine = value
    }

    /**
     * @param value The database engine version.
     */
    @JvmName("kguaeuuwjbwcwmdq")
    public suspend fun engineVersion(`value`: Output<String>) {
        this.engineVersion = value
    }

    /**
     * @param value The name of your final Neptune snapshot when this Neptune cluster is deleted. If omitted, no final snapshot will be made.
     */
    @JvmName("lrbpddrwcgtptniu")
    public suspend fun finalSnapshotIdentifier(`value`: Output<String>) {
        this.finalSnapshotIdentifier = value
    }

    /**
     * @param value The global cluster identifier specified on `aws.neptune.GlobalCluster`.
     */
    @JvmName("smchaygpxcthvnru")
    public suspend fun globalClusterIdentifier(`value`: Output<String>) {
        this.globalClusterIdentifier = value
    }

    /**
     * @param value Specifies whether or not mappings of AWS Identity and Access Management (IAM) accounts to database accounts is enabled.
     */
    @JvmName("gixqcqvhqumirnfl")
    public suspend fun iamDatabaseAuthenticationEnabled(`value`: Output<Boolean>) {
        this.iamDatabaseAuthenticationEnabled = value
    }

    /**
     * @param value A List of ARNs for the IAM roles to associate to the Neptune Cluster.
     */
    @JvmName("lxhwwihvbynwrxbf")
    public suspend fun iamRoles(`value`: Output<List<String>>) {
        this.iamRoles = value
    }

    @JvmName("ucandhplcksgmawf")
    public suspend fun iamRoles(vararg values: Output<String>) {
        this.iamRoles = Output.all(values.asList())
    }

    /**
     * @param values A List of ARNs for the IAM roles to associate to the Neptune Cluster.
     */
    @JvmName("kkifbskallirdymv")
    public suspend fun iamRoles(values: List<Output<String>>) {
        this.iamRoles = Output.all(values)
    }

    /**
     * @param value The ARN for the KMS encryption key. When specifying `kms_key_arn`, `storage_encrypted` needs to be set to true.
     */
    @JvmName("kfsmrfimxhyqqosp")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value A cluster parameter group to associate with the cluster.
     */
    @JvmName("flmlnpayasuavmvj")
    public suspend fun neptuneClusterParameterGroupName(`value`: Output<String>) {
        this.neptuneClusterParameterGroupName = value
    }

    /**
     * @param value The name of the DB parameter group to apply to all instances of the DB cluster.
     */
    @JvmName("itjvojaewkxmfrbq")
    public suspend fun neptuneInstanceParameterGroupName(`value`: Output<String>) {
        this.neptuneInstanceParameterGroupName = value
    }

    /**
     * @param value A Neptune subnet group to associate with this Neptune instance.
     */
    @JvmName("mlmdbjbqwxmtjwkc")
    public suspend fun neptuneSubnetGroupName(`value`: Output<String>) {
        this.neptuneSubnetGroupName = value
    }

    /**
     * @param value The port on which the Neptune accepts connections. Default is `8182`.
     */
    @JvmName("jddyijxtlgylkshj")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The daily time range during which automated backups are created if automated backups are enabled using the BackupRetentionPeriod parameter. Time in UTC. Default: A 30-minute window selected at random from an 8-hour block of time per regionE.g., 04:00-09:00
     */
    @JvmName("aaopiupceueeqgcy")
    public suspend fun preferredBackupWindow(`value`: Output<String>) {
        this.preferredBackupWindow = value
    }

    /**
     * @param value The weekly time range during which system maintenance can occur, in (UTC) e.g., wed:04:00-wed:04:30
     */
    @JvmName("lwgoxmlgfsifhpqi")
    public suspend fun preferredMaintenanceWindow(`value`: Output<String>) {
        this.preferredMaintenanceWindow = value
    }

    /**
     * @param value ARN of a source Neptune cluster or Neptune instance if this Neptune cluster is to be created as a Read Replica.
     */
    @JvmName("yygvtcncbgudvjjw")
    public suspend fun replicationSourceIdentifier(`value`: Output<String>) {
        this.replicationSourceIdentifier = value
    }

    /**
     * @param value If set, create the Neptune cluster as a serverless one. See Serverless for example block attributes.
     */
    @JvmName("vkmekaiusegtigit")
    public suspend fun serverlessV2ScalingConfiguration(`value`: Output<ClusterServerlessV2ScalingConfigurationArgs>) {
        this.serverlessV2ScalingConfiguration = value
    }

    /**
     * @param value Determines whether a final Neptune snapshot is created before the Neptune cluster is deleted. If true is specified, no Neptune snapshot is created. If false is specified, a Neptune snapshot is created before the Neptune cluster is deleted, using the value from `final_snapshot_identifier`. Default is `false`.
     */
    @JvmName("vxgsdkeogifkkudb")
    public suspend fun skipFinalSnapshot(`value`: Output<Boolean>) {
        this.skipFinalSnapshot = value
    }

    /**
     * @param value Specifies whether or not to create this cluster from a snapshot. You can use either the name or ARN when specifying a Neptune cluster snapshot, or the ARN when specifying a Neptune snapshot. Automated snapshots **should not** be used for this attribute, unless from a different cluster. Automated snapshots are deleted as part of cluster destruction when the resource is replaced.
     */
    @JvmName("sqlopbpasyditbue")
    public suspend fun snapshotIdentifier(`value`: Output<String>) {
        this.snapshotIdentifier = value
    }

    /**
     * @param value Specifies whether the Neptune cluster is encrypted. The default is `false` if not specified.
     */
    @JvmName("hfseclybereapnok")
    public suspend fun storageEncrypted(`value`: Output<Boolean>) {
        this.storageEncrypted = value
    }

    /**
     * @param value Storage type associated with the cluster `standard/iopt1`. Default: `standard`
     */
    @JvmName("gxmmwvdnfamiqkwm")
    public suspend fun storageType(`value`: Output<String>) {
        this.storageType = value
    }

    /**
     * @param value A map of tags to assign to the Neptune cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iyxabqffyryaqbxi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value List of VPC security groups to associate with the Cluster
     */
    @JvmName("aeeilivvxhegcsyl")
    public suspend fun vpcSecurityGroupIds(`value`: Output<List<String>>) {
        this.vpcSecurityGroupIds = value
    }

    @JvmName("avoonmqlujransfm")
    public suspend fun vpcSecurityGroupIds(vararg values: Output<String>) {
        this.vpcSecurityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values List of VPC security groups to associate with the Cluster
     */
    @JvmName("yssvmkhdeddookni")
    public suspend fun vpcSecurityGroupIds(values: List<Output<String>>) {
        this.vpcSecurityGroupIds = Output.all(values)
    }

    /**
     * @param value Specifies whether upgrades between different major versions are allowed. You must set it to `true` when providing an `engine_version` parameter that uses a different major version than the DB cluster's current version. Default is `false`.
     */
    @JvmName("gfslpcbqenpyxmeo")
    public suspend fun allowMajorVersionUpgrade(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowMajorVersionUpgrade = mapped
    }

    /**
     * @param value Specifies whether any cluster modifications are applied immediately, or during the next maintenance window. Default is `false`.
     */
    @JvmName("dsbtqpkcickwbmda")
    public suspend fun applyImmediately(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applyImmediately = mapped
    }

    /**
     * @param value A list of EC2 Availability Zones that instances in the Neptune cluster can be created in.
     */
    @JvmName("prjhgkboufrajfab")
    public suspend fun availabilityZones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param values A list of EC2 Availability Zones that instances in the Neptune cluster can be created in.
     */
    @JvmName("fogqmwekyjgkruia")
    public suspend fun availabilityZones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param value The days to retain backups for. Default `1`
     */
    @JvmName("iwlsfeolditclqcl")
    public suspend fun backupRetentionPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupRetentionPeriod = mapped
    }

    /**
     * @param value The cluster identifier. If omitted, this provider will assign a random, unique identifier.
     */
    @JvmName("qsxmllarwavfcjee")
    public suspend fun clusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterIdentifier = mapped
    }

    /**
     * @param value Creates a unique cluster identifier beginning with the specified prefix. Conflicts with `cluster_identifier`.
     */
    @JvmName("xohbceydodkqfobt")
    public suspend fun clusterIdentifierPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterIdentifierPrefix = mapped
    }

    /**
     * @param value If set to true, tags are copied to any snapshot of the DB cluster that is created.
     */
    @JvmName("larwqlnhcbhmemdd")
    public suspend fun copyTagsToSnapshot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyTagsToSnapshot = mapped
    }

    /**
     * @param value A value that indicates whether the DB cluster has deletion protection enabled.The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
     */
    @JvmName("vbcgixlrokgxukyc")
    public suspend fun deletionProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionProtection = mapped
    }

    /**
     * @param value A list of the log types this DB cluster is configured to export to Cloudwatch Logs. Currently only supports `audit` and `slowquery`.
     */
    @JvmName("kwggwjrykifsream")
    public suspend fun enableCloudwatchLogsExports(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableCloudwatchLogsExports = mapped
    }

    /**
     * @param values A list of the log types this DB cluster is configured to export to Cloudwatch Logs. Currently only supports `audit` and `slowquery`.
     */
    @JvmName("qudhyfnvcbwjmlcd")
    public suspend fun enableCloudwatchLogsExports(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enableCloudwatchLogsExports = mapped
    }

    /**
     * @param value The name of the database engine to be used for this Neptune cluster. Defaults to `neptune`.
     */
    @JvmName("jmijnevndeouksmn")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engine = mapped
    }

    /**
     * @param value The database engine version.
     */
    @JvmName("jeelihcfomaoxhub")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineVersion = mapped
    }

    /**
     * @param value The name of your final Neptune snapshot when this Neptune cluster is deleted. If omitted, no final snapshot will be made.
     */
    @JvmName("pkgnuftmkedbxhje")
    public suspend fun finalSnapshotIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.finalSnapshotIdentifier = mapped
    }

    /**
     * @param value The global cluster identifier specified on `aws.neptune.GlobalCluster`.
     */
    @JvmName("pnipabfhvhcwdjnv")
    public suspend fun globalClusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalClusterIdentifier = mapped
    }

    /**
     * @param value Specifies whether or not mappings of AWS Identity and Access Management (IAM) accounts to database accounts is enabled.
     */
    @JvmName("ccuaidhwqflkrahy")
    public suspend fun iamDatabaseAuthenticationEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamDatabaseAuthenticationEnabled = mapped
    }

    /**
     * @param value A List of ARNs for the IAM roles to associate to the Neptune Cluster.
     */
    @JvmName("pubygytussttitik")
    public suspend fun iamRoles(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamRoles = mapped
    }

    /**
     * @param values A List of ARNs for the IAM roles to associate to the Neptune Cluster.
     */
    @JvmName("nutuioairipwrjtd")
    public suspend fun iamRoles(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.iamRoles = mapped
    }

    /**
     * @param value The ARN for the KMS encryption key. When specifying `kms_key_arn`, `storage_encrypted` needs to be set to true.
     */
    @JvmName("ovjlbcwyuqioeyvv")
    public suspend fun kmsKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    /**
     * @param value A cluster parameter group to associate with the cluster.
     */
    @JvmName("lptingunstnxscmb")
    public suspend fun neptuneClusterParameterGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.neptuneClusterParameterGroupName = mapped
    }

    /**
     * @param value The name of the DB parameter group to apply to all instances of the DB cluster.
     */
    @JvmName("lnqmnnqrkswhyrid")
    public suspend fun neptuneInstanceParameterGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.neptuneInstanceParameterGroupName = mapped
    }

    /**
     * @param value A Neptune subnet group to associate with this Neptune instance.
     */
    @JvmName("fyhnwfglptwrrtpi")
    public suspend fun neptuneSubnetGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.neptuneSubnetGroupName = mapped
    }

    /**
     * @param value The port on which the Neptune accepts connections. Default is `8182`.
     */
    @JvmName("xhsxpapeswfmbrho")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The daily time range during which automated backups are created if automated backups are enabled using the BackupRetentionPeriod parameter. Time in UTC. Default: A 30-minute window selected at random from an 8-hour block of time per regionE.g., 04:00-09:00
     */
    @JvmName("adtbvvippyxukhin")
    public suspend fun preferredBackupWindow(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredBackupWindow = mapped
    }

    /**
     * @param value The weekly time range during which system maintenance can occur, in (UTC) e.g., wed:04:00-wed:04:30
     */
    @JvmName("peerbkinrgenfpcv")
    public suspend fun preferredMaintenanceWindow(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredMaintenanceWindow = mapped
    }

    /**
     * @param value ARN of a source Neptune cluster or Neptune instance if this Neptune cluster is to be created as a Read Replica.
     */
    @JvmName("fyannmeamqmcmftk")
    public suspend fun replicationSourceIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationSourceIdentifier = mapped
    }

    /**
     * @param value If set, create the Neptune cluster as a serverless one. See Serverless for example block attributes.
     */
    @JvmName("spdouynrwuugafxb")
    public suspend fun serverlessV2ScalingConfiguration(`value`: ClusterServerlessV2ScalingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverlessV2ScalingConfiguration = mapped
    }

    /**
     * @param argument If set, create the Neptune cluster as a serverless one. See Serverless for example block attributes.
     */
    @JvmName("tnwjwkjdbakqwelo")
    public suspend fun serverlessV2ScalingConfiguration(argument: suspend ClusterServerlessV2ScalingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterServerlessV2ScalingConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.serverlessV2ScalingConfiguration = mapped
    }

    /**
     * @param value Determines whether a final Neptune snapshot is created before the Neptune cluster is deleted. If true is specified, no Neptune snapshot is created. If false is specified, a Neptune snapshot is created before the Neptune cluster is deleted, using the value from `final_snapshot_identifier`. Default is `false`.
     */
    @JvmName("mfbqtrujqwxwqgim")
    public suspend fun skipFinalSnapshot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipFinalSnapshot = mapped
    }

    /**
     * @param value Specifies whether or not to create this cluster from a snapshot. You can use either the name or ARN when specifying a Neptune cluster snapshot, or the ARN when specifying a Neptune snapshot. Automated snapshots **should not** be used for this attribute, unless from a different cluster. Automated snapshots are deleted as part of cluster destruction when the resource is replaced.
     */
    @JvmName("tcnavthesctbxvfu")
    public suspend fun snapshotIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotIdentifier = mapped
    }

    /**
     * @param value Specifies whether the Neptune cluster is encrypted. The default is `false` if not specified.
     */
    @JvmName("grssscigoofjfhfh")
    public suspend fun storageEncrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageEncrypted = mapped
    }

    /**
     * @param value Storage type associated with the cluster `standard/iopt1`. Default: `standard`
     */
    @JvmName("gxubyfgspgemaleg")
    public suspend fun storageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageType = mapped
    }

    /**
     * @param value A map of tags to assign to the Neptune cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wrarqlxigfirftye")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the Neptune cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("oqynikdjtnvyyrje")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value List of VPC security groups to associate with the Cluster
     */
    @JvmName("tqffuahrkbclpxcl")
    public suspend fun vpcSecurityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    /**
     * @param values List of VPC security groups to associate with the Cluster
     */
    @JvmName("swfwbsxbkxdutdfr")
    public suspend fun vpcSecurityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    internal fun build(): ClusterArgs = ClusterArgs(
        allowMajorVersionUpgrade = allowMajorVersionUpgrade,
        applyImmediately = applyImmediately,
        availabilityZones = availabilityZones,
        backupRetentionPeriod = backupRetentionPeriod,
        clusterIdentifier = clusterIdentifier,
        clusterIdentifierPrefix = clusterIdentifierPrefix,
        copyTagsToSnapshot = copyTagsToSnapshot,
        deletionProtection = deletionProtection,
        enableCloudwatchLogsExports = enableCloudwatchLogsExports,
        engine = engine,
        engineVersion = engineVersion,
        finalSnapshotIdentifier = finalSnapshotIdentifier,
        globalClusterIdentifier = globalClusterIdentifier,
        iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled,
        iamRoles = iamRoles,
        kmsKeyArn = kmsKeyArn,
        neptuneClusterParameterGroupName = neptuneClusterParameterGroupName,
        neptuneInstanceParameterGroupName = neptuneInstanceParameterGroupName,
        neptuneSubnetGroupName = neptuneSubnetGroupName,
        port = port,
        preferredBackupWindow = preferredBackupWindow,
        preferredMaintenanceWindow = preferredMaintenanceWindow,
        replicationSourceIdentifier = replicationSourceIdentifier,
        serverlessV2ScalingConfiguration = serverlessV2ScalingConfiguration,
        skipFinalSnapshot = skipFinalSnapshot,
        snapshotIdentifier = snapshotIdentifier,
        storageEncrypted = storageEncrypted,
        storageType = storageType,
        tags = tags,
        vpcSecurityGroupIds = vpcSecurityGroupIds,
    )
}
