@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.neptune.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ClusterEndpoint].
 */
@PulumiTagMarker
public class ClusterEndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterEndpointArgs = ClusterEndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterEndpointArgsBuilder.() -> Unit) {
        val builder = ClusterEndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ClusterEndpoint {
        val builtJavaResource = com.pulumi.aws.neptune.ClusterEndpoint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ClusterEndpoint(builtJavaResource)
    }
}

/**
 * Provides an Neptune Cluster Endpoint Resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.neptune.ClusterEndpoint("example", {
 *     clusterIdentifier: test.clusterIdentifier,
 *     clusterEndpointIdentifier: "example",
 *     endpointType: "READER",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.neptune.ClusterEndpoint("example",
 *     cluster_identifier=test["clusterIdentifier"],
 *     cluster_endpoint_identifier="example",
 *     endpoint_type="READER")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Neptune.ClusterEndpoint("example", new()
 *     {
 *         ClusterIdentifier = test.ClusterIdentifier,
 *         ClusterEndpointIdentifier = "example",
 *         EndpointType = "READER",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/neptune"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := neptune.NewClusterEndpoint(ctx, "example", &neptune.ClusterEndpointArgs{
 * 			ClusterIdentifier:         pulumi.Any(test.ClusterIdentifier),
 * 			ClusterEndpointIdentifier: pulumi.String("example"),
 * 			EndpointType:              pulumi.String("READER"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.neptune.ClusterEndpoint;
 * import com.pulumi.aws.neptune.ClusterEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ClusterEndpoint("example", ClusterEndpointArgs.builder()
 *             .clusterIdentifier(test.clusterIdentifier())
 *             .clusterEndpointIdentifier("example")
 *             .endpointType("READER")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:neptune:ClusterEndpoint
 *     properties:
 *       clusterIdentifier: ${test.clusterIdentifier}
 *       clusterEndpointIdentifier: example
 *       endpointType: READER
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_neptune_cluster_endpoint` using the `cluster-identifier:endpoint-identfier`. For example:
 * ```sh
 * $ pulumi import aws:neptune/clusterEndpoint:ClusterEndpoint example my-cluster:my-endpoint
 * ```
 */
public class ClusterEndpoint internal constructor(
    override val javaResource: com.pulumi.aws.neptune.ClusterEndpoint,
) : KotlinCustomResource(javaResource, ClusterEndpointMapper) {
    /**
     * The Neptune Cluster Endpoint Amazon Resource Name (ARN).
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The identifier of the endpoint.
     */
    public val clusterEndpointIdentifier: Output<String>
        get() = javaResource.clusterEndpointIdentifier().applyValue({ args0 -> args0 })

    /**
     * The DB cluster identifier of the DB cluster associated with the endpoint.
     */
    public val clusterIdentifier: Output<String>
        get() = javaResource.clusterIdentifier().applyValue({ args0 -> args0 })

    /**
     * The DNS address of the endpoint.
     */
    public val endpoint: Output<String>
        get() = javaResource.endpoint().applyValue({ args0 -> args0 })

    /**
     * The type of the endpoint. One of: `READER`, `WRITER`, `ANY`.
     */
    public val endpointType: Output<String>
        get() = javaResource.endpointType().applyValue({ args0 -> args0 })

    /**
     * List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.
     */
    public val excludedMembers: Output<List<String>>?
        get() = javaResource.excludedMembers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * List of DB instance identifiers that are part of the custom endpoint group.
     */
    public val staticMembers: Output<List<String>>?
        get() = javaResource.staticMembers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the Neptune cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ClusterEndpointMapper : ResourceMapper<ClusterEndpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.neptune.ClusterEndpoint::class == javaResource::class

    override fun map(javaResource: Resource): ClusterEndpoint = ClusterEndpoint(
        javaResource as
            com.pulumi.aws.neptune.ClusterEndpoint,
    )
}

/**
 * @see [ClusterEndpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ClusterEndpoint].
 */
public suspend fun clusterEndpoint(
    name: String,
    block: suspend ClusterEndpointResourceBuilder.() -> Unit,
): ClusterEndpoint {
    val builder = ClusterEndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ClusterEndpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun clusterEndpoint(name: String): ClusterEndpoint {
    val builder = ClusterEndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
