@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.neptune.kotlin

import com.pulumi.aws.neptune.ClusterEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Neptune Cluster Endpoint Resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.neptune.ClusterEndpoint("example", {
 *     clusterIdentifier: test.clusterIdentifier,
 *     clusterEndpointIdentifier: "example",
 *     endpointType: "READER",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.neptune.ClusterEndpoint("example",
 *     cluster_identifier=test["clusterIdentifier"],
 *     cluster_endpoint_identifier="example",
 *     endpoint_type="READER")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Neptune.ClusterEndpoint("example", new()
 *     {
 *         ClusterIdentifier = test.ClusterIdentifier,
 *         ClusterEndpointIdentifier = "example",
 *         EndpointType = "READER",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/neptune"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := neptune.NewClusterEndpoint(ctx, "example", &neptune.ClusterEndpointArgs{
 * 			ClusterIdentifier:         pulumi.Any(test.ClusterIdentifier),
 * 			ClusterEndpointIdentifier: pulumi.String("example"),
 * 			EndpointType:              pulumi.String("READER"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.neptune.ClusterEndpoint;
 * import com.pulumi.aws.neptune.ClusterEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ClusterEndpoint("example", ClusterEndpointArgs.builder()
 *             .clusterIdentifier(test.clusterIdentifier())
 *             .clusterEndpointIdentifier("example")
 *             .endpointType("READER")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:neptune:ClusterEndpoint
 *     properties:
 *       clusterIdentifier: ${test.clusterIdentifier}
 *       clusterEndpointIdentifier: example
 *       endpointType: READER
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_neptune_cluster_endpoint` using the `cluster-identifier:endpoint-identfier`. For example:
 * ```sh
 * $ pulumi import aws:neptune/clusterEndpoint:ClusterEndpoint example my-cluster:my-endpoint
 * ```
 * @property clusterEndpointIdentifier The identifier of the endpoint.
 * @property clusterIdentifier The DB cluster identifier of the DB cluster associated with the endpoint.
 * @property endpointType The type of the endpoint. One of: `READER`, `WRITER`, `ANY`.
 * @property excludedMembers List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.
 * @property staticMembers List of DB instance identifiers that are part of the custom endpoint group.
 * @property tags A map of tags to assign to the Neptune cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ClusterEndpointArgs(
    public val clusterEndpointIdentifier: Output<String>? = null,
    public val clusterIdentifier: Output<String>? = null,
    public val endpointType: Output<String>? = null,
    public val excludedMembers: Output<List<String>>? = null,
    public val staticMembers: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.neptune.ClusterEndpointArgs> {
    override fun toJava(): com.pulumi.aws.neptune.ClusterEndpointArgs =
        com.pulumi.aws.neptune.ClusterEndpointArgs.builder()
            .clusterEndpointIdentifier(clusterEndpointIdentifier?.applyValue({ args0 -> args0 }))
            .clusterIdentifier(clusterIdentifier?.applyValue({ args0 -> args0 }))
            .endpointType(endpointType?.applyValue({ args0 -> args0 }))
            .excludedMembers(excludedMembers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .staticMembers(staticMembers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ClusterEndpointArgs].
 */
@PulumiTagMarker
public class ClusterEndpointArgsBuilder internal constructor() {
    private var clusterEndpointIdentifier: Output<String>? = null

    private var clusterIdentifier: Output<String>? = null

    private var endpointType: Output<String>? = null

    private var excludedMembers: Output<List<String>>? = null

    private var staticMembers: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The identifier of the endpoint.
     */
    @JvmName("yibbefvtrhtyttex")
    public suspend fun clusterEndpointIdentifier(`value`: Output<String>) {
        this.clusterEndpointIdentifier = value
    }

    /**
     * @param value The DB cluster identifier of the DB cluster associated with the endpoint.
     */
    @JvmName("jkxiwyjmpnflohwp")
    public suspend fun clusterIdentifier(`value`: Output<String>) {
        this.clusterIdentifier = value
    }

    /**
     * @param value The type of the endpoint. One of: `READER`, `WRITER`, `ANY`.
     */
    @JvmName("gpnnicfgignfwrlk")
    public suspend fun endpointType(`value`: Output<String>) {
        this.endpointType = value
    }

    /**
     * @param value List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.
     */
    @JvmName("mbyxmbdlpihjccvw")
    public suspend fun excludedMembers(`value`: Output<List<String>>) {
        this.excludedMembers = value
    }

    @JvmName("jpuyqfifgjtphjle")
    public suspend fun excludedMembers(vararg values: Output<String>) {
        this.excludedMembers = Output.all(values.asList())
    }

    /**
     * @param values List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.
     */
    @JvmName("tdsnmtixwprvffpg")
    public suspend fun excludedMembers(values: List<Output<String>>) {
        this.excludedMembers = Output.all(values)
    }

    /**
     * @param value List of DB instance identifiers that are part of the custom endpoint group.
     */
    @JvmName("rpbcykcgwgfdqcrd")
    public suspend fun staticMembers(`value`: Output<List<String>>) {
        this.staticMembers = value
    }

    @JvmName("xaoyuxtjhrkypnhy")
    public suspend fun staticMembers(vararg values: Output<String>) {
        this.staticMembers = Output.all(values.asList())
    }

    /**
     * @param values List of DB instance identifiers that are part of the custom endpoint group.
     */
    @JvmName("krdievuggslhfvuy")
    public suspend fun staticMembers(values: List<Output<String>>) {
        this.staticMembers = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the Neptune cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lsbmcfqjdxdgndwe")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The identifier of the endpoint.
     */
    @JvmName("mrrvnanacdeyjpuu")
    public suspend fun clusterEndpointIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterEndpointIdentifier = mapped
    }

    /**
     * @param value The DB cluster identifier of the DB cluster associated with the endpoint.
     */
    @JvmName("cshmvgynkcpqjqus")
    public suspend fun clusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterIdentifier = mapped
    }

    /**
     * @param value The type of the endpoint. One of: `READER`, `WRITER`, `ANY`.
     */
    @JvmName("mlmbdwdbwmfhkkgw")
    public suspend fun endpointType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.
     */
    @JvmName("crieebhsktoixnek")
    public suspend fun excludedMembers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludedMembers = mapped
    }

    /**
     * @param values List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.
     */
    @JvmName("qlxhtordbjxcpwbh")
    public suspend fun excludedMembers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludedMembers = mapped
    }

    /**
     * @param value List of DB instance identifiers that are part of the custom endpoint group.
     */
    @JvmName("osghjrwhtpsprrrc")
    public suspend fun staticMembers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.staticMembers = mapped
    }

    /**
     * @param values List of DB instance identifiers that are part of the custom endpoint group.
     */
    @JvmName("kylmyqphvasfafnh")
    public suspend fun staticMembers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.staticMembers = mapped
    }

    /**
     * @param value A map of tags to assign to the Neptune cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xvsftuoxavsqvyan")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the Neptune cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nadxrtehdbakoday")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ClusterEndpointArgs = ClusterEndpointArgs(
        clusterEndpointIdentifier = clusterEndpointIdentifier,
        clusterIdentifier = clusterIdentifier,
        endpointType = endpointType,
        excludedMembers = excludedMembers,
        staticMembers = staticMembers,
        tags = tags,
    )
}
