@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.neptune.kotlin

import com.pulumi.aws.neptune.kotlin.outputs.ClusterParameterGroupParameter
import com.pulumi.aws.neptune.kotlin.outputs.ClusterParameterGroupParameter.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ClusterParameterGroup].
 */
@PulumiTagMarker
public class ClusterParameterGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterParameterGroupArgs = ClusterParameterGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterParameterGroupArgsBuilder.() -> Unit) {
        val builder = ClusterParameterGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ClusterParameterGroup {
        val builtJavaResource = com.pulumi.aws.neptune.ClusterParameterGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ClusterParameterGroup(builtJavaResource)
    }
}

/**
 * Manages a Neptune Cluster Parameter Group
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.neptune.ClusterParameterGroup("example", {
 *     family: "neptune1",
 *     name: "example",
 *     description: "neptune cluster parameter group",
 *     parameters: [{
 *         name: "neptune_enable_audit_log",
 *         value: "1",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.neptune.ClusterParameterGroup("example",
 *     family="neptune1",
 *     name="example",
 *     description="neptune cluster parameter group",
 *     parameters=[{
 *         "name": "neptune_enable_audit_log",
 *         "value": "1",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Neptune.ClusterParameterGroup("example", new()
 *     {
 *         Family = "neptune1",
 *         Name = "example",
 *         Description = "neptune cluster parameter group",
 *         Parameters = new[]
 *         {
 *             new Aws.Neptune.Inputs.ClusterParameterGroupParameterArgs
 *             {
 *                 Name = "neptune_enable_audit_log",
 *                 Value = "1",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/neptune"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := neptune.NewClusterParameterGroup(ctx, "example", &neptune.ClusterParameterGroupArgs{
 * 			Family:      pulumi.String("neptune1"),
 * 			Name:        pulumi.String("example"),
 * 			Description: pulumi.String("neptune cluster parameter group"),
 * 			Parameters: neptune.ClusterParameterGroupParameterArray{
 * 				&neptune.ClusterParameterGroupParameterArgs{
 * 					Name:  pulumi.String("neptune_enable_audit_log"),
 * 					Value: pulumi.String("1"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.neptune.ClusterParameterGroup;
 * import com.pulumi.aws.neptune.ClusterParameterGroupArgs;
 * import com.pulumi.aws.neptune.inputs.ClusterParameterGroupParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ClusterParameterGroup("example", ClusterParameterGroupArgs.builder()
 *             .family("neptune1")
 *             .name("example")
 *             .description("neptune cluster parameter group")
 *             .parameters(ClusterParameterGroupParameterArgs.builder()
 *                 .name("neptune_enable_audit_log")
 *                 .value(1)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:neptune:ClusterParameterGroup
 *     properties:
 *       family: neptune1
 *       name: example
 *       description: neptune cluster parameter group
 *       parameters:
 *         - name: neptune_enable_audit_log
 *           value: 1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Neptune Cluster Parameter Groups using the `name`. For example:
 * ```sh
 * $ pulumi import aws:neptune/clusterParameterGroup:ClusterParameterGroup cluster_pg production-pg-1
 * ```
 */
public class ClusterParameterGroup internal constructor(
    override val javaResource: com.pulumi.aws.neptune.ClusterParameterGroup,
) : KotlinCustomResource(javaResource, ClusterParameterGroupMapper) {
    /**
     * The ARN of the neptune cluster parameter group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The description of the neptune cluster parameter group. Defaults to "Managed by Pulumi".
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The family of the neptune cluster parameter group.
     */
    public val family: Output<String>
        get() = javaResource.family().applyValue({ args0 -> args0 })

    /**
     * The name of the neptune parameter.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * A list of neptune parameters to apply.
     */
    public val parameters: Output<List<ClusterParameterGroupParameter>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ClusterParameterGroupMapper : ResourceMapper<ClusterParameterGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.neptune.ClusterParameterGroup::class == javaResource::class

    override fun map(javaResource: Resource): ClusterParameterGroup =
        ClusterParameterGroup(javaResource as com.pulumi.aws.neptune.ClusterParameterGroup)
}

/**
 * @see [ClusterParameterGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ClusterParameterGroup].
 */
public suspend fun clusterParameterGroup(
    name: String,
    block: suspend ClusterParameterGroupResourceBuilder.() -> Unit,
): ClusterParameterGroup {
    val builder = ClusterParameterGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ClusterParameterGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun clusterParameterGroup(name: String): ClusterParameterGroup {
    val builder = ClusterParameterGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
