@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.neptune.kotlin

import com.pulumi.aws.neptune.ClusterSnapshotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages a Neptune database cluster snapshot.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.neptune.ClusterSnapshot("example", {
 *     dbClusterIdentifier: exampleAwsNeptuneCluster.id,
 *     dbClusterSnapshotIdentifier: "resourcetestsnapshot1234",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.neptune.ClusterSnapshot("example",
 *     db_cluster_identifier=example_aws_neptune_cluster["id"],
 *     db_cluster_snapshot_identifier="resourcetestsnapshot1234")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Neptune.ClusterSnapshot("example", new()
 *     {
 *         DbClusterIdentifier = exampleAwsNeptuneCluster.Id,
 *         DbClusterSnapshotIdentifier = "resourcetestsnapshot1234",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/neptune"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := neptune.NewClusterSnapshot(ctx, "example", &neptune.ClusterSnapshotArgs{
 * 			DbClusterIdentifier:         pulumi.Any(exampleAwsNeptuneCluster.Id),
 * 			DbClusterSnapshotIdentifier: pulumi.String("resourcetestsnapshot1234"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.neptune.ClusterSnapshot;
 * import com.pulumi.aws.neptune.ClusterSnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ClusterSnapshot("example", ClusterSnapshotArgs.builder()
 *             .dbClusterIdentifier(exampleAwsNeptuneCluster.id())
 *             .dbClusterSnapshotIdentifier("resourcetestsnapshot1234")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:neptune:ClusterSnapshot
 *     properties:
 *       dbClusterIdentifier: ${exampleAwsNeptuneCluster.id}
 *       dbClusterSnapshotIdentifier: resourcetestsnapshot1234
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_neptune_cluster_snapshot` using the cluster snapshot identifier. For example:
 * ```sh
 * $ pulumi import aws:neptune/clusterSnapshot:ClusterSnapshot example my-cluster-snapshot
 * ```
 * @property dbClusterIdentifier The DB Cluster Identifier from which to take the snapshot.
 * @property dbClusterSnapshotIdentifier The Identifier for the snapshot.
 */
public data class ClusterSnapshotArgs(
    public val dbClusterIdentifier: Output<String>? = null,
    public val dbClusterSnapshotIdentifier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.neptune.ClusterSnapshotArgs> {
    override fun toJava(): com.pulumi.aws.neptune.ClusterSnapshotArgs =
        com.pulumi.aws.neptune.ClusterSnapshotArgs.builder()
            .dbClusterIdentifier(dbClusterIdentifier?.applyValue({ args0 -> args0 }))
            .dbClusterSnapshotIdentifier(dbClusterSnapshotIdentifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterSnapshotArgs].
 */
@PulumiTagMarker
public class ClusterSnapshotArgsBuilder internal constructor() {
    private var dbClusterIdentifier: Output<String>? = null

    private var dbClusterSnapshotIdentifier: Output<String>? = null

    /**
     * @param value The DB Cluster Identifier from which to take the snapshot.
     */
    @JvmName("nvvbgwhiewlwreru")
    public suspend fun dbClusterIdentifier(`value`: Output<String>) {
        this.dbClusterIdentifier = value
    }

    /**
     * @param value The Identifier for the snapshot.
     */
    @JvmName("awryijxxbfnudtam")
    public suspend fun dbClusterSnapshotIdentifier(`value`: Output<String>) {
        this.dbClusterSnapshotIdentifier = value
    }

    /**
     * @param value The DB Cluster Identifier from which to take the snapshot.
     */
    @JvmName("dwlbreboxgtpkvxu")
    public suspend fun dbClusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterIdentifier = mapped
    }

    /**
     * @param value The Identifier for the snapshot.
     */
    @JvmName("oypemhdaqmmviroa")
    public suspend fun dbClusterSnapshotIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterSnapshotIdentifier = mapped
    }

    internal fun build(): ClusterSnapshotArgs = ClusterSnapshotArgs(
        dbClusterIdentifier = dbClusterIdentifier,
        dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier,
    )
}
