@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.neptune.kotlin

import com.pulumi.aws.neptune.EventSubscriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _default = new aws.neptune.Cluster("default", {
 *     clusterIdentifier: "neptune-cluster-demo",
 *     engine: "neptune",
 *     backupRetentionPeriod: 5,
 *     preferredBackupWindow: "07:00-09:00",
 *     skipFinalSnapshot: true,
 *     iamDatabaseAuthenticationEnabled: true,
 *     applyImmediately: true,
 * });
 * const example = new aws.neptune.ClusterInstance("example", {
 *     clusterIdentifier: _default.id,
 *     engine: "neptune",
 *     instanceClass: "db.r4.large",
 *     applyImmediately: true,
 * });
 * const defaultTopic = new aws.sns.Topic("default", {name: "neptune-events"});
 * const defaultEventSubscription = new aws.neptune.EventSubscription("default", {
 *     name: "neptune-event-sub",
 *     snsTopicArn: defaultTopic.arn,
 *     sourceType: "db-instance",
 *     sourceIds: [example&#46;id],
 *     eventCategories: [
 *         "maintenance",
 *         "availability",
 *         "creation",
 *         "backup",
 *         "restoration",
 *         "recovery",
 *         "deletion",
 *         "failover",
 *         "failure",
 *         "notification",
 *         "configuration change",
 *         "read replica",
 *     ],
 *     tags: {
 *         env: "test",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * default = aws.neptune.Cluster("default",
 *     cluster_identifier="neptune-cluster-demo",
 *     engine="neptune",
 *     backup_retention_period=5,
 *     preferred_backup_window="07:00-09:00",
 *     skip_final_snapshot=True,
 *     iam_database_authentication_enabled=True,
 *     apply_immediately=True)
 * example = aws.neptune.ClusterInstance("example",
 *     cluster_identifier=default.id,
 *     engine="neptune",
 *     instance_class="db.r4.large",
 *     apply_immediately=True)
 * default_topic = aws.sns.Topic("default", name="neptune-events")
 * default_event_subscription = aws.neptune.EventSubscription("default",
 *     name="neptune-event-sub",
 *     sns_topic_arn=default_topic.arn,
 *     source_type="db-instance",
 *     source_ids=[example&#46;id],
 *     event_categories=[
 *         "maintenance",
 *         "availability",
 *         "creation",
 *         "backup",
 *         "restoration",
 *         "recovery",
 *         "deletion",
 *         "failover",
 *         "failure",
 *         "notification",
 *         "configuration change",
 *         "read replica",
 *     ],
 *     tags={
 *         "env": "test",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.Neptune.Cluster("default", new()
 *     {
 *         ClusterIdentifier = "neptune-cluster-demo",
 *         Engine = "neptune",
 *         BackupRetentionPeriod = 5,
 *         PreferredBackupWindow = "07:00-09:00",
 *         SkipFinalSnapshot = true,
 *         IamDatabaseAuthenticationEnabled = true,
 *         ApplyImmediately = true,
 *     });
 *     var example = new Aws.Neptune.ClusterInstance("example", new()
 *     {
 *         ClusterIdentifier = @default.Id,
 *         Engine = "neptune",
 *         InstanceClass = "db.r4.large",
 *         ApplyImmediately = true,
 *     });
 *     var defaultTopic = new Aws.Sns.Topic("default", new()
 *     {
 *         Name = "neptune-events",
 *     });
 *     var defaultEventSubscription = new Aws.Neptune.EventSubscription("default", new()
 *     {
 *         Name = "neptune-event-sub",
 *         SnsTopicArn = defaultTopic.Arn,
 *         SourceType = "db-instance",
 *         SourceIds = new[]
 *         {
 *             example.Id,
 *         },
 *         EventCategories = new[]
 *         {
 *             "maintenance",
 *             "availability",
 *             "creation",
 *             "backup",
 *             "restoration",
 *             "recovery",
 *             "deletion",
 *             "failover",
 *             "failure",
 *             "notification",
 *             "configuration change",
 *             "read replica",
 *         },
 *         Tags =
 *         {
 *             { "env", "test" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/neptune"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := neptune.NewCluster(ctx, "default", &neptune.ClusterArgs{
 * 			ClusterIdentifier:                pulumi.String("neptune-cluster-demo"),
 * 			Engine:                           pulumi.String("neptune"),
 * 			BackupRetentionPeriod:            pulumi.Int(5),
 * 			PreferredBackupWindow:            pulumi.String("07:00-09:00"),
 * 			SkipFinalSnapshot:                pulumi.Bool(true),
 * 			IamDatabaseAuthenticationEnabled: pulumi.Bool(true),
 * 			ApplyImmediately:                 pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := neptune.NewClusterInstance(ctx, "example", &neptune.ClusterInstanceArgs{
 * 			ClusterIdentifier: _default.ID(),
 * 			Engine:            pulumi.String("neptune"),
 * 			InstanceClass:     pulumi.String("db.r4.large"),
 * 			ApplyImmediately:  pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultTopic, err := sns.NewTopic(ctx, "default", &sns.TopicArgs{
 * 			Name: pulumi.String("neptune-events"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = neptune.NewEventSubscription(ctx, "default", &neptune.EventSubscriptionArgs{
 * 			Name:        pulumi.String("neptune-event-sub"),
 * 			SnsTopicArn: defaultTopic.Arn,
 * 			SourceType:  pulumi.String("db-instance"),
 * 			SourceIds: pulumi.StringArray{
 * 				example.ID(),
 * 			},
 * 			EventCategories: pulumi.StringArray{
 * 				pulumi.String("maintenance"),
 * 				pulumi.String("availability"),
 * 				pulumi.String("creation"),
 * 				pulumi.String("backup"),
 * 				pulumi.String("restoration"),
 * 				pulumi.String("recovery"),
 * 				pulumi.String("deletion"),
 * 				pulumi.String("failover"),
 * 				pulumi.String("failure"),
 * 				pulumi.String("notification"),
 * 				pulumi.String("configuration change"),
 * 				pulumi.String("read replica"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"env": pulumi.String("test"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.neptune.Cluster;
 * import com.pulumi.aws.neptune.ClusterArgs;
 * import com.pulumi.aws.neptune.ClusterInstance;
 * import com.pulumi.aws.neptune.ClusterInstanceArgs;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.sns.TopicArgs;
 * import com.pulumi.aws.neptune.EventSubscription;
 * import com.pulumi.aws.neptune.EventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Cluster("default", ClusterArgs.builder()
 *             .clusterIdentifier("neptune-cluster-demo")
 *             .engine("neptune")
 *             .backupRetentionPeriod(5)
 *             .preferredBackupWindow("07:00-09:00")
 *             .skipFinalSnapshot(true)
 *             .iamDatabaseAuthenticationEnabled("true")
 *             .applyImmediately("true")
 *             .build());
 *         var example = new ClusterInstance("example", ClusterInstanceArgs.builder()
 *             .clusterIdentifier(default_.id())
 *             .engine("neptune")
 *             .instanceClass("db.r4.large")
 *             .applyImmediately("true")
 *             .build());
 *         var defaultTopic = new Topic("defaultTopic", TopicArgs.builder()
 *             .name("neptune-events")
 *             .build());
 *         var defaultEventSubscription = new EventSubscription("defaultEventSubscription", EventSubscriptionArgs.builder()
 *             .name("neptune-event-sub")
 *             .snsTopicArn(defaultTopic.arn())
 *             .sourceType("db-instance")
 *             .sourceIds(example.id())
 *             .eventCategories(
 *                 "maintenance",
 *                 "availability",
 *                 "creation",
 *                 "backup",
 *                 "restoration",
 *                 "recovery",
 *                 "deletion",
 *                 "failover",
 *                 "failure",
 *                 "notification",
 *                 "configuration change",
 *                 "read replica")
 *             .tags(Map.of("env", "test"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: aws:neptune:Cluster
 *     properties:
 *       clusterIdentifier: neptune-cluster-demo
 *       engine: neptune
 *       backupRetentionPeriod: 5
 *       preferredBackupWindow: 07:00-09:00
 *       skipFinalSnapshot: true
 *       iamDatabaseAuthenticationEnabled: 'true'
 *       applyImmediately: 'true'
 *   example:
 *     type: aws:neptune:ClusterInstance
 *     properties:
 *       clusterIdentifier: ${default.id}
 *       engine: neptune
 *       instanceClass: db.r4.large
 *       applyImmediately: 'true'
 *   defaultTopic:
 *     type: aws:sns:Topic
 *     name: default
 *     properties:
 *       name: neptune-events
 *   defaultEventSubscription:
 *     type: aws:neptune:EventSubscription
 *     name: default
 *     properties:
 *       name: neptune-event-sub
 *       snsTopicArn: ${defaultTopic.arn}
 *       sourceType: db-instance
 *       sourceIds:
 *         - ${example.id}
 *       eventCategories:
 *         - maintenance
 *         - availability
 *         - creation
 *         - backup
 *         - restoration
 *         - recovery
 *         - deletion
 *         - failover
 *         - failure
 *         - notification
 *         - configuration change
 *         - read replica
 *       tags:
 *         env: test
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_neptune_event_subscription` using the event subscription name. For example:
 * ```sh
 * $ pulumi import aws:neptune/eventSubscription:EventSubscription example my-event-subscription
 * ```
 * @property enabled A boolean flag to enable/disable the subscription. Defaults to true.
 * @property eventCategories A list of event categories for a `source_type` that you want to subscribe to. Run `aws neptune describe-event-categories` to find all the event categories.
 * @property name The name of the Neptune event subscription. By default generated by this provider.
 * @property namePrefix The name of the Neptune event subscription. Conflicts with `name`.
 * @property snsTopicArn The ARN of the SNS topic to send events to.
 * @property sourceIds A list of identifiers of the event sources for which events will be returned. If not specified, then all sources are included in the response. If specified, a `source_type` must also be specified.
 * @property sourceType The type of source that will be generating the events. Valid options are `db-instance`, `db-security-group`, `db-parameter-group`, `db-snapshot`, `db-cluster` or `db-cluster-snapshot`. If not set, all sources will be subscribed to.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class EventSubscriptionArgs(
    public val enabled: Output<Boolean>? = null,
    public val eventCategories: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val snsTopicArn: Output<String>? = null,
    public val sourceIds: Output<List<String>>? = null,
    public val sourceType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.neptune.EventSubscriptionArgs> {
    override fun toJava(): com.pulumi.aws.neptune.EventSubscriptionArgs =
        com.pulumi.aws.neptune.EventSubscriptionArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .eventCategories(eventCategories?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .snsTopicArn(snsTopicArn?.applyValue({ args0 -> args0 }))
            .sourceIds(sourceIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceType(sourceType?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EventSubscriptionArgs].
 */
@PulumiTagMarker
public class EventSubscriptionArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var eventCategories: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var snsTopicArn: Output<String>? = null

    private var sourceIds: Output<List<String>>? = null

    private var sourceType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A boolean flag to enable/disable the subscription. Defaults to true.
     */
    @JvmName("kslnpxxyvswugxff")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value A list of event categories for a `source_type` that you want to subscribe to. Run `aws neptune describe-event-categories` to find all the event categories.
     */
    @JvmName("iwgrjnrisqmefulg")
    public suspend fun eventCategories(`value`: Output<List<String>>) {
        this.eventCategories = value
    }

    @JvmName("iuxdfxgfodtgwbkm")
    public suspend fun eventCategories(vararg values: Output<String>) {
        this.eventCategories = Output.all(values.asList())
    }

    /**
     * @param values A list of event categories for a `source_type` that you want to subscribe to. Run `aws neptune describe-event-categories` to find all the event categories.
     */
    @JvmName("scahoutcsedrimkt")
    public suspend fun eventCategories(values: List<Output<String>>) {
        this.eventCategories = Output.all(values)
    }

    /**
     * @param value The name of the Neptune event subscription. By default generated by this provider.
     */
    @JvmName("gllbsonpefxwwmwh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the Neptune event subscription. Conflicts with `name`.
     */
    @JvmName("fkhvauygysgemsgg")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value The ARN of the SNS topic to send events to.
     */
    @JvmName("cfycomvefjuhoyjj")
    public suspend fun snsTopicArn(`value`: Output<String>) {
        this.snsTopicArn = value
    }

    /**
     * @param value A list of identifiers of the event sources for which events will be returned. If not specified, then all sources are included in the response. If specified, a `source_type` must also be specified.
     */
    @JvmName("bhgckcrlbjtwoujc")
    public suspend fun sourceIds(`value`: Output<List<String>>) {
        this.sourceIds = value
    }

    @JvmName("jwnptqpbmiaiddrg")
    public suspend fun sourceIds(vararg values: Output<String>) {
        this.sourceIds = Output.all(values.asList())
    }

    /**
     * @param values A list of identifiers of the event sources for which events will be returned. If not specified, then all sources are included in the response. If specified, a `source_type` must also be specified.
     */
    @JvmName("elrevxsxqqehbdfe")
    public suspend fun sourceIds(values: List<Output<String>>) {
        this.sourceIds = Output.all(values)
    }

    /**
     * @param value The type of source that will be generating the events. Valid options are `db-instance`, `db-security-group`, `db-parameter-group`, `db-snapshot`, `db-cluster` or `db-cluster-snapshot`. If not set, all sources will be subscribed to.
     */
    @JvmName("kyvnbedhhdvwuljc")
    public suspend fun sourceType(`value`: Output<String>) {
        this.sourceType = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("elygljxxjwvrasch")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A boolean flag to enable/disable the subscription. Defaults to true.
     */
    @JvmName("xaxmfemlcxkmhide")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value A list of event categories for a `source_type` that you want to subscribe to. Run `aws neptune describe-event-categories` to find all the event categories.
     */
    @JvmName("snetifqlmbnvbmdg")
    public suspend fun eventCategories(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventCategories = mapped
    }

    /**
     * @param values A list of event categories for a `source_type` that you want to subscribe to. Run `aws neptune describe-event-categories` to find all the event categories.
     */
    @JvmName("qjvctmewqsqcpgmi")
    public suspend fun eventCategories(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventCategories = mapped
    }

    /**
     * @param value The name of the Neptune event subscription. By default generated by this provider.
     */
    @JvmName("pclfstuktdalqugw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the Neptune event subscription. Conflicts with `name`.
     */
    @JvmName("rltcagonjbhwnoxu")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value The ARN of the SNS topic to send events to.
     */
    @JvmName("qxioqnprgbhgwllf")
    public suspend fun snsTopicArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snsTopicArn = mapped
    }

    /**
     * @param value A list of identifiers of the event sources for which events will be returned. If not specified, then all sources are included in the response. If specified, a `source_type` must also be specified.
     */
    @JvmName("tvcjifmkoxdufytf")
    public suspend fun sourceIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIds = mapped
    }

    /**
     * @param values A list of identifiers of the event sources for which events will be returned. If not specified, then all sources are included in the response. If specified, a `source_type` must also be specified.
     */
    @JvmName("ktfviiuextfmjvby")
    public suspend fun sourceIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceIds = mapped
    }

    /**
     * @param value The type of source that will be generating the events. Valid options are `db-instance`, `db-security-group`, `db-parameter-group`, `db-snapshot`, `db-cluster` or `db-cluster-snapshot`. If not set, all sources will be subscribed to.
     */
    @JvmName("fdxfxwjqvkkfpajx")
    public suspend fun sourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bgnfgnwuatsheqym")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("amkcganbvslraegm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): EventSubscriptionArgs = EventSubscriptionArgs(
        enabled = enabled,
        eventCategories = eventCategories,
        name = name,
        namePrefix = namePrefix,
        snsTopicArn = snsTopicArn,
        sourceIds = sourceIds,
        sourceType = sourceType,
        tags = tags,
    )
}
