@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.neptune.kotlin.inputs

import com.pulumi.aws.neptune.inputs.ClusterServerlessV2ScalingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maxCapacity The maximum Neptune Capacity Units (NCUs) for this cluster. Must be lower or equal than **128**. See [AWS Documentation](https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-capacity-scaling.html) for more details.
 * @property minCapacity The minimum Neptune Capacity Units (NCUs) for this cluster. Must be greater or equal than **1**. See [AWS Documentation](https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-capacity-scaling.html) for more details.
 */
public data class ClusterServerlessV2ScalingConfigurationArgs(
    public val maxCapacity: Output<Double>? = null,
    public val minCapacity: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.aws.neptune.inputs.ClusterServerlessV2ScalingConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.neptune.inputs.ClusterServerlessV2ScalingConfigurationArgs =
        com.pulumi.aws.neptune.inputs.ClusterServerlessV2ScalingConfigurationArgs.builder()
            .maxCapacity(maxCapacity?.applyValue({ args0 -> args0 }))
            .minCapacity(minCapacity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterServerlessV2ScalingConfigurationArgs].
 */
@PulumiTagMarker
public class ClusterServerlessV2ScalingConfigurationArgsBuilder internal constructor() {
    private var maxCapacity: Output<Double>? = null

    private var minCapacity: Output<Double>? = null

    /**
     * @param value The maximum Neptune Capacity Units (NCUs) for this cluster. Must be lower or equal than **128**. See [AWS Documentation](https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-capacity-scaling.html) for more details.
     */
    @JvmName("rgilmohjvijsjrkm")
    public suspend fun maxCapacity(`value`: Output<Double>) {
        this.maxCapacity = value
    }

    /**
     * @param value The minimum Neptune Capacity Units (NCUs) for this cluster. Must be greater or equal than **1**. See [AWS Documentation](https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-capacity-scaling.html) for more details.
     */
    @JvmName("bsxkhyhurynvlnaa")
    public suspend fun minCapacity(`value`: Output<Double>) {
        this.minCapacity = value
    }

    /**
     * @param value The maximum Neptune Capacity Units (NCUs) for this cluster. Must be lower or equal than **128**. See [AWS Documentation](https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-capacity-scaling.html) for more details.
     */
    @JvmName("pjjkghvgyutfmsav")
    public suspend fun maxCapacity(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxCapacity = mapped
    }

    /**
     * @param value The minimum Neptune Capacity Units (NCUs) for this cluster. Must be greater or equal than **1**. See [AWS Documentation](https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-capacity-scaling.html) for more details.
     */
    @JvmName("salfaopxmotemegs")
    public suspend fun minCapacity(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minCapacity = mapped
    }

    internal fun build(): ClusterServerlessV2ScalingConfigurationArgs =
        ClusterServerlessV2ScalingConfigurationArgs(
            maxCapacity = maxCapacity,
            minCapacity = minCapacity,
        )
}
