@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.neptune.kotlin.inputs

import com.pulumi.aws.neptune.inputs.GetEngineVersionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEngineVersion.
 * @property engine DB engine. (Default: `neptune`)
 * @property parameterGroupFamily Name of a specific DB parameter group family. An example parameter group family is `neptune1`.
 * @property preferredVersions Ordered list of preferred engine versions. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned. If both the `version` and `preferred_versions` arguments are not configured, the data source will return the default version for the engine.
 * @property version Version of the DB engine. For example, `1.0.1.0`, `1.0.2.2`, and `1.0.3.0`. If both the `version` and `preferred_versions` arguments are not configured, the data source will return the default version for the engine.
 */
public data class GetEngineVersionPlainArgs(
    public val engine: String? = null,
    public val parameterGroupFamily: String? = null,
    public val preferredVersions: List<String>? = null,
    public val version: String? = null,
) : ConvertibleToJava<com.pulumi.aws.neptune.inputs.GetEngineVersionPlainArgs> {
    override fun toJava(): com.pulumi.aws.neptune.inputs.GetEngineVersionPlainArgs =
        com.pulumi.aws.neptune.inputs.GetEngineVersionPlainArgs.builder()
            .engine(engine?.let({ args0 -> args0 }))
            .parameterGroupFamily(parameterGroupFamily?.let({ args0 -> args0 }))
            .preferredVersions(preferredVersions?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .version(version?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEngineVersionPlainArgs].
 */
@PulumiTagMarker
public class GetEngineVersionPlainArgsBuilder internal constructor() {
    private var engine: String? = null

    private var parameterGroupFamily: String? = null

    private var preferredVersions: List<String>? = null

    private var version: String? = null

    /**
     * @param value DB engine. (Default: `neptune`)
     */
    @JvmName("svscwigxjpipoxdj")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.engine = mapped
    }

    /**
     * @param value Name of a specific DB parameter group family. An example parameter group family is `neptune1`.
     */
    @JvmName("alvsvvumfclcufnl")
    public suspend fun parameterGroupFamily(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.parameterGroupFamily = mapped
    }

    /**
     * @param value Ordered list of preferred engine versions. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned. If both the `version` and `preferred_versions` arguments are not configured, the data source will return the default version for the engine.
     */
    @JvmName("pplkgrqtthukqscw")
    public suspend fun preferredVersions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.preferredVersions = mapped
    }

    /**
     * @param values Ordered list of preferred engine versions. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned. If both the `version` and `preferred_versions` arguments are not configured, the data source will return the default version for the engine.
     */
    @JvmName("phrpyljeuhpyaenw")
    public suspend fun preferredVersions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.preferredVersions = mapped
    }

    /**
     * @param value Version of the DB engine. For example, `1.0.1.0`, `1.0.2.2`, and `1.0.3.0`. If both the `version` and `preferred_versions` arguments are not configured, the data source will return the default version for the engine.
     */
    @JvmName("icveehumgbkocnvv")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.version = mapped
    }

    internal fun build(): GetEngineVersionPlainArgs = GetEngineVersionPlainArgs(
        engine = engine,
        parameterGroupFamily = parameterGroupFamily,
        preferredVersions = preferredVersions,
        version = version,
    )
}
