@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.neptune.kotlin.inputs

import com.pulumi.aws.neptune.inputs.ParameterGroupParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applyMethod The apply method of the Neptune parameter. Valid values are `immediate` and `pending-reboot`. Defaults to `pending-reboot`.
 * @property name The name of the Neptune parameter.
 * @property value The value of the Neptune parameter.
 */
public data class ParameterGroupParameterArgs(
    public val applyMethod: Output<String>? = null,
    public val name: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.neptune.inputs.ParameterGroupParameterArgs> {
    override fun toJava(): com.pulumi.aws.neptune.inputs.ParameterGroupParameterArgs =
        com.pulumi.aws.neptune.inputs.ParameterGroupParameterArgs.builder()
            .applyMethod(applyMethod?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ParameterGroupParameterArgs].
 */
@PulumiTagMarker
public class ParameterGroupParameterArgsBuilder internal constructor() {
    private var applyMethod: Output<String>? = null

    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The apply method of the Neptune parameter. Valid values are `immediate` and `pending-reboot`. Defaults to `pending-reboot`.
     */
    @JvmName("bficoshqlaaviuwa")
    public suspend fun applyMethod(`value`: Output<String>) {
        this.applyMethod = value
    }

    /**
     * @param value The name of the Neptune parameter.
     */
    @JvmName("cvtlwsnkjlbnwwkr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The value of the Neptune parameter.
     */
    @JvmName("tmpuvgvfltjfpwjp")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The apply method of the Neptune parameter. Valid values are `immediate` and `pending-reboot`. Defaults to `pending-reboot`.
     */
    @JvmName("gfkyhmmgoyagyyad")
    public suspend fun applyMethod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applyMethod = mapped
    }

    /**
     * @param value The name of the Neptune parameter.
     */
    @JvmName("erdodhpbcerjmsly")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The value of the Neptune parameter.
     */
    @JvmName("chdlxjgengpivhxn")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ParameterGroupParameterArgs = ParameterGroupParameterArgs(
        applyMethod = applyMethod,
        name = name ?: throw PulumiNullFieldException("name"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
