@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.neptune.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 *
 * @property maxCapacity The maximum Neptune Capacity Units (NCUs) for this cluster. Must be lower or equal than **128**. See [AWS Documentation](https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-capacity-scaling.html) for more details.
 * @property minCapacity The minimum Neptune Capacity Units (NCUs) for this cluster. Must be greater or equal than **1**. See [AWS Documentation](https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-capacity-scaling.html) for more details.
 */
public data class ClusterServerlessV2ScalingConfiguration(
    public val maxCapacity: Double? = null,
    public val minCapacity: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.neptune.outputs.ClusterServerlessV2ScalingConfiguration): ClusterServerlessV2ScalingConfiguration = ClusterServerlessV2ScalingConfiguration(
            maxCapacity = javaType.maxCapacity().map({ args0 -> args0 }).orElse(null),
            minCapacity = javaType.minCapacity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
