@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.neptune.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getEngineVersion.
 * @property engine
 * @property engineDescription Description of the database engine.
 * @property exportableLogTypes Set of log types that the database engine has available for export to CloudWatch Logs.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property parameterGroupFamily
 * @property preferredVersions
 * @property supportedTimezones Set of the time zones supported by this engine.
 * @property supportsLogExportsToCloudwatch Indicates whether the engine version supports exporting the log types specified by `exportable_log_types` to CloudWatch Logs.
 * @property supportsReadReplica Indicates whether the database engine version supports read replicas.
 * @property validUpgradeTargets Set of engine versions that this database engine version can be upgraded to.
 * @property version
 * @property versionDescription Description of the database engine version.
 */
public data class GetEngineVersionResult(
    public val engine: String? = null,
    public val engineDescription: String,
    public val exportableLogTypes: List<String>,
    public val id: String,
    public val parameterGroupFamily: String,
    public val preferredVersions: List<String>? = null,
    public val supportedTimezones: List<String>,
    public val supportsLogExportsToCloudwatch: Boolean,
    public val supportsReadReplica: Boolean,
    public val validUpgradeTargets: List<String>,
    public val version: String,
    public val versionDescription: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.neptune.outputs.GetEngineVersionResult): GetEngineVersionResult = GetEngineVersionResult(
            engine = javaType.engine().map({ args0 -> args0 }).orElse(null),
            engineDescription = javaType.engineDescription(),
            exportableLogTypes = javaType.exportableLogTypes().map({ args0 -> args0 }),
            id = javaType.id(),
            parameterGroupFamily = javaType.parameterGroupFamily(),
            preferredVersions = javaType.preferredVersions().map({ args0 -> args0 }),
            supportedTimezones = javaType.supportedTimezones().map({ args0 -> args0 }),
            supportsLogExportsToCloudwatch = javaType.supportsLogExportsToCloudwatch(),
            supportsReadReplica = javaType.supportsReadReplica(),
            validUpgradeTargets = javaType.validUpgradeTargets().map({ args0 -> args0 }),
            version = javaType.version(),
            versionDescription = javaType.versionDescription(),
        )
    }
}
