@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.neptune.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property applyMethod The apply method of the Neptune parameter. Valid values are `immediate` and `pending-reboot`. Defaults to `pending-reboot`.
 * @property name The name of the Neptune parameter.
 * @property value The value of the Neptune parameter.
 */
public data class ParameterGroupParameter(
    public val applyMethod: String? = null,
    public val name: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.neptune.outputs.ParameterGroupParameter): ParameterGroupParameter = ParameterGroupParameter(
            applyMethod = javaType.applyMethod().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            `value` = javaType.`value`(),
        )
    }
}
