@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin

import com.pulumi.aws.networkfirewall.kotlin.outputs.FirewallEncryptionConfiguration
import com.pulumi.aws.networkfirewall.kotlin.outputs.FirewallFirewallStatus
import com.pulumi.aws.networkfirewall.kotlin.outputs.FirewallSubnetMapping
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.networkfirewall.kotlin.outputs.FirewallEncryptionConfiguration.Companion.toKotlin as firewallEncryptionConfigurationToKotlin
import com.pulumi.aws.networkfirewall.kotlin.outputs.FirewallFirewallStatus.Companion.toKotlin as firewallFirewallStatusToKotlin
import com.pulumi.aws.networkfirewall.kotlin.outputs.FirewallSubnetMapping.Companion.toKotlin as firewallSubnetMappingToKotlin

/**
 * Builder for [Firewall].
 */
@PulumiTagMarker
public class FirewallResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FirewallArgs = FirewallArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FirewallArgsBuilder.() -> Unit) {
        val builder = FirewallArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Firewall {
        val builtJavaResource = com.pulumi.aws.networkfirewall.Firewall(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Firewall(builtJavaResource)
    }
}

/**
 * Provides an AWS Network Firewall Firewall Resource
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkfirewall.Firewall("example", {
 *     name: "example",
 *     firewallPolicyArn: exampleAwsNetworkfirewallFirewallPolicy.arn,
 *     vpcId: exampleAwsVpc.id,
 *     subnetMappings: [{
 *         subnetId: exampleAwsSubnet.id,
 *     }],
 *     tags: {
 *         Tag1: "Value1",
 *         Tag2: "Value2",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkfirewall.Firewall("example",
 *     name="example",
 *     firewall_policy_arn=example_aws_networkfirewall_firewall_policy["arn"],
 *     vpc_id=example_aws_vpc["id"],
 *     subnet_mappings=[{
 *         "subnet_id": example_aws_subnet["id"],
 *     }],
 *     tags={
 *         "Tag1": "Value1",
 *         "Tag2": "Value2",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkFirewall.Firewall("example", new()
 *     {
 *         Name = "example",
 *         FirewallPolicyArn = exampleAwsNetworkfirewallFirewallPolicy.Arn,
 *         VpcId = exampleAwsVpc.Id,
 *         SubnetMappings = new[]
 *         {
 *             new Aws.NetworkFirewall.Inputs.FirewallSubnetMappingArgs
 *             {
 *                 SubnetId = exampleAwsSubnet.Id,
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Tag1", "Value1" },
 *             { "Tag2", "Value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkfirewall.NewFirewall(ctx, "example", &networkfirewall.FirewallArgs{
 * 			Name:              pulumi.String("example"),
 * 			FirewallPolicyArn: pulumi.Any(exampleAwsNetworkfirewallFirewallPolicy.Arn),
 * 			VpcId:             pulumi.Any(exampleAwsVpc.Id),
 * 			SubnetMappings: networkfirewall.FirewallSubnetMappingArray{
 * 				&networkfirewall.FirewallSubnetMappingArgs{
 * 					SubnetId: pulumi.Any(exampleAwsSubnet.Id),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Tag1": pulumi.String("Value1"),
 * 				"Tag2": pulumi.String("Value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.Firewall;
 * import com.pulumi.aws.networkfirewall.FirewallArgs;
 * import com.pulumi.aws.networkfirewall.inputs.FirewallSubnetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Firewall("example", FirewallArgs.builder()
 *             .name("example")
 *             .firewallPolicyArn(exampleAwsNetworkfirewallFirewallPolicy.arn())
 *             .vpcId(exampleAwsVpc.id())
 *             .subnetMappings(FirewallSubnetMappingArgs.builder()
 *                 .subnetId(exampleAwsSubnet.id())
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Tag1", "Value1"),
 *                 Map.entry("Tag2", "Value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkfirewall:Firewall
 *     properties:
 *       name: example
 *       firewallPolicyArn: ${exampleAwsNetworkfirewallFirewallPolicy.arn}
 *       vpcId: ${exampleAwsVpc.id}
 *       subnetMappings:
 *         - subnetId: ${exampleAwsSubnet.id}
 *       tags:
 *         Tag1: Value1
 *         Tag2: Value2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Network Firewall Firewalls using their `arn`. For example:
 * ```sh
 * $ pulumi import aws:networkfirewall/firewall:Firewall example arn:aws:network-firewall:us-west-1:123456789012:firewall/example
 * ```
 */
public class Firewall internal constructor(
    override val javaResource: com.pulumi.aws.networkfirewall.Firewall,
) : KotlinCustomResource(javaResource, FirewallMapper) {
    /**
     * The Amazon Resource Name (ARN) that identifies the firewall.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A flag indicating whether the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall that is in use. Defaults to `false`.
     */
    public val deleteProtection: Output<Boolean>?
        get() = javaResource.deleteProtection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A friendly description of the firewall.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * KMS encryption configuration settings. See Encryption Configuration below for details.
     */
    public val encryptionConfiguration: Output<FirewallEncryptionConfiguration>?
        get() = javaResource.encryptionConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> firewallEncryptionConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The Amazon Resource Name (ARN) of the VPC Firewall policy.
     */
    public val firewallPolicyArn: Output<String>
        get() = javaResource.firewallPolicyArn().applyValue({ args0 -> args0 })

    /**
     * A flag indicating whether the firewall is protected against a change to the firewall policy association. Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. Defaults to `false`.
     */
    public val firewallPolicyChangeProtection: Output<Boolean>?
        get() = javaResource.firewallPolicyChangeProtection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Nested list of information about the current status of the firewall.
     */
    public val firewallStatuses: Output<List<FirewallFirewallStatus>>
        get() = javaResource.firewallStatuses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> firewallFirewallStatusToKotlin(args0) })
            })
        })

    /**
     * A friendly name of the firewall.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A flag indicating whether the firewall is protected against changes to the subnet associations. Use this setting to protect against accidentally modifying the subnet associations for a firewall that is in use. Defaults to `false`.
     */
    public val subnetChangeProtection: Output<Boolean>?
        get() = javaResource.subnetChangeProtection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Set of configuration blocks describing the public subnets. Each subnet must belong to a different Availability Zone in the VPC. AWS Network Firewall creates a firewall endpoint in each subnet. See Subnet Mapping below for details.
     */
    public val subnetMappings: Output<List<FirewallSubnetMapping>>
        get() = javaResource.subnetMappings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> firewallSubnetMappingToKotlin(args0) })
            })
        })

    /**
     * Map of resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * A string token used when updating a firewall.
     */
    public val updateToken: Output<String>
        get() = javaResource.updateToken().applyValue({ args0 -> args0 })

    /**
     * The unique identifier of the VPC where AWS Network Firewall should create the firewall.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object FirewallMapper : ResourceMapper<Firewall> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.networkfirewall.Firewall::class == javaResource::class

    override fun map(javaResource: Resource): Firewall = Firewall(
        javaResource as
            com.pulumi.aws.networkfirewall.Firewall,
    )
}

/**
 * @see [Firewall].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Firewall].
 */
public suspend fun firewall(name: String, block: suspend FirewallResourceBuilder.() -> Unit): Firewall {
    val builder = FirewallResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Firewall].
 * @param name The _unique_ name of the resulting resource.
 */
public fun firewall(name: String): Firewall {
    val builder = FirewallResourceBuilder()
    builder.name(name)
    return builder.build()
}
