@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin

import com.pulumi.aws.networkfirewall.FirewallArgs.builder
import com.pulumi.aws.networkfirewall.kotlin.inputs.FirewallEncryptionConfigurationArgs
import com.pulumi.aws.networkfirewall.kotlin.inputs.FirewallEncryptionConfigurationArgsBuilder
import com.pulumi.aws.networkfirewall.kotlin.inputs.FirewallSubnetMappingArgs
import com.pulumi.aws.networkfirewall.kotlin.inputs.FirewallSubnetMappingArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS Network Firewall Firewall Resource
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkfirewall.Firewall("example", {
 *     name: "example",
 *     firewallPolicyArn: exampleAwsNetworkfirewallFirewallPolicy.arn,
 *     vpcId: exampleAwsVpc.id,
 *     subnetMappings: [{
 *         subnetId: exampleAwsSubnet.id,
 *     }],
 *     tags: {
 *         Tag1: "Value1",
 *         Tag2: "Value2",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkfirewall.Firewall("example",
 *     name="example",
 *     firewall_policy_arn=example_aws_networkfirewall_firewall_policy["arn"],
 *     vpc_id=example_aws_vpc["id"],
 *     subnet_mappings=[{
 *         "subnet_id": example_aws_subnet["id"],
 *     }],
 *     tags={
 *         "Tag1": "Value1",
 *         "Tag2": "Value2",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkFirewall.Firewall("example", new()
 *     {
 *         Name = "example",
 *         FirewallPolicyArn = exampleAwsNetworkfirewallFirewallPolicy.Arn,
 *         VpcId = exampleAwsVpc.Id,
 *         SubnetMappings = new[]
 *         {
 *             new Aws.NetworkFirewall.Inputs.FirewallSubnetMappingArgs
 *             {
 *                 SubnetId = exampleAwsSubnet.Id,
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Tag1", "Value1" },
 *             { "Tag2", "Value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkfirewall.NewFirewall(ctx, "example", &networkfirewall.FirewallArgs{
 * 			Name:              pulumi.String("example"),
 * 			FirewallPolicyArn: pulumi.Any(exampleAwsNetworkfirewallFirewallPolicy.Arn),
 * 			VpcId:             pulumi.Any(exampleAwsVpc.Id),
 * 			SubnetMappings: networkfirewall.FirewallSubnetMappingArray{
 * 				&networkfirewall.FirewallSubnetMappingArgs{
 * 					SubnetId: pulumi.Any(exampleAwsSubnet.Id),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Tag1": pulumi.String("Value1"),
 * 				"Tag2": pulumi.String("Value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.Firewall;
 * import com.pulumi.aws.networkfirewall.FirewallArgs;
 * import com.pulumi.aws.networkfirewall.inputs.FirewallSubnetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Firewall("example", FirewallArgs.builder()
 *             .name("example")
 *             .firewallPolicyArn(exampleAwsNetworkfirewallFirewallPolicy.arn())
 *             .vpcId(exampleAwsVpc.id())
 *             .subnetMappings(FirewallSubnetMappingArgs.builder()
 *                 .subnetId(exampleAwsSubnet.id())
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Tag1", "Value1"),
 *                 Map.entry("Tag2", "Value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkfirewall:Firewall
 *     properties:
 *       name: example
 *       firewallPolicyArn: ${exampleAwsNetworkfirewallFirewallPolicy.arn}
 *       vpcId: ${exampleAwsVpc.id}
 *       subnetMappings:
 *         - subnetId: ${exampleAwsSubnet.id}
 *       tags:
 *         Tag1: Value1
 *         Tag2: Value2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Network Firewall Firewalls using their `arn`. For example:
 * ```sh
 * $ pulumi import aws:networkfirewall/firewall:Firewall example arn:aws:network-firewall:us-west-1:123456789012:firewall/example
 * ```
 * @property deleteProtection A flag indicating whether the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall that is in use. Defaults to `false`.
 * @property description A friendly description of the firewall.
 * @property encryptionConfiguration KMS encryption configuration settings. See Encryption Configuration below for details.
 * @property firewallPolicyArn The Amazon Resource Name (ARN) of the VPC Firewall policy.
 * @property firewallPolicyChangeProtection A flag indicating whether the firewall is protected against a change to the firewall policy association. Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. Defaults to `false`.
 * @property name A friendly name of the firewall.
 * @property subnetChangeProtection A flag indicating whether the firewall is protected against changes to the subnet associations. Use this setting to protect against accidentally modifying the subnet associations for a firewall that is in use. Defaults to `false`.
 * @property subnetMappings Set of configuration blocks describing the public subnets. Each subnet must belong to a different Availability Zone in the VPC. AWS Network Firewall creates a firewall endpoint in each subnet. See Subnet Mapping below for details.
 * @property tags Map of resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcId The unique identifier of the VPC where AWS Network Firewall should create the firewall.
 */
public data class FirewallArgs(
    public val deleteProtection: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val encryptionConfiguration: Output<FirewallEncryptionConfigurationArgs>? = null,
    public val firewallPolicyArn: Output<String>? = null,
    public val firewallPolicyChangeProtection: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val subnetChangeProtection: Output<Boolean>? = null,
    public val subnetMappings: Output<List<FirewallSubnetMappingArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkfirewall.FirewallArgs> {
    override fun toJava(): com.pulumi.aws.networkfirewall.FirewallArgs =
        com.pulumi.aws.networkfirewall.FirewallArgs.builder()
            .deleteProtection(deleteProtection?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptionConfiguration(
                encryptionConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .firewallPolicyArn(firewallPolicyArn?.applyValue({ args0 -> args0 }))
            .firewallPolicyChangeProtection(firewallPolicyChangeProtection?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .subnetChangeProtection(subnetChangeProtection?.applyValue({ args0 -> args0 }))
            .subnetMappings(
                subnetMappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirewallArgs].
 */
@PulumiTagMarker
public class FirewallArgsBuilder internal constructor() {
    private var deleteProtection: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var encryptionConfiguration: Output<FirewallEncryptionConfigurationArgs>? = null

    private var firewallPolicyArn: Output<String>? = null

    private var firewallPolicyChangeProtection: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var subnetChangeProtection: Output<Boolean>? = null

    private var subnetMappings: Output<List<FirewallSubnetMappingArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value A flag indicating whether the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall that is in use. Defaults to `false`.
     */
    @JvmName("fllouruftlbjtsmk")
    public suspend fun deleteProtection(`value`: Output<Boolean>) {
        this.deleteProtection = value
    }

    /**
     * @param value A friendly description of the firewall.
     */
    @JvmName("whhngdjppgchfbcx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value KMS encryption configuration settings. See Encryption Configuration below for details.
     */
    @JvmName("vllplhbpovschfvf")
    public suspend fun encryptionConfiguration(`value`: Output<FirewallEncryptionConfigurationArgs>) {
        this.encryptionConfiguration = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the VPC Firewall policy.
     */
    @JvmName("ryysmdduaeayjpbc")
    public suspend fun firewallPolicyArn(`value`: Output<String>) {
        this.firewallPolicyArn = value
    }

    /**
     * @param value A flag indicating whether the firewall is protected against a change to the firewall policy association. Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. Defaults to `false`.
     */
    @JvmName("lyalglatxjkdnodl")
    public suspend fun firewallPolicyChangeProtection(`value`: Output<Boolean>) {
        this.firewallPolicyChangeProtection = value
    }

    /**
     * @param value A friendly name of the firewall.
     */
    @JvmName("vdbxnqittpgtnvcb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A flag indicating whether the firewall is protected against changes to the subnet associations. Use this setting to protect against accidentally modifying the subnet associations for a firewall that is in use. Defaults to `false`.
     */
    @JvmName("qlyghshkfbsvakhe")
    public suspend fun subnetChangeProtection(`value`: Output<Boolean>) {
        this.subnetChangeProtection = value
    }

    /**
     * @param value Set of configuration blocks describing the public subnets. Each subnet must belong to a different Availability Zone in the VPC. AWS Network Firewall creates a firewall endpoint in each subnet. See Subnet Mapping below for details.
     */
    @JvmName("kbgyxjsnchqkpfdn")
    public suspend fun subnetMappings(`value`: Output<List<FirewallSubnetMappingArgs>>) {
        this.subnetMappings = value
    }

    @JvmName("dmcrrklprciirqpj")
    public suspend fun subnetMappings(vararg values: Output<FirewallSubnetMappingArgs>) {
        this.subnetMappings = Output.all(values.asList())
    }

    /**
     * @param values Set of configuration blocks describing the public subnets. Each subnet must belong to a different Availability Zone in the VPC. AWS Network Firewall creates a firewall endpoint in each subnet. See Subnet Mapping below for details.
     */
    @JvmName("gpcniutldplnqswm")
    public suspend fun subnetMappings(values: List<Output<FirewallSubnetMappingArgs>>) {
        this.subnetMappings = Output.all(values)
    }

    /**
     * @param value Map of resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mowbtpbmmejwsysr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The unique identifier of the VPC where AWS Network Firewall should create the firewall.
     */
    @JvmName("lmutexssynwltkif")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value A flag indicating whether the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall that is in use. Defaults to `false`.
     */
    @JvmName("vcekjpwolmanbrui")
    public suspend fun deleteProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteProtection = mapped
    }

    /**
     * @param value A friendly description of the firewall.
     */
    @JvmName("bcaunfudlypncbsf")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value KMS encryption configuration settings. See Encryption Configuration below for details.
     */
    @JvmName("bkqrpnvqlnxbpptr")
    public suspend fun encryptionConfiguration(`value`: FirewallEncryptionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionConfiguration = mapped
    }

    /**
     * @param argument KMS encryption configuration settings. See Encryption Configuration below for details.
     */
    @JvmName("oauhlxfplfxfoomi")
    public suspend fun encryptionConfiguration(argument: suspend FirewallEncryptionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FirewallEncryptionConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryptionConfiguration = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the VPC Firewall policy.
     */
    @JvmName("ccbkdgponjmfsytb")
    public suspend fun firewallPolicyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallPolicyArn = mapped
    }

    /**
     * @param value A flag indicating whether the firewall is protected against a change to the firewall policy association. Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. Defaults to `false`.
     */
    @JvmName("lcjknicrwqpjwsla")
    public suspend fun firewallPolicyChangeProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallPolicyChangeProtection = mapped
    }

    /**
     * @param value A friendly name of the firewall.
     */
    @JvmName("xyrqtmpvbhfnpxhr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A flag indicating whether the firewall is protected against changes to the subnet associations. Use this setting to protect against accidentally modifying the subnet associations for a firewall that is in use. Defaults to `false`.
     */
    @JvmName("yyvkjtwamqsprttj")
    public suspend fun subnetChangeProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetChangeProtection = mapped
    }

    /**
     * @param value Set of configuration blocks describing the public subnets. Each subnet must belong to a different Availability Zone in the VPC. AWS Network Firewall creates a firewall endpoint in each subnet. See Subnet Mapping below for details.
     */
    @JvmName("hnhtrbfuioupvaat")
    public suspend fun subnetMappings(`value`: List<FirewallSubnetMappingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetMappings = mapped
    }

    /**
     * @param argument Set of configuration blocks describing the public subnets. Each subnet must belong to a different Availability Zone in the VPC. AWS Network Firewall creates a firewall endpoint in each subnet. See Subnet Mapping below for details.
     */
    @JvmName("ocwakfmmiekdxvid")
    public suspend fun subnetMappings(argument: List<suspend FirewallSubnetMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirewallSubnetMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subnetMappings = mapped
    }

    /**
     * @param argument Set of configuration blocks describing the public subnets. Each subnet must belong to a different Availability Zone in the VPC. AWS Network Firewall creates a firewall endpoint in each subnet. See Subnet Mapping below for details.
     */
    @JvmName("vyqtflqskpmtrhii")
    public suspend fun subnetMappings(vararg argument: suspend FirewallSubnetMappingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FirewallSubnetMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subnetMappings = mapped
    }

    /**
     * @param argument Set of configuration blocks describing the public subnets. Each subnet must belong to a different Availability Zone in the VPC. AWS Network Firewall creates a firewall endpoint in each subnet. See Subnet Mapping below for details.
     */
    @JvmName("suqkausbimkaqfcd")
    public suspend fun subnetMappings(argument: suspend FirewallSubnetMappingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(FirewallSubnetMappingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.subnetMappings = mapped
    }

    /**
     * @param values Set of configuration blocks describing the public subnets. Each subnet must belong to a different Availability Zone in the VPC. AWS Network Firewall creates a firewall endpoint in each subnet. See Subnet Mapping below for details.
     */
    @JvmName("egeyvtnsgrkmrqfi")
    public suspend fun subnetMappings(vararg values: FirewallSubnetMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetMappings = mapped
    }

    /**
     * @param value Map of resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xkgmyvqxvcutqbgg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("covrwroglyetasxm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The unique identifier of the VPC where AWS Network Firewall should create the firewall.
     */
    @JvmName("wttupyrmxqatdblr")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): FirewallArgs = FirewallArgs(
        deleteProtection = deleteProtection,
        description = description,
        encryptionConfiguration = encryptionConfiguration,
        firewallPolicyArn = firewallPolicyArn,
        firewallPolicyChangeProtection = firewallPolicyChangeProtection,
        name = name,
        subnetChangeProtection = subnetChangeProtection,
        subnetMappings = subnetMappings,
        tags = tags,
        vpcId = vpcId,
    )
}
