@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin

import com.pulumi.aws.networkfirewall.kotlin.outputs.FirewallPolicyEncryptionConfiguration
import com.pulumi.aws.networkfirewall.kotlin.outputs.FirewallPolicyFirewallPolicy
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.networkfirewall.kotlin.outputs.FirewallPolicyEncryptionConfiguration.Companion.toKotlin as firewallPolicyEncryptionConfigurationToKotlin
import com.pulumi.aws.networkfirewall.kotlin.outputs.FirewallPolicyFirewallPolicy.Companion.toKotlin as firewallPolicyFirewallPolicyToKotlin

/**
 * Builder for [FirewallPolicy].
 */
@PulumiTagMarker
public class FirewallPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FirewallPolicyArgs = FirewallPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FirewallPolicyArgsBuilder.() -> Unit) {
        val builder = FirewallPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FirewallPolicy {
        val builtJavaResource = com.pulumi.aws.networkfirewall.FirewallPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FirewallPolicy(builtJavaResource)
    }
}

/**
 * Provides an AWS Network Firewall Firewall Policy Resource
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkfirewall.FirewallPolicy("example", {
 *     name: "example",
 *     firewallPolicy: {
 *         statelessDefaultActions: ["aws:pass"],
 *         statelessFragmentDefaultActions: ["aws:drop"],
 *         statelessRuleGroupReferences: [{
 *             priority: 1,
 *             resourceArn: exampleAwsNetworkfirewallRuleGroup.arn,
 *         }],
 *         tlsInspectionConfigurationArn: "arn:aws:network-firewall:REGION:ACCT:tls-configuration/example",
 *     },
 *     tags: {
 *         Tag1: "Value1",
 *         Tag2: "Value2",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkfirewall.FirewallPolicy("example",
 *     name="example",
 *     firewall_policy={
 *         "stateless_default_actions": ["aws:pass"],
 *         "stateless_fragment_default_actions": ["aws:drop"],
 *         "stateless_rule_group_references": [{
 *             "priority": 1,
 *             "resource_arn": example_aws_networkfirewall_rule_group["arn"],
 *         }],
 *         "tls_inspection_configuration_arn": "arn:aws:network-firewall:REGION:ACCT:tls-configuration/example",
 *     },
 *     tags={
 *         "Tag1": "Value1",
 *         "Tag2": "Value2",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkFirewall.FirewallPolicy("example", new()
 *     {
 *         Name = "example",
 *         FirewallPolicyConfiguration = new Aws.NetworkFirewall.Inputs.FirewallPolicyFirewallPolicyArgs
 *         {
 *             StatelessDefaultActions = new[]
 *             {
 *                 "aws:pass",
 *             },
 *             StatelessFragmentDefaultActions = new[]
 *             {
 *                 "aws:drop",
 *             },
 *             StatelessRuleGroupReferences = new[]
 *             {
 *                 new Aws.NetworkFirewall.Inputs.FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgs
 *                 {
 *                     Priority = 1,
 *                     ResourceArn = exampleAwsNetworkfirewallRuleGroup.Arn,
 *                 },
 *             },
 *             TlsInspectionConfigurationArn = "arn:aws:network-firewall:REGION:ACCT:tls-configuration/example",
 *         },
 *         Tags =
 *         {
 *             { "Tag1", "Value1" },
 *             { "Tag2", "Value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkfirewall.NewFirewallPolicy(ctx, "example", &networkfirewall.FirewallPolicyArgs{
 * 			Name: pulumi.String("example"),
 * 			FirewallPolicy: &networkfirewall.FirewallPolicyFirewallPolicyArgs{
 * 				StatelessDefaultActions: pulumi.StringArray{
 * 					pulumi.String("aws:pass"),
 * 				},
 * 				StatelessFragmentDefaultActions: pulumi.StringArray{
 * 					pulumi.String("aws:drop"),
 * 				},
 * 				StatelessRuleGroupReferences: networkfirewall.FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArray{
 * 					&networkfirewall.FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgs{
 * 						Priority:    pulumi.Int(1),
 * 						ResourceArn: pulumi.Any(exampleAwsNetworkfirewallRuleGroup.Arn),
 * 					},
 * 				},
 * 				TlsInspectionConfigurationArn: pulumi.String("arn:aws:network-firewall:REGION:ACCT:tls-configuration/example"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Tag1": pulumi.String("Value1"),
 * 				"Tag2": pulumi.String("Value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.FirewallPolicy;
 * import com.pulumi.aws.networkfirewall.FirewallPolicyArgs;
 * import com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FirewallPolicy("example", FirewallPolicyArgs.builder()
 *             .name("example")
 *             .firewallPolicy(FirewallPolicyFirewallPolicyArgs.builder()
 *                 .statelessDefaultActions("aws:pass")
 *                 .statelessFragmentDefaultActions("aws:drop")
 *                 .statelessRuleGroupReferences(FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgs.builder()
 *                     .priority(1)
 *                     .resourceArn(exampleAwsNetworkfirewallRuleGroup.arn())
 *                     .build())
 *                 .tlsInspectionConfigurationArn("arn:aws:network-firewall:REGION:ACCT:tls-configuration/example")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Tag1", "Value1"),
 *                 Map.entry("Tag2", "Value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkfirewall:FirewallPolicy
 *     properties:
 *       name: example
 *       firewallPolicy:
 *         statelessDefaultActions:
 *           - aws:pass
 *         statelessFragmentDefaultActions:
 *           - aws:drop
 *         statelessRuleGroupReferences:
 *           - priority: 1
 *             resourceArn: ${exampleAwsNetworkfirewallRuleGroup.arn}
 *         tlsInspectionConfigurationArn: arn:aws:network-firewall:REGION:ACCT:tls-configuration/example
 *       tags:
 *         Tag1: Value1
 *         Tag2: Value2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Policy with a HOME_NET Override
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkfirewall.FirewallPolicy("example", {
 *     name: "example",
 *     firewallPolicy: {
 *         policyVariables: {
 *             ruleVariables: [{
 *                 key: "HOME_NET",
 *                 ipSet: {
 *                     definitions: [
 *                         "10.0.0.0/16",
 *                         "10.1.0.0/24",
 *                     ],
 *                 },
 *             }],
 *         },
 *         statelessDefaultActions: ["aws:pass"],
 *         statelessFragmentDefaultActions: ["aws:drop"],
 *         statelessRuleGroupReferences: [{
 *             priority: 1,
 *             resourceArn: exampleAwsNetworkfirewallRuleGroup.arn,
 *         }],
 *     },
 *     tags: {
 *         Tag1: "Value1",
 *         Tag2: "Value2",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkfirewall.FirewallPolicy("example",
 *     name="example",
 *     firewall_policy={
 *         "policy_variables": {
 *             "rule_variables": [{
 *                 "key": "HOME_NET",
 *                 "ip_set": {
 *                     "definitions": [
 *                         "10.0.0.0/16",
 *                         "10.1.0.0/24",
 *                     ],
 *                 },
 *             }],
 *         },
 *         "stateless_default_actions": ["aws:pass"],
 *         "stateless_fragment_default_actions": ["aws:drop"],
 *         "stateless_rule_group_references": [{
 *             "priority": 1,
 *             "resource_arn": example_aws_networkfirewall_rule_group["arn"],
 *         }],
 *     },
 *     tags={
 *         "Tag1": "Value1",
 *         "Tag2": "Value2",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkFirewall.FirewallPolicy("example", new()
 *     {
 *         Name = "example",
 *         FirewallPolicyConfiguration = new Aws.NetworkFirewall.Inputs.FirewallPolicyFirewallPolicyArgs
 *         {
 *             PolicyVariables = new Aws.NetworkFirewall.Inputs.FirewallPolicyFirewallPolicyPolicyVariablesArgs
 *             {
 *                 RuleVariables = new[]
 *                 {
 *                     new Aws.NetworkFirewall.Inputs.FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableArgs
 *                     {
 *                         Key = "HOME_NET",
 *                         IpSet = new Aws.NetworkFirewall.Inputs.FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableIpSetArgs
 *                         {
 *                             Definitions = new[]
 *                             {
 *                                 "10.0.0.0/16",
 *                                 "10.1.0.0/24",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *             StatelessDefaultActions = new[]
 *             {
 *                 "aws:pass",
 *             },
 *             StatelessFragmentDefaultActions = new[]
 *             {
 *                 "aws:drop",
 *             },
 *             StatelessRuleGroupReferences = new[]
 *             {
 *                 new Aws.NetworkFirewall.Inputs.FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgs
 *                 {
 *                     Priority = 1,
 *                     ResourceArn = exampleAwsNetworkfirewallRuleGroup.Arn,
 *                 },
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Tag1", "Value1" },
 *             { "Tag2", "Value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkfirewall.NewFirewallPolicy(ctx, "example", &networkfirewall.FirewallPolicyArgs{
 * 			Name: pulumi.String("example"),
 * 			FirewallPolicy: &networkfirewall.FirewallPolicyFirewallPolicyArgs{
 * 				PolicyVariables: &networkfirewall.FirewallPolicyFirewallPolicyPolicyVariablesArgs{
 * 					RuleVariables: networkfirewall.FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableArray{
 * 						&networkfirewall.FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableArgs{
 * 							Key: pulumi.String("HOME_NET"),
 * 							IpSet: &networkfirewall.FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableIpSetArgs{
 * 								Definitions: pulumi.StringArray{
 * 									pulumi.String("10.0.0.0/16"),
 * 									pulumi.String("10.1.0.0/24"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 				StatelessDefaultActions: pulumi.StringArray{
 * 					pulumi.String("aws:pass"),
 * 				},
 * 				StatelessFragmentDefaultActions: pulumi.StringArray{
 * 					pulumi.String("aws:drop"),
 * 				},
 * 				StatelessRuleGroupReferences: networkfirewall.FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArray{
 * 					&networkfirewall.FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgs{
 * 						Priority:    pulumi.Int(1),
 * 						ResourceArn: pulumi.Any(exampleAwsNetworkfirewallRuleGroup.Arn),
 * 					},
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Tag1": pulumi.String("Value1"),
 * 				"Tag2": pulumi.String("Value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.FirewallPolicy;
 * import com.pulumi.aws.networkfirewall.FirewallPolicyArgs;
 * import com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyArgs;
 * import com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyPolicyVariablesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FirewallPolicy("example", FirewallPolicyArgs.builder()
 *             .name("example")
 *             .firewallPolicy(FirewallPolicyFirewallPolicyArgs.builder()
 *                 .policyVariables(FirewallPolicyFirewallPolicyPolicyVariablesArgs.builder()
 *                     .ruleVariables(FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableArgs.builder()
 *                         .key("HOME_NET")
 *                         .ipSet(FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableIpSetArgs.builder()
 *                             .definitions(
 *                                 "10.0.0.0/16",
 *                                 "10.1.0.0/24")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .statelessDefaultActions("aws:pass")
 *                 .statelessFragmentDefaultActions("aws:drop")
 *                 .statelessRuleGroupReferences(FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgs.builder()
 *                     .priority(1)
 *                     .resourceArn(exampleAwsNetworkfirewallRuleGroup.arn())
 *                     .build())
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Tag1", "Value1"),
 *                 Map.entry("Tag2", "Value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkfirewall:FirewallPolicy
 *     properties:
 *       name: example
 *       firewallPolicy:
 *         policyVariables:
 *           ruleVariables:
 *             - key: HOME_NET
 *               ipSet:
 *                 definitions:
 *                   - 10.0.0.0/16
 *                   - 10.1.0.0/24
 *         statelessDefaultActions:
 *           - aws:pass
 *         statelessFragmentDefaultActions:
 *           - aws:drop
 *         statelessRuleGroupReferences:
 *           - priority: 1
 *             resourceArn: ${exampleAwsNetworkfirewallRuleGroup.arn}
 *       tags:
 *         Tag1: Value1
 *         Tag2: Value2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Policy with a Custom Action for Stateless Inspection
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.networkfirewall.FirewallPolicy("test", {
 *     name: "example",
 *     firewallPolicy: {
 *         statelessDefaultActions: [
 *             "aws:pass",
 *             "ExampleCustomAction",
 *         ],
 *         statelessFragmentDefaultActions: ["aws:drop"],
 *         statelessCustomActions: [{
 *             actionDefinition: {
 *                 publishMetricAction: {
 *                     dimensions: [{
 *                         value: "1",
 *                     }],
 *                 },
 *             },
 *             actionName: "ExampleCustomAction",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.networkfirewall.FirewallPolicy("test",
 *     name="example",
 *     firewall_policy={
 *         "stateless_default_actions": [
 *             "aws:pass",
 *             "ExampleCustomAction",
 *         ],
 *         "stateless_fragment_default_actions": ["aws:drop"],
 *         "stateless_custom_actions": [{
 *             "action_definition": {
 *                 "publish_metric_action": {
 *                     "dimensions": [{
 *                         "value": "1",
 *                     }],
 *                 },
 *             },
 *             "action_name": "ExampleCustomAction",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.NetworkFirewall.FirewallPolicy("test", new()
 *     {
 *         Name = "example",
 *         FirewallPolicyConfiguration = new Aws.NetworkFirewall.Inputs.FirewallPolicyFirewallPolicyArgs
 *         {
 *             StatelessDefaultActions = new[]
 *             {
 *                 "aws:pass",
 *                 "ExampleCustomAction",
 *             },
 *             StatelessFragmentDefaultActions = new[]
 *             {
 *                 "aws:drop",
 *             },
 *             StatelessCustomActions = new[]
 *             {
 *                 new Aws.NetworkFirewall.Inputs.FirewallPolicyFirewallPolicyStatelessCustomActionArgs
 *                 {
 *                     ActionDefinition = new Aws.NetworkFirewall.Inputs.FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionArgs
 *                     {
 *                         PublishMetricAction = new Aws.NetworkFirewall.Inputs.FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionArgs
 *                         {
 *                             Dimensions = new[]
 *                             {
 *                                 new Aws.NetworkFirewall.Inputs.FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionDimensionArgs
 *                                 {
 *                                     Value = "1",
 *                                 },
 *                             },
 *                         },
 *                     },
 *                     ActionName = "ExampleCustomAction",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkfirewall.NewFirewallPolicy(ctx, "test", &networkfirewall.FirewallPolicyArgs{
 * 			Name: pulumi.String("example"),
 * 			FirewallPolicy: &networkfirewall.FirewallPolicyFirewallPolicyArgs{
 * 				StatelessDefaultActions: pulumi.StringArray{
 * 					pulumi.String("aws:pass"),
 * 					pulumi.String("ExampleCustomAction"),
 * 				},
 * 				StatelessFragmentDefaultActions: pulumi.StringArray{
 * 					pulumi.String("aws:drop"),
 * 				},
 * 				StatelessCustomActions: networkfirewall.FirewallPolicyFirewallPolicyStatelessCustomActionArray{
 * 					&networkfirewall.FirewallPolicyFirewallPolicyStatelessCustomActionArgs{
 * 						ActionDefinition: &networkfirewall.FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionArgs{
 * 							PublishMetricAction: &networkfirewall.FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionArgs{
 * 								Dimensions: networkfirewall.FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionDimensionArray{
 * 									&networkfirewall.FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionDimensionArgs{
 * 										Value: pulumi.String("1"),
 * 									},
 * 								},
 * 							},
 * 						},
 * 						ActionName: pulumi.String("ExampleCustomAction"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.FirewallPolicy;
 * import com.pulumi.aws.networkfirewall.FirewallPolicyArgs;
 * import com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new FirewallPolicy("test", FirewallPolicyArgs.builder()
 *             .name("example")
 *             .firewallPolicy(FirewallPolicyFirewallPolicyArgs.builder()
 *                 .statelessDefaultActions(
 *                     "aws:pass",
 *                     "ExampleCustomAction")
 *                 .statelessFragmentDefaultActions("aws:drop")
 *                 .statelessCustomActions(FirewallPolicyFirewallPolicyStatelessCustomActionArgs.builder()
 *                     .actionDefinition(FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionArgs.builder()
 *                         .publishMetricAction(FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionArgs.builder()
 *                             .dimensions(FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionDimensionArgs.builder()
 *                                 .value("1")
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .actionName("ExampleCustomAction")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:networkfirewall:FirewallPolicy
 *     properties:
 *       name: example
 *       firewallPolicy:
 *         statelessDefaultActions:
 *           - aws:pass
 *           - ExampleCustomAction
 *         statelessFragmentDefaultActions:
 *           - aws:drop
 *         statelessCustomActions:
 *           - actionDefinition:
 *               publishMetricAction:
 *                 dimensions:
 *                   - value: '1'
 *             actionName: ExampleCustomAction
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Network Firewall Policies using their `arn`. For example:
 * ```sh
 * $ pulumi import aws:networkfirewall/firewallPolicy:FirewallPolicy example arn:aws:network-firewall:us-west-1:123456789012:firewall-policy/example
 * ```
 */
public class FirewallPolicy internal constructor(
    override val javaResource: com.pulumi.aws.networkfirewall.FirewallPolicy,
) : KotlinCustomResource(javaResource, FirewallPolicyMapper) {
    /**
     * The Amazon Resource Name (ARN) that identifies the firewall policy.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A friendly description of the firewall policy.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * KMS encryption configuration settings. See Encryption Configuration below for details.
     */
    public val encryptionConfiguration: Output<FirewallPolicyEncryptionConfiguration>?
        get() = javaResource.encryptionConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> firewallPolicyEncryptionConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A configuration block describing the rule groups and policy actions to use in the firewall policy. See Firewall Policy below for details.
     */
    public val firewallPolicy: Output<FirewallPolicyFirewallPolicy>
        get() = javaResource.firewallPolicy().applyValue({ args0 ->
            args0.let({ args0 ->
                firewallPolicyFirewallPolicyToKotlin(args0)
            })
        })

    /**
     * A friendly name of the firewall policy.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Map of resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * A string token used when updating a firewall policy.
     */
    public val updateToken: Output<String>
        get() = javaResource.updateToken().applyValue({ args0 -> args0 })
}

public object FirewallPolicyMapper : ResourceMapper<FirewallPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.networkfirewall.FirewallPolicy::class == javaResource::class

    override fun map(javaResource: Resource): FirewallPolicy = FirewallPolicy(
        javaResource as
            com.pulumi.aws.networkfirewall.FirewallPolicy,
    )
}

/**
 * @see [FirewallPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FirewallPolicy].
 */
public suspend fun firewallPolicy(
    name: String,
    block: suspend FirewallPolicyResourceBuilder.() -> Unit,
): FirewallPolicy {
    val builder = FirewallPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FirewallPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun firewallPolicy(name: String): FirewallPolicy {
    val builder = FirewallPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
