@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin

import com.pulumi.aws.networkfirewall.FirewallPolicyArgs.builder
import com.pulumi.aws.networkfirewall.kotlin.inputs.FirewallPolicyEncryptionConfigurationArgs
import com.pulumi.aws.networkfirewall.kotlin.inputs.FirewallPolicyEncryptionConfigurationArgsBuilder
import com.pulumi.aws.networkfirewall.kotlin.inputs.FirewallPolicyFirewallPolicyArgs
import com.pulumi.aws.networkfirewall.kotlin.inputs.FirewallPolicyFirewallPolicyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS Network Firewall Firewall Policy Resource
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkfirewall.FirewallPolicy("example", {
 *     name: "example",
 *     firewallPolicy: {
 *         statelessDefaultActions: ["aws:pass"],
 *         statelessFragmentDefaultActions: ["aws:drop"],
 *         statelessRuleGroupReferences: [{
 *             priority: 1,
 *             resourceArn: exampleAwsNetworkfirewallRuleGroup.arn,
 *         }],
 *         tlsInspectionConfigurationArn: "arn:aws:network-firewall:REGION:ACCT:tls-configuration/example",
 *     },
 *     tags: {
 *         Tag1: "Value1",
 *         Tag2: "Value2",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkfirewall.FirewallPolicy("example",
 *     name="example",
 *     firewall_policy={
 *         "stateless_default_actions": ["aws:pass"],
 *         "stateless_fragment_default_actions": ["aws:drop"],
 *         "stateless_rule_group_references": [{
 *             "priority": 1,
 *             "resource_arn": example_aws_networkfirewall_rule_group["arn"],
 *         }],
 *         "tls_inspection_configuration_arn": "arn:aws:network-firewall:REGION:ACCT:tls-configuration/example",
 *     },
 *     tags={
 *         "Tag1": "Value1",
 *         "Tag2": "Value2",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkFirewall.FirewallPolicy("example", new()
 *     {
 *         Name = "example",
 *         FirewallPolicyConfiguration = new Aws.NetworkFirewall.Inputs.FirewallPolicyFirewallPolicyArgs
 *         {
 *             StatelessDefaultActions = new[]
 *             {
 *                 "aws:pass",
 *             },
 *             StatelessFragmentDefaultActions = new[]
 *             {
 *                 "aws:drop",
 *             },
 *             StatelessRuleGroupReferences = new[]
 *             {
 *                 new Aws.NetworkFirewall.Inputs.FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgs
 *                 {
 *                     Priority = 1,
 *                     ResourceArn = exampleAwsNetworkfirewallRuleGroup.Arn,
 *                 },
 *             },
 *             TlsInspectionConfigurationArn = "arn:aws:network-firewall:REGION:ACCT:tls-configuration/example",
 *         },
 *         Tags =
 *         {
 *             { "Tag1", "Value1" },
 *             { "Tag2", "Value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkfirewall.NewFirewallPolicy(ctx, "example", &networkfirewall.FirewallPolicyArgs{
 * 			Name: pulumi.String("example"),
 * 			FirewallPolicy: &networkfirewall.FirewallPolicyFirewallPolicyArgs{
 * 				StatelessDefaultActions: pulumi.StringArray{
 * 					pulumi.String("aws:pass"),
 * 				},
 * 				StatelessFragmentDefaultActions: pulumi.StringArray{
 * 					pulumi.String("aws:drop"),
 * 				},
 * 				StatelessRuleGroupReferences: networkfirewall.FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArray{
 * 					&networkfirewall.FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgs{
 * 						Priority:    pulumi.Int(1),
 * 						ResourceArn: pulumi.Any(exampleAwsNetworkfirewallRuleGroup.Arn),
 * 					},
 * 				},
 * 				TlsInspectionConfigurationArn: pulumi.String("arn:aws:network-firewall:REGION:ACCT:tls-configuration/example"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Tag1": pulumi.String("Value1"),
 * 				"Tag2": pulumi.String("Value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.FirewallPolicy;
 * import com.pulumi.aws.networkfirewall.FirewallPolicyArgs;
 * import com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FirewallPolicy("example", FirewallPolicyArgs.builder()
 *             .name("example")
 *             .firewallPolicy(FirewallPolicyFirewallPolicyArgs.builder()
 *                 .statelessDefaultActions("aws:pass")
 *                 .statelessFragmentDefaultActions("aws:drop")
 *                 .statelessRuleGroupReferences(FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgs.builder()
 *                     .priority(1)
 *                     .resourceArn(exampleAwsNetworkfirewallRuleGroup.arn())
 *                     .build())
 *                 .tlsInspectionConfigurationArn("arn:aws:network-firewall:REGION:ACCT:tls-configuration/example")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Tag1", "Value1"),
 *                 Map.entry("Tag2", "Value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkfirewall:FirewallPolicy
 *     properties:
 *       name: example
 *       firewallPolicy:
 *         statelessDefaultActions:
 *           - aws:pass
 *         statelessFragmentDefaultActions:
 *           - aws:drop
 *         statelessRuleGroupReferences:
 *           - priority: 1
 *             resourceArn: ${exampleAwsNetworkfirewallRuleGroup.arn}
 *         tlsInspectionConfigurationArn: arn:aws:network-firewall:REGION:ACCT:tls-configuration/example
 *       tags:
 *         Tag1: Value1
 *         Tag2: Value2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Policy with a HOME_NET Override
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkfirewall.FirewallPolicy("example", {
 *     name: "example",
 *     firewallPolicy: {
 *         policyVariables: {
 *             ruleVariables: [{
 *                 key: "HOME_NET",
 *                 ipSet: {
 *                     definitions: [
 *                         "10.0.0.0/16",
 *                         "10.1.0.0/24",
 *                     ],
 *                 },
 *             }],
 *         },
 *         statelessDefaultActions: ["aws:pass"],
 *         statelessFragmentDefaultActions: ["aws:drop"],
 *         statelessRuleGroupReferences: [{
 *             priority: 1,
 *             resourceArn: exampleAwsNetworkfirewallRuleGroup.arn,
 *         }],
 *     },
 *     tags: {
 *         Tag1: "Value1",
 *         Tag2: "Value2",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkfirewall.FirewallPolicy("example",
 *     name="example",
 *     firewall_policy={
 *         "policy_variables": {
 *             "rule_variables": [{
 *                 "key": "HOME_NET",
 *                 "ip_set": {
 *                     "definitions": [
 *                         "10.0.0.0/16",
 *                         "10.1.0.0/24",
 *                     ],
 *                 },
 *             }],
 *         },
 *         "stateless_default_actions": ["aws:pass"],
 *         "stateless_fragment_default_actions": ["aws:drop"],
 *         "stateless_rule_group_references": [{
 *             "priority": 1,
 *             "resource_arn": example_aws_networkfirewall_rule_group["arn"],
 *         }],
 *     },
 *     tags={
 *         "Tag1": "Value1",
 *         "Tag2": "Value2",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkFirewall.FirewallPolicy("example", new()
 *     {
 *         Name = "example",
 *         FirewallPolicyConfiguration = new Aws.NetworkFirewall.Inputs.FirewallPolicyFirewallPolicyArgs
 *         {
 *             PolicyVariables = new Aws.NetworkFirewall.Inputs.FirewallPolicyFirewallPolicyPolicyVariablesArgs
 *             {
 *                 RuleVariables = new[]
 *                 {
 *                     new Aws.NetworkFirewall.Inputs.FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableArgs
 *                     {
 *                         Key = "HOME_NET",
 *                         IpSet = new Aws.NetworkFirewall.Inputs.FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableIpSetArgs
 *                         {
 *                             Definitions = new[]
 *                             {
 *                                 "10.0.0.0/16",
 *                                 "10.1.0.0/24",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *             StatelessDefaultActions = new[]
 *             {
 *                 "aws:pass",
 *             },
 *             StatelessFragmentDefaultActions = new[]
 *             {
 *                 "aws:drop",
 *             },
 *             StatelessRuleGroupReferences = new[]
 *             {
 *                 new Aws.NetworkFirewall.Inputs.FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgs
 *                 {
 *                     Priority = 1,
 *                     ResourceArn = exampleAwsNetworkfirewallRuleGroup.Arn,
 *                 },
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Tag1", "Value1" },
 *             { "Tag2", "Value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkfirewall.NewFirewallPolicy(ctx, "example", &networkfirewall.FirewallPolicyArgs{
 * 			Name: pulumi.String("example"),
 * 			FirewallPolicy: &networkfirewall.FirewallPolicyFirewallPolicyArgs{
 * 				PolicyVariables: &networkfirewall.FirewallPolicyFirewallPolicyPolicyVariablesArgs{
 * 					RuleVariables: networkfirewall.FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableArray{
 * 						&networkfirewall.FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableArgs{
 * 							Key: pulumi.String("HOME_NET"),
 * 							IpSet: &networkfirewall.FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableIpSetArgs{
 * 								Definitions: pulumi.StringArray{
 * 									pulumi.String("10.0.0.0/16"),
 * 									pulumi.String("10.1.0.0/24"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 				StatelessDefaultActions: pulumi.StringArray{
 * 					pulumi.String("aws:pass"),
 * 				},
 * 				StatelessFragmentDefaultActions: pulumi.StringArray{
 * 					pulumi.String("aws:drop"),
 * 				},
 * 				StatelessRuleGroupReferences: networkfirewall.FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArray{
 * 					&networkfirewall.FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgs{
 * 						Priority:    pulumi.Int(1),
 * 						ResourceArn: pulumi.Any(exampleAwsNetworkfirewallRuleGroup.Arn),
 * 					},
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Tag1": pulumi.String("Value1"),
 * 				"Tag2": pulumi.String("Value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.FirewallPolicy;
 * import com.pulumi.aws.networkfirewall.FirewallPolicyArgs;
 * import com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyArgs;
 * import com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyPolicyVariablesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FirewallPolicy("example", FirewallPolicyArgs.builder()
 *             .name("example")
 *             .firewallPolicy(FirewallPolicyFirewallPolicyArgs.builder()
 *                 .policyVariables(FirewallPolicyFirewallPolicyPolicyVariablesArgs.builder()
 *                     .ruleVariables(FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableArgs.builder()
 *                         .key("HOME_NET")
 *                         .ipSet(FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableIpSetArgs.builder()
 *                             .definitions(
 *                                 "10.0.0.0/16",
 *                                 "10.1.0.0/24")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .statelessDefaultActions("aws:pass")
 *                 .statelessFragmentDefaultActions("aws:drop")
 *                 .statelessRuleGroupReferences(FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgs.builder()
 *                     .priority(1)
 *                     .resourceArn(exampleAwsNetworkfirewallRuleGroup.arn())
 *                     .build())
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Tag1", "Value1"),
 *                 Map.entry("Tag2", "Value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkfirewall:FirewallPolicy
 *     properties:
 *       name: example
 *       firewallPolicy:
 *         policyVariables:
 *           ruleVariables:
 *             - key: HOME_NET
 *               ipSet:
 *                 definitions:
 *                   - 10.0.0.0/16
 *                   - 10.1.0.0/24
 *         statelessDefaultActions:
 *           - aws:pass
 *         statelessFragmentDefaultActions:
 *           - aws:drop
 *         statelessRuleGroupReferences:
 *           - priority: 1
 *             resourceArn: ${exampleAwsNetworkfirewallRuleGroup.arn}
 *       tags:
 *         Tag1: Value1
 *         Tag2: Value2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Policy with a Custom Action for Stateless Inspection
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.networkfirewall.FirewallPolicy("test", {
 *     name: "example",
 *     firewallPolicy: {
 *         statelessDefaultActions: [
 *             "aws:pass",
 *             "ExampleCustomAction",
 *         ],
 *         statelessFragmentDefaultActions: ["aws:drop"],
 *         statelessCustomActions: [{
 *             actionDefinition: {
 *                 publishMetricAction: {
 *                     dimensions: [{
 *                         value: "1",
 *                     }],
 *                 },
 *             },
 *             actionName: "ExampleCustomAction",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.networkfirewall.FirewallPolicy("test",
 *     name="example",
 *     firewall_policy={
 *         "stateless_default_actions": [
 *             "aws:pass",
 *             "ExampleCustomAction",
 *         ],
 *         "stateless_fragment_default_actions": ["aws:drop"],
 *         "stateless_custom_actions": [{
 *             "action_definition": {
 *                 "publish_metric_action": {
 *                     "dimensions": [{
 *                         "value": "1",
 *                     }],
 *                 },
 *             },
 *             "action_name": "ExampleCustomAction",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.NetworkFirewall.FirewallPolicy("test", new()
 *     {
 *         Name = "example",
 *         FirewallPolicyConfiguration = new Aws.NetworkFirewall.Inputs.FirewallPolicyFirewallPolicyArgs
 *         {
 *             StatelessDefaultActions = new[]
 *             {
 *                 "aws:pass",
 *                 "ExampleCustomAction",
 *             },
 *             StatelessFragmentDefaultActions = new[]
 *             {
 *                 "aws:drop",
 *             },
 *             StatelessCustomActions = new[]
 *             {
 *                 new Aws.NetworkFirewall.Inputs.FirewallPolicyFirewallPolicyStatelessCustomActionArgs
 *                 {
 *                     ActionDefinition = new Aws.NetworkFirewall.Inputs.FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionArgs
 *                     {
 *                         PublishMetricAction = new Aws.NetworkFirewall.Inputs.FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionArgs
 *                         {
 *                             Dimensions = new[]
 *                             {
 *                                 new Aws.NetworkFirewall.Inputs.FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionDimensionArgs
 *                                 {
 *                                     Value = "1",
 *                                 },
 *                             },
 *                         },
 *                     },
 *                     ActionName = "ExampleCustomAction",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkfirewall.NewFirewallPolicy(ctx, "test", &networkfirewall.FirewallPolicyArgs{
 * 			Name: pulumi.String("example"),
 * 			FirewallPolicy: &networkfirewall.FirewallPolicyFirewallPolicyArgs{
 * 				StatelessDefaultActions: pulumi.StringArray{
 * 					pulumi.String("aws:pass"),
 * 					pulumi.String("ExampleCustomAction"),
 * 				},
 * 				StatelessFragmentDefaultActions: pulumi.StringArray{
 * 					pulumi.String("aws:drop"),
 * 				},
 * 				StatelessCustomActions: networkfirewall.FirewallPolicyFirewallPolicyStatelessCustomActionArray{
 * 					&networkfirewall.FirewallPolicyFirewallPolicyStatelessCustomActionArgs{
 * 						ActionDefinition: &networkfirewall.FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionArgs{
 * 							PublishMetricAction: &networkfirewall.FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionArgs{
 * 								Dimensions: networkfirewall.FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionDimensionArray{
 * 									&networkfirewall.FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionDimensionArgs{
 * 										Value: pulumi.String("1"),
 * 									},
 * 								},
 * 							},
 * 						},
 * 						ActionName: pulumi.String("ExampleCustomAction"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.FirewallPolicy;
 * import com.pulumi.aws.networkfirewall.FirewallPolicyArgs;
 * import com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new FirewallPolicy("test", FirewallPolicyArgs.builder()
 *             .name("example")
 *             .firewallPolicy(FirewallPolicyFirewallPolicyArgs.builder()
 *                 .statelessDefaultActions(
 *                     "aws:pass",
 *                     "ExampleCustomAction")
 *                 .statelessFragmentDefaultActions("aws:drop")
 *                 .statelessCustomActions(FirewallPolicyFirewallPolicyStatelessCustomActionArgs.builder()
 *                     .actionDefinition(FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionArgs.builder()
 *                         .publishMetricAction(FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionArgs.builder()
 *                             .dimensions(FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionDimensionArgs.builder()
 *                                 .value("1")
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .actionName("ExampleCustomAction")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:networkfirewall:FirewallPolicy
 *     properties:
 *       name: example
 *       firewallPolicy:
 *         statelessDefaultActions:
 *           - aws:pass
 *           - ExampleCustomAction
 *         statelessFragmentDefaultActions:
 *           - aws:drop
 *         statelessCustomActions:
 *           - actionDefinition:
 *               publishMetricAction:
 *                 dimensions:
 *                   - value: '1'
 *             actionName: ExampleCustomAction
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Network Firewall Policies using their `arn`. For example:
 * ```sh
 * $ pulumi import aws:networkfirewall/firewallPolicy:FirewallPolicy example arn:aws:network-firewall:us-west-1:123456789012:firewall-policy/example
 * ```
 * @property description A friendly description of the firewall policy.
 * @property encryptionConfiguration KMS encryption configuration settings. See Encryption Configuration below for details.
 * @property firewallPolicy A configuration block describing the rule groups and policy actions to use in the firewall policy. See Firewall Policy below for details.
 * @property name A friendly name of the firewall policy.
 * @property tags Map of resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class FirewallPolicyArgs(
    public val description: Output<String>? = null,
    public val encryptionConfiguration: Output<FirewallPolicyEncryptionConfigurationArgs>? = null,
    public val firewallPolicy: Output<FirewallPolicyFirewallPolicyArgs>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkfirewall.FirewallPolicyArgs> {
    override fun toJava(): com.pulumi.aws.networkfirewall.FirewallPolicyArgs =
        com.pulumi.aws.networkfirewall.FirewallPolicyArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptionConfiguration(
                encryptionConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .firewallPolicy(firewallPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [FirewallPolicyArgs].
 */
@PulumiTagMarker
public class FirewallPolicyArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var encryptionConfiguration: Output<FirewallPolicyEncryptionConfigurationArgs>? = null

    private var firewallPolicy: Output<FirewallPolicyFirewallPolicyArgs>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A friendly description of the firewall policy.
     */
    @JvmName("hofpahikbphwklmd")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value KMS encryption configuration settings. See Encryption Configuration below for details.
     */
    @JvmName("psuweijjdosfictf")
    public suspend fun encryptionConfiguration(`value`: Output<FirewallPolicyEncryptionConfigurationArgs>) {
        this.encryptionConfiguration = value
    }

    /**
     * @param value A configuration block describing the rule groups and policy actions to use in the firewall policy. See Firewall Policy below for details.
     */
    @JvmName("fpdadrwxagvuifer")
    public suspend fun firewallPolicy(`value`: Output<FirewallPolicyFirewallPolicyArgs>) {
        this.firewallPolicy = value
    }

    /**
     * @param value A friendly name of the firewall policy.
     */
    @JvmName("cfosuoravprnckng")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Map of resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ugpggpkxgpkufsxu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A friendly description of the firewall policy.
     */
    @JvmName("fmgucdieqgvojmby")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value KMS encryption configuration settings. See Encryption Configuration below for details.
     */
    @JvmName("mogpeindedegcohs")
    public suspend fun encryptionConfiguration(`value`: FirewallPolicyEncryptionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionConfiguration = mapped
    }

    /**
     * @param argument KMS encryption configuration settings. See Encryption Configuration below for details.
     */
    @JvmName("conukilmxhtiaibf")
    public suspend fun encryptionConfiguration(argument: suspend FirewallPolicyEncryptionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FirewallPolicyEncryptionConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.encryptionConfiguration = mapped
    }

    /**
     * @param value A configuration block describing the rule groups and policy actions to use in the firewall policy. See Firewall Policy below for details.
     */
    @JvmName("eupjsnofqiabnsdg")
    public suspend fun firewallPolicy(`value`: FirewallPolicyFirewallPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallPolicy = mapped
    }

    /**
     * @param argument A configuration block describing the rule groups and policy actions to use in the firewall policy. See Firewall Policy below for details.
     */
    @JvmName("ojamndsgmtlsfrno")
    public suspend fun firewallPolicy(argument: suspend FirewallPolicyFirewallPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = FirewallPolicyFirewallPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.firewallPolicy = mapped
    }

    /**
     * @param value A friendly name of the firewall policy.
     */
    @JvmName("memfgtornmqoocnm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Map of resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gofbahnvpbgwauhv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("caxicbweyncfoofq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): FirewallPolicyArgs = FirewallPolicyArgs(
        description = description,
        encryptionConfiguration = encryptionConfiguration,
        firewallPolicy = firewallPolicy,
        name = name,
        tags = tags,
    )
}
