@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin

import com.pulumi.aws.networkfirewall.kotlin.outputs.LoggingConfigurationLoggingConfiguration
import com.pulumi.aws.networkfirewall.kotlin.outputs.LoggingConfigurationLoggingConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [LoggingConfiguration].
 */
@PulumiTagMarker
public class LoggingConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LoggingConfigurationArgs = LoggingConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LoggingConfigurationArgsBuilder.() -> Unit) {
        val builder = LoggingConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LoggingConfiguration {
        val builtJavaResource =
            com.pulumi.aws.networkfirewall.LoggingConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return LoggingConfiguration(builtJavaResource)
    }
}

/**
 * Provides an AWS Network Firewall Logging Configuration Resource
 * ## Example Usage
 * ### Logging to S3
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkfirewall.LoggingConfiguration("example", {
 *     firewallArn: exampleAwsNetworkfirewallFirewall.arn,
 *     loggingConfiguration: {
 *         logDestinationConfigs: [{
 *             logDestination: {
 *                 bucketName: exampleAwsS3Bucket.bucket,
 *                 prefix: "/example",
 *             },
 *             logDestinationType: "S3",
 *             logType: "FLOW",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkfirewall.LoggingConfiguration("example",
 *     firewall_arn=example_aws_networkfirewall_firewall["arn"],
 *     logging_configuration={
 *         "log_destination_configs": [{
 *             "log_destination": {
 *                 "bucket_name": example_aws_s3_bucket["bucket"],
 *                 "prefix": "/example",
 *             },
 *             "log_destination_type": "S3",
 *             "log_type": "FLOW",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkFirewall.LoggingConfiguration("example", new()
 *     {
 *         FirewallArn = exampleAwsNetworkfirewallFirewall.Arn,
 *         LoggingConfig = new Aws.NetworkFirewall.Inputs.LoggingConfigurationLoggingConfigurationArgs
 *         {
 *             LogDestinationConfigs = new[]
 *             {
 *                 new Aws.NetworkFirewall.Inputs.LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs
 *                 {
 *                     LogDestination =
 *                     {
 *                         { "bucketName", exampleAwsS3Bucket.Bucket },
 *                         { "prefix", "/example" },
 *                     },
 *                     LogDestinationType = "S3",
 *                     LogType = "FLOW",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkfirewall.NewLoggingConfiguration(ctx, "example", &networkfirewall.LoggingConfigurationArgs{
 * 			FirewallArn: pulumi.Any(exampleAwsNetworkfirewallFirewall.Arn),
 * 			LoggingConfiguration: &networkfirewall.LoggingConfigurationLoggingConfigurationArgs{
 * 				LogDestinationConfigs: networkfirewall.LoggingConfigurationLoggingConfigurationLogDestinationConfigArray{
 * 					&networkfirewall.LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs{
 * 						LogDestination: pulumi.StringMap{
 * 							"bucketName": pulumi.Any(exampleAwsS3Bucket.Bucket),
 * 							"prefix":     pulumi.String("/example"),
 * 						},
 * 						LogDestinationType: pulumi.String("S3"),
 * 						LogType:            pulumi.String("FLOW"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.LoggingConfiguration;
 * import com.pulumi.aws.networkfirewall.LoggingConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.LoggingConfigurationLoggingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LoggingConfiguration("example", LoggingConfigurationArgs.builder()
 *             .firewallArn(exampleAwsNetworkfirewallFirewall.arn())
 *             .loggingConfiguration(LoggingConfigurationLoggingConfigurationArgs.builder()
 *                 .logDestinationConfigs(LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs.builder()
 *                     .logDestination(Map.ofEntries(
 *                         Map.entry("bucketName", exampleAwsS3Bucket.bucket()),
 *                         Map.entry("prefix", "/example")
 *                     ))
 *                     .logDestinationType("S3")
 *                     .logType("FLOW")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkfirewall:LoggingConfiguration
 *     properties:
 *       firewallArn: ${exampleAwsNetworkfirewallFirewall.arn}
 *       loggingConfiguration:
 *         logDestinationConfigs:
 *           - logDestination:
 *               bucketName: ${exampleAwsS3Bucket.bucket}
 *               prefix: /example
 *             logDestinationType: S3
 *             logType: FLOW
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Logging to CloudWatch
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkfirewall.LoggingConfiguration("example", {
 *     firewallArn: exampleAwsNetworkfirewallFirewall.arn,
 *     loggingConfiguration: {
 *         logDestinationConfigs: [{
 *             logDestination: {
 *                 logGroup: exampleAwsCloudwatchLogGroup.name,
 *             },
 *             logDestinationType: "CloudWatchLogs",
 *             logType: "ALERT",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkfirewall.LoggingConfiguration("example",
 *     firewall_arn=example_aws_networkfirewall_firewall["arn"],
 *     logging_configuration={
 *         "log_destination_configs": [{
 *             "log_destination": {
 *                 "log_group": example_aws_cloudwatch_log_group["name"],
 *             },
 *             "log_destination_type": "CloudWatchLogs",
 *             "log_type": "ALERT",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkFirewall.LoggingConfiguration("example", new()
 *     {
 *         FirewallArn = exampleAwsNetworkfirewallFirewall.Arn,
 *         LoggingConfig = new Aws.NetworkFirewall.Inputs.LoggingConfigurationLoggingConfigurationArgs
 *         {
 *             LogDestinationConfigs = new[]
 *             {
 *                 new Aws.NetworkFirewall.Inputs.LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs
 *                 {
 *                     LogDestination =
 *                     {
 *                         { "logGroup", exampleAwsCloudwatchLogGroup.Name },
 *                     },
 *                     LogDestinationType = "CloudWatchLogs",
 *                     LogType = "ALERT",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkfirewall.NewLoggingConfiguration(ctx, "example", &networkfirewall.LoggingConfigurationArgs{
 * 			FirewallArn: pulumi.Any(exampleAwsNetworkfirewallFirewall.Arn),
 * 			LoggingConfiguration: &networkfirewall.LoggingConfigurationLoggingConfigurationArgs{
 * 				LogDestinationConfigs: networkfirewall.LoggingConfigurationLoggingConfigurationLogDestinationConfigArray{
 * 					&networkfirewall.LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs{
 * 						LogDestination: pulumi.StringMap{
 * 							"logGroup": pulumi.Any(exampleAwsCloudwatchLogGroup.Name),
 * 						},
 * 						LogDestinationType: pulumi.String("CloudWatchLogs"),
 * 						LogType:            pulumi.String("ALERT"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.LoggingConfiguration;
 * import com.pulumi.aws.networkfirewall.LoggingConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.LoggingConfigurationLoggingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LoggingConfiguration("example", LoggingConfigurationArgs.builder()
 *             .firewallArn(exampleAwsNetworkfirewallFirewall.arn())
 *             .loggingConfiguration(LoggingConfigurationLoggingConfigurationArgs.builder()
 *                 .logDestinationConfigs(LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs.builder()
 *                     .logDestination(Map.of("logGroup", exampleAwsCloudwatchLogGroup.name()))
 *                     .logDestinationType("CloudWatchLogs")
 *                     .logType("ALERT")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkfirewall:LoggingConfiguration
 *     properties:
 *       firewallArn: ${exampleAwsNetworkfirewallFirewall.arn}
 *       loggingConfiguration:
 *         logDestinationConfigs:
 *           - logDestination:
 *               logGroup: ${exampleAwsCloudwatchLogGroup.name}
 *             logDestinationType: CloudWatchLogs
 *             logType: ALERT
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Logging to Kinesis Data Firehose
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkfirewall.LoggingConfiguration("example", {
 *     firewallArn: exampleAwsNetworkfirewallFirewall.arn,
 *     loggingConfiguration: {
 *         logDestinationConfigs: [{
 *             logDestination: {
 *                 deliveryStream: exampleAwsKinesisFirehoseDeliveryStream.name,
 *             },
 *             logDestinationType: "KinesisDataFirehose",
 *             logType: "ALERT",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkfirewall.LoggingConfiguration("example",
 *     firewall_arn=example_aws_networkfirewall_firewall["arn"],
 *     logging_configuration={
 *         "log_destination_configs": [{
 *             "log_destination": {
 *                 "delivery_stream": example_aws_kinesis_firehose_delivery_stream["name"],
 *             },
 *             "log_destination_type": "KinesisDataFirehose",
 *             "log_type": "ALERT",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkFirewall.LoggingConfiguration("example", new()
 *     {
 *         FirewallArn = exampleAwsNetworkfirewallFirewall.Arn,
 *         LoggingConfig = new Aws.NetworkFirewall.Inputs.LoggingConfigurationLoggingConfigurationArgs
 *         {
 *             LogDestinationConfigs = new[]
 *             {
 *                 new Aws.NetworkFirewall.Inputs.LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs
 *                 {
 *                     LogDestination =
 *                     {
 *                         { "deliveryStream", exampleAwsKinesisFirehoseDeliveryStream.Name },
 *                     },
 *                     LogDestinationType = "KinesisDataFirehose",
 *                     LogType = "ALERT",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkfirewall.NewLoggingConfiguration(ctx, "example", &networkfirewall.LoggingConfigurationArgs{
 * 			FirewallArn: pulumi.Any(exampleAwsNetworkfirewallFirewall.Arn),
 * 			LoggingConfiguration: &networkfirewall.LoggingConfigurationLoggingConfigurationArgs{
 * 				LogDestinationConfigs: networkfirewall.LoggingConfigurationLoggingConfigurationLogDestinationConfigArray{
 * 					&networkfirewall.LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs{
 * 						LogDestination: pulumi.StringMap{
 * 							"deliveryStream": pulumi.Any(exampleAwsKinesisFirehoseDeliveryStream.Name),
 * 						},
 * 						LogDestinationType: pulumi.String("KinesisDataFirehose"),
 * 						LogType:            pulumi.String("ALERT"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.LoggingConfiguration;
 * import com.pulumi.aws.networkfirewall.LoggingConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.LoggingConfigurationLoggingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LoggingConfiguration("example", LoggingConfigurationArgs.builder()
 *             .firewallArn(exampleAwsNetworkfirewallFirewall.arn())
 *             .loggingConfiguration(LoggingConfigurationLoggingConfigurationArgs.builder()
 *                 .logDestinationConfigs(LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs.builder()
 *                     .logDestination(Map.of("deliveryStream", exampleAwsKinesisFirehoseDeliveryStream.name()))
 *                     .logDestinationType("KinesisDataFirehose")
 *                     .logType("ALERT")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkfirewall:LoggingConfiguration
 *     properties:
 *       firewallArn: ${exampleAwsNetworkfirewallFirewall.arn}
 *       loggingConfiguration:
 *         logDestinationConfigs:
 *           - logDestination:
 *               deliveryStream: ${exampleAwsKinesisFirehoseDeliveryStream.name}
 *             logDestinationType: KinesisDataFirehose
 *             logType: ALERT
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Network Firewall Logging Configurations using the `firewall_arn`. For example:
 * ```sh
 * $ pulumi import aws:networkfirewall/loggingConfiguration:LoggingConfiguration example arn:aws:network-firewall:us-west-1:123456789012:firewall/example
 * ```
 */
public class LoggingConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.networkfirewall.LoggingConfiguration,
) : KotlinCustomResource(javaResource, LoggingConfigurationMapper) {
    /**
     * The Amazon Resource Name (ARN) of the Network Firewall firewall.
     */
    public val firewallArn: Output<String>
        get() = javaResource.firewallArn().applyValue({ args0 -> args0 })

    /**
     * A configuration block describing how AWS Network Firewall performs logging for a firewall. See Logging Configuration below for details.
     */
    public val loggingConfiguration: Output<LoggingConfigurationLoggingConfiguration>
        get() = javaResource.loggingConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })
}

public object LoggingConfigurationMapper : ResourceMapper<LoggingConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.networkfirewall.LoggingConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): LoggingConfiguration = LoggingConfiguration(
        javaResource
            as com.pulumi.aws.networkfirewall.LoggingConfiguration,
    )
}

/**
 * @see [LoggingConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LoggingConfiguration].
 */
public suspend fun loggingConfiguration(
    name: String,
    block: suspend LoggingConfigurationResourceBuilder.() -> Unit,
): LoggingConfiguration {
    val builder = LoggingConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LoggingConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun loggingConfiguration(name: String): LoggingConfiguration {
    val builder = LoggingConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
