@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin

import com.pulumi.aws.networkfirewall.LoggingConfigurationArgs.builder
import com.pulumi.aws.networkfirewall.kotlin.inputs.LoggingConfigurationLoggingConfigurationArgs
import com.pulumi.aws.networkfirewall.kotlin.inputs.LoggingConfigurationLoggingConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides an AWS Network Firewall Logging Configuration Resource
 * ## Example Usage
 * ### Logging to S3
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkfirewall.LoggingConfiguration("example", {
 *     firewallArn: exampleAwsNetworkfirewallFirewall.arn,
 *     loggingConfiguration: {
 *         logDestinationConfigs: [{
 *             logDestination: {
 *                 bucketName: exampleAwsS3Bucket.bucket,
 *                 prefix: "/example",
 *             },
 *             logDestinationType: "S3",
 *             logType: "FLOW",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkfirewall.LoggingConfiguration("example",
 *     firewall_arn=example_aws_networkfirewall_firewall["arn"],
 *     logging_configuration={
 *         "log_destination_configs": [{
 *             "log_destination": {
 *                 "bucket_name": example_aws_s3_bucket["bucket"],
 *                 "prefix": "/example",
 *             },
 *             "log_destination_type": "S3",
 *             "log_type": "FLOW",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkFirewall.LoggingConfiguration("example", new()
 *     {
 *         FirewallArn = exampleAwsNetworkfirewallFirewall.Arn,
 *         LoggingConfig = new Aws.NetworkFirewall.Inputs.LoggingConfigurationLoggingConfigurationArgs
 *         {
 *             LogDestinationConfigs = new[]
 *             {
 *                 new Aws.NetworkFirewall.Inputs.LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs
 *                 {
 *                     LogDestination =
 *                     {
 *                         { "bucketName", exampleAwsS3Bucket.Bucket },
 *                         { "prefix", "/example" },
 *                     },
 *                     LogDestinationType = "S3",
 *                     LogType = "FLOW",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkfirewall.NewLoggingConfiguration(ctx, "example", &networkfirewall.LoggingConfigurationArgs{
 * 			FirewallArn: pulumi.Any(exampleAwsNetworkfirewallFirewall.Arn),
 * 			LoggingConfiguration: &networkfirewall.LoggingConfigurationLoggingConfigurationArgs{
 * 				LogDestinationConfigs: networkfirewall.LoggingConfigurationLoggingConfigurationLogDestinationConfigArray{
 * 					&networkfirewall.LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs{
 * 						LogDestination: pulumi.StringMap{
 * 							"bucketName": pulumi.Any(exampleAwsS3Bucket.Bucket),
 * 							"prefix":     pulumi.String("/example"),
 * 						},
 * 						LogDestinationType: pulumi.String("S3"),
 * 						LogType:            pulumi.String("FLOW"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.LoggingConfiguration;
 * import com.pulumi.aws.networkfirewall.LoggingConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.LoggingConfigurationLoggingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LoggingConfiguration("example", LoggingConfigurationArgs.builder()
 *             .firewallArn(exampleAwsNetworkfirewallFirewall.arn())
 *             .loggingConfiguration(LoggingConfigurationLoggingConfigurationArgs.builder()
 *                 .logDestinationConfigs(LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs.builder()
 *                     .logDestination(Map.ofEntries(
 *                         Map.entry("bucketName", exampleAwsS3Bucket.bucket()),
 *                         Map.entry("prefix", "/example")
 *                     ))
 *                     .logDestinationType("S3")
 *                     .logType("FLOW")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkfirewall:LoggingConfiguration
 *     properties:
 *       firewallArn: ${exampleAwsNetworkfirewallFirewall.arn}
 *       loggingConfiguration:
 *         logDestinationConfigs:
 *           - logDestination:
 *               bucketName: ${exampleAwsS3Bucket.bucket}
 *               prefix: /example
 *             logDestinationType: S3
 *             logType: FLOW
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Logging to CloudWatch
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkfirewall.LoggingConfiguration("example", {
 *     firewallArn: exampleAwsNetworkfirewallFirewall.arn,
 *     loggingConfiguration: {
 *         logDestinationConfigs: [{
 *             logDestination: {
 *                 logGroup: exampleAwsCloudwatchLogGroup.name,
 *             },
 *             logDestinationType: "CloudWatchLogs",
 *             logType: "ALERT",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkfirewall.LoggingConfiguration("example",
 *     firewall_arn=example_aws_networkfirewall_firewall["arn"],
 *     logging_configuration={
 *         "log_destination_configs": [{
 *             "log_destination": {
 *                 "log_group": example_aws_cloudwatch_log_group["name"],
 *             },
 *             "log_destination_type": "CloudWatchLogs",
 *             "log_type": "ALERT",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkFirewall.LoggingConfiguration("example", new()
 *     {
 *         FirewallArn = exampleAwsNetworkfirewallFirewall.Arn,
 *         LoggingConfig = new Aws.NetworkFirewall.Inputs.LoggingConfigurationLoggingConfigurationArgs
 *         {
 *             LogDestinationConfigs = new[]
 *             {
 *                 new Aws.NetworkFirewall.Inputs.LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs
 *                 {
 *                     LogDestination =
 *                     {
 *                         { "logGroup", exampleAwsCloudwatchLogGroup.Name },
 *                     },
 *                     LogDestinationType = "CloudWatchLogs",
 *                     LogType = "ALERT",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkfirewall.NewLoggingConfiguration(ctx, "example", &networkfirewall.LoggingConfigurationArgs{
 * 			FirewallArn: pulumi.Any(exampleAwsNetworkfirewallFirewall.Arn),
 * 			LoggingConfiguration: &networkfirewall.LoggingConfigurationLoggingConfigurationArgs{
 * 				LogDestinationConfigs: networkfirewall.LoggingConfigurationLoggingConfigurationLogDestinationConfigArray{
 * 					&networkfirewall.LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs{
 * 						LogDestination: pulumi.StringMap{
 * 							"logGroup": pulumi.Any(exampleAwsCloudwatchLogGroup.Name),
 * 						},
 * 						LogDestinationType: pulumi.String("CloudWatchLogs"),
 * 						LogType:            pulumi.String("ALERT"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.LoggingConfiguration;
 * import com.pulumi.aws.networkfirewall.LoggingConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.LoggingConfigurationLoggingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LoggingConfiguration("example", LoggingConfigurationArgs.builder()
 *             .firewallArn(exampleAwsNetworkfirewallFirewall.arn())
 *             .loggingConfiguration(LoggingConfigurationLoggingConfigurationArgs.builder()
 *                 .logDestinationConfigs(LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs.builder()
 *                     .logDestination(Map.of("logGroup", exampleAwsCloudwatchLogGroup.name()))
 *                     .logDestinationType("CloudWatchLogs")
 *                     .logType("ALERT")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkfirewall:LoggingConfiguration
 *     properties:
 *       firewallArn: ${exampleAwsNetworkfirewallFirewall.arn}
 *       loggingConfiguration:
 *         logDestinationConfigs:
 *           - logDestination:
 *               logGroup: ${exampleAwsCloudwatchLogGroup.name}
 *             logDestinationType: CloudWatchLogs
 *             logType: ALERT
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Logging to Kinesis Data Firehose
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkfirewall.LoggingConfiguration("example", {
 *     firewallArn: exampleAwsNetworkfirewallFirewall.arn,
 *     loggingConfiguration: {
 *         logDestinationConfigs: [{
 *             logDestination: {
 *                 deliveryStream: exampleAwsKinesisFirehoseDeliveryStream.name,
 *             },
 *             logDestinationType: "KinesisDataFirehose",
 *             logType: "ALERT",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkfirewall.LoggingConfiguration("example",
 *     firewall_arn=example_aws_networkfirewall_firewall["arn"],
 *     logging_configuration={
 *         "log_destination_configs": [{
 *             "log_destination": {
 *                 "delivery_stream": example_aws_kinesis_firehose_delivery_stream["name"],
 *             },
 *             "log_destination_type": "KinesisDataFirehose",
 *             "log_type": "ALERT",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkFirewall.LoggingConfiguration("example", new()
 *     {
 *         FirewallArn = exampleAwsNetworkfirewallFirewall.Arn,
 *         LoggingConfig = new Aws.NetworkFirewall.Inputs.LoggingConfigurationLoggingConfigurationArgs
 *         {
 *             LogDestinationConfigs = new[]
 *             {
 *                 new Aws.NetworkFirewall.Inputs.LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs
 *                 {
 *                     LogDestination =
 *                     {
 *                         { "deliveryStream", exampleAwsKinesisFirehoseDeliveryStream.Name },
 *                     },
 *                     LogDestinationType = "KinesisDataFirehose",
 *                     LogType = "ALERT",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkfirewall.NewLoggingConfiguration(ctx, "example", &networkfirewall.LoggingConfigurationArgs{
 * 			FirewallArn: pulumi.Any(exampleAwsNetworkfirewallFirewall.Arn),
 * 			LoggingConfiguration: &networkfirewall.LoggingConfigurationLoggingConfigurationArgs{
 * 				LogDestinationConfigs: networkfirewall.LoggingConfigurationLoggingConfigurationLogDestinationConfigArray{
 * 					&networkfirewall.LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs{
 * 						LogDestination: pulumi.StringMap{
 * 							"deliveryStream": pulumi.Any(exampleAwsKinesisFirehoseDeliveryStream.Name),
 * 						},
 * 						LogDestinationType: pulumi.String("KinesisDataFirehose"),
 * 						LogType:            pulumi.String("ALERT"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.LoggingConfiguration;
 * import com.pulumi.aws.networkfirewall.LoggingConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.LoggingConfigurationLoggingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LoggingConfiguration("example", LoggingConfigurationArgs.builder()
 *             .firewallArn(exampleAwsNetworkfirewallFirewall.arn())
 *             .loggingConfiguration(LoggingConfigurationLoggingConfigurationArgs.builder()
 *                 .logDestinationConfigs(LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs.builder()
 *                     .logDestination(Map.of("deliveryStream", exampleAwsKinesisFirehoseDeliveryStream.name()))
 *                     .logDestinationType("KinesisDataFirehose")
 *                     .logType("ALERT")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkfirewall:LoggingConfiguration
 *     properties:
 *       firewallArn: ${exampleAwsNetworkfirewallFirewall.arn}
 *       loggingConfiguration:
 *         logDestinationConfigs:
 *           - logDestination:
 *               deliveryStream: ${exampleAwsKinesisFirehoseDeliveryStream.name}
 *             logDestinationType: KinesisDataFirehose
 *             logType: ALERT
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Network Firewall Logging Configurations using the `firewall_arn`. For example:
 * ```sh
 * $ pulumi import aws:networkfirewall/loggingConfiguration:LoggingConfiguration example arn:aws:network-firewall:us-west-1:123456789012:firewall/example
 * ```
 * @property firewallArn The Amazon Resource Name (ARN) of the Network Firewall firewall.
 * @property loggingConfiguration A configuration block describing how AWS Network Firewall performs logging for a firewall. See Logging Configuration below for details.
 */
public data class LoggingConfigurationArgs(
    public val firewallArn: Output<String>? = null,
    public val loggingConfiguration: Output<LoggingConfigurationLoggingConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkfirewall.LoggingConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.networkfirewall.LoggingConfigurationArgs =
        com.pulumi.aws.networkfirewall.LoggingConfigurationArgs.builder()
            .firewallArn(firewallArn?.applyValue({ args0 -> args0 }))
            .loggingConfiguration(
                loggingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [LoggingConfigurationArgs].
 */
@PulumiTagMarker
public class LoggingConfigurationArgsBuilder internal constructor() {
    private var firewallArn: Output<String>? = null

    private var loggingConfiguration: Output<LoggingConfigurationLoggingConfigurationArgs>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the Network Firewall firewall.
     */
    @JvmName("aypjxtcwebkowjeo")
    public suspend fun firewallArn(`value`: Output<String>) {
        this.firewallArn = value
    }

    /**
     * @param value A configuration block describing how AWS Network Firewall performs logging for a firewall. See Logging Configuration below for details.
     */
    @JvmName("rbwhdwurnlvwssye")
    public suspend fun loggingConfiguration(`value`: Output<LoggingConfigurationLoggingConfigurationArgs>) {
        this.loggingConfiguration = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Network Firewall firewall.
     */
    @JvmName("rqlxjiunfclwoqpm")
    public suspend fun firewallArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallArn = mapped
    }

    /**
     * @param value A configuration block describing how AWS Network Firewall performs logging for a firewall. See Logging Configuration below for details.
     */
    @JvmName("wrpmjxyranurggid")
    public suspend fun loggingConfiguration(`value`: LoggingConfigurationLoggingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggingConfiguration = mapped
    }

    /**
     * @param argument A configuration block describing how AWS Network Firewall performs logging for a firewall. See Logging Configuration below for details.
     */
    @JvmName("bjwapecditykdwxy")
    public suspend fun loggingConfiguration(argument: suspend LoggingConfigurationLoggingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = LoggingConfigurationLoggingConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.loggingConfiguration = mapped
    }

    internal fun build(): LoggingConfigurationArgs = LoggingConfigurationArgs(
        firewallArn = firewallArn,
        loggingConfiguration = loggingConfiguration,
    )
}
