@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin

import com.pulumi.aws.networkfirewall.NetworkfirewallFunctions.getFirewallPlain
import com.pulumi.aws.networkfirewall.NetworkfirewallFunctions.getFirewallPolicyPlain
import com.pulumi.aws.networkfirewall.NetworkfirewallFunctions.getResourcePolicyPlain
import com.pulumi.aws.networkfirewall.kotlin.inputs.GetFirewallPlainArgs
import com.pulumi.aws.networkfirewall.kotlin.inputs.GetFirewallPlainArgsBuilder
import com.pulumi.aws.networkfirewall.kotlin.inputs.GetFirewallPolicyPlainArgs
import com.pulumi.aws.networkfirewall.kotlin.inputs.GetFirewallPolicyPlainArgsBuilder
import com.pulumi.aws.networkfirewall.kotlin.inputs.GetResourcePolicyPlainArgs
import com.pulumi.aws.networkfirewall.kotlin.inputs.GetResourcePolicyPlainArgsBuilder
import com.pulumi.aws.networkfirewall.kotlin.outputs.GetFirewallPolicyResult
import com.pulumi.aws.networkfirewall.kotlin.outputs.GetFirewallResult
import com.pulumi.aws.networkfirewall.kotlin.outputs.GetResourcePolicyResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.networkfirewall.kotlin.outputs.GetFirewallPolicyResult.Companion.toKotlin as getFirewallPolicyResultToKotlin
import com.pulumi.aws.networkfirewall.kotlin.outputs.GetFirewallResult.Companion.toKotlin as getFirewallResultToKotlin
import com.pulumi.aws.networkfirewall.kotlin.outputs.GetResourcePolicyResult.Companion.toKotlin as getResourcePolicyResultToKotlin

public object NetworkfirewallFunctions {
    /**
     * Retrieve information about a firewall.
     * ## Example Usage
     * ### Find firewall policy by ARN
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.networkfirewall.getFirewall({
     *     arn: arn,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.networkfirewall.get_firewall(arn=arn)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.NetworkFirewall.GetFirewall.Invoke(new()
     *     {
     *         Arn = arn,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkfirewall"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := networkfirewall.LookupFirewall(ctx, &networkfirewall.LookupFirewallArgs{
     * 			Arn: pulumi.StringRef(arn),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkfirewall.NetworkfirewallFunctions;
     * import com.pulumi.aws.networkfirewall.inputs.GetFirewallArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkfirewallFunctions.getFirewall(GetFirewallArgs.builder()
     *             .arn(arn)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:networkfirewall:getFirewall
     *       Arguments:
     *         arn: ${arn}
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Find firewall policy by Name
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.networkfirewall.getFirewall({
     *     name: "Test",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.networkfirewall.get_firewall(name="Test")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.NetworkFirewall.GetFirewall.Invoke(new()
     *     {
     *         Name = "Test",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkfirewall"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := networkfirewall.LookupFirewall(ctx, &networkfirewall.LookupFirewallArgs{
     * 			Name: pulumi.StringRef("Test"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkfirewall.NetworkfirewallFunctions;
     * import com.pulumi.aws.networkfirewall.inputs.GetFirewallArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkfirewallFunctions.getFirewall(GetFirewallArgs.builder()
     *             .name("Test")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:networkfirewall:getFirewall
     *       Arguments:
     *         name: Test
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Find firewall policy by ARN and Name
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.networkfirewall.getFirewall({
     *     arn: arn,
     *     name: "Test",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.networkfirewall.get_firewall(arn=arn,
     *     name="Test")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.NetworkFirewall.GetFirewall.Invoke(new()
     *     {
     *         Arn = arn,
     *         Name = "Test",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkfirewall"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := networkfirewall.LookupFirewall(ctx, &networkfirewall.LookupFirewallArgs{
     * 			Arn:  pulumi.StringRef(arn),
     * 			Name: pulumi.StringRef("Test"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkfirewall.NetworkfirewallFunctions;
     * import com.pulumi.aws.networkfirewall.inputs.GetFirewallArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkfirewallFunctions.getFirewall(GetFirewallArgs.builder()
     *             .arn(arn)
     *             .name("Test")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:networkfirewall:getFirewall
     *       Arguments:
     *         arn: ${arn}
     *         name: Test
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getFirewall.
     * @return A collection of values returned by getFirewall.
     */
    public suspend fun getFirewall(argument: GetFirewallPlainArgs): GetFirewallResult =
        getFirewallResultToKotlin(getFirewallPlain(argument.toJava()).await())

    /**
     * @see [getFirewall].
     * @param arn ARN of the firewall.
     * @param name Descriptive name of the firewall.
     * @param tags Map of resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * @return A collection of values returned by getFirewall.
     */
    public suspend fun getFirewall(
        arn: String? = null,
        name: String? = null,
        tags: Map<String, String>? = null,
    ): GetFirewallResult {
        val argument = GetFirewallPlainArgs(
            arn = arn,
            name = name,
            tags = tags,
        )
        return getFirewallResultToKotlin(getFirewallPlain(argument.toJava()).await())
    }

    /**
     * @see [getFirewall].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;networkfirewall&#46;kotlin&#46;inputs&#46;GetFirewallPlainArgs].
     * @return A collection of values returned by getFirewall.
     */
    public suspend fun getFirewall(argument: suspend GetFirewallPlainArgsBuilder.() -> Unit): GetFirewallResult {
        val builder = GetFirewallPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFirewallResultToKotlin(getFirewallPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about a firewall policy.
     * ## Example Usage
     * ### Find firewall policy by name
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.networkfirewall.getFirewallPolicy({
     *     name: firewallPolicyName,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.networkfirewall.get_firewall_policy(name=firewall_policy_name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.NetworkFirewall.GetFirewallPolicy.Invoke(new()
     *     {
     *         Name = firewallPolicyName,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkfirewall"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := networkfirewall.LookupFirewallPolicy(ctx, &networkfirewall.LookupFirewallPolicyArgs{
     * 			Name: pulumi.StringRef(firewallPolicyName),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkfirewall.NetworkfirewallFunctions;
     * import com.pulumi.aws.networkfirewall.inputs.GetFirewallPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkfirewallFunctions.getFirewallPolicy(GetFirewallPolicyArgs.builder()
     *             .name(firewallPolicyName)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:networkfirewall:getFirewallPolicy
     *       Arguments:
     *         name: ${firewallPolicyName}
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Find firewall policy by ARN
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.networkfirewall.getFirewallPolicy({
     *     arn: firewallPolicyArn,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.networkfirewall.get_firewall_policy(arn=firewall_policy_arn)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.NetworkFirewall.GetFirewallPolicy.Invoke(new()
     *     {
     *         Arn = firewallPolicyArn,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkfirewall"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := networkfirewall.LookupFirewallPolicy(ctx, &networkfirewall.LookupFirewallPolicyArgs{
     * 			Arn: pulumi.StringRef(firewallPolicyArn),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkfirewall.NetworkfirewallFunctions;
     * import com.pulumi.aws.networkfirewall.inputs.GetFirewallPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkfirewallFunctions.getFirewallPolicy(GetFirewallPolicyArgs.builder()
     *             .arn(firewallPolicyArn)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:networkfirewall:getFirewallPolicy
     *       Arguments:
     *         arn: ${firewallPolicyArn}
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Find firewall policy by name and ARN
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.networkfirewall.getFirewallPolicy({
     *     arn: firewallPolicyArn,
     *     name: firewallPolicyName,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.networkfirewall.get_firewall_policy(arn=firewall_policy_arn,
     *     name=firewall_policy_name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.NetworkFirewall.GetFirewallPolicy.Invoke(new()
     *     {
     *         Arn = firewallPolicyArn,
     *         Name = firewallPolicyName,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkfirewall"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := networkfirewall.LookupFirewallPolicy(ctx, &networkfirewall.LookupFirewallPolicyArgs{
     * 			Arn:  pulumi.StringRef(firewallPolicyArn),
     * 			Name: pulumi.StringRef(firewallPolicyName),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkfirewall.NetworkfirewallFunctions;
     * import com.pulumi.aws.networkfirewall.inputs.GetFirewallPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkfirewallFunctions.getFirewallPolicy(GetFirewallPolicyArgs.builder()
     *             .arn(firewallPolicyArn)
     *             .name(firewallPolicyName)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:networkfirewall:getFirewallPolicy
     *       Arguments:
     *         arn: ${firewallPolicyArn}
     *         name: ${firewallPolicyName}
     * ```
     * <!--End PulumiCodeChooser -->
     * AWS Network Firewall does not allow multiple firewall policies with the same name to be created in an account. It is possible, however, to have multiple firewall policies available in a single account with identical `name` values but distinct `arn` values, e.g. firewall policies shared via a [Resource Access Manager (RAM) share][1]. In that case specifying `arn`, or `name` and `arn`, is recommended.
     * > **Note:** If there are multiple firewall policies in an account with the same `name`, and `arn` is not specified, the default behavior will return the firewall policy with `name` that was created in the account.
     * @param argument A collection of arguments for invoking getFirewallPolicy.
     * @return A collection of values returned by getFirewallPolicy.
     */
    public suspend fun getFirewallPolicy(argument: GetFirewallPolicyPlainArgs): GetFirewallPolicyResult =
        getFirewallPolicyResultToKotlin(getFirewallPolicyPlain(argument.toJava()).await())

    /**
     * @see [getFirewallPolicy].
     * @param arn ARN of the firewall policy.
     * @param name Descriptive name of the firewall policy.
     * @param tags Key-value tags for the firewall policy.
     * @return A collection of values returned by getFirewallPolicy.
     */
    public suspend fun getFirewallPolicy(
        arn: String? = null,
        name: String? = null,
        tags: Map<String, String>? = null,
    ): GetFirewallPolicyResult {
        val argument = GetFirewallPolicyPlainArgs(
            arn = arn,
            name = name,
            tags = tags,
        )
        return getFirewallPolicyResultToKotlin(getFirewallPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getFirewallPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;networkfirewall&#46;kotlin&#46;inputs&#46;GetFirewallPolicyPlainArgs].
     * @return A collection of values returned by getFirewallPolicy.
     */
    public suspend fun getFirewallPolicy(argument: suspend GetFirewallPolicyPlainArgsBuilder.() -> Unit): GetFirewallPolicyResult {
        val builder = GetFirewallPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFirewallPolicyResultToKotlin(getFirewallPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about a Network Firewall resource policy.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.networkfirewall.getResourcePolicy({
     *     resourceArn: resourcePolicyArn,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.networkfirewall.get_resource_policy(resource_arn=resource_policy_arn)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.NetworkFirewall.GetResourcePolicy.Invoke(new()
     *     {
     *         ResourceArn = resourcePolicyArn,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkfirewall"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := networkfirewall.LookupResourcePolicy(ctx, &networkfirewall.LookupResourcePolicyArgs{
     * 			ResourceArn: resourcePolicyArn,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkfirewall.NetworkfirewallFunctions;
     * import com.pulumi.aws.networkfirewall.inputs.GetResourcePolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkfirewallFunctions.getResourcePolicy(GetResourcePolicyArgs.builder()
     *             .resourceArn(resourcePolicyArn)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:networkfirewall:getResourcePolicy
     *       Arguments:
     *         resourceArn: ${resourcePolicyArn}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getResourcePolicy.
     * @return A collection of values returned by getResourcePolicy.
     */
    public suspend fun getResourcePolicy(argument: GetResourcePolicyPlainArgs): GetResourcePolicyResult =
        getResourcePolicyResultToKotlin(getResourcePolicyPlain(argument.toJava()).await())

    /**
     * @see [getResourcePolicy].
     * @param resourceArn The Amazon Resource Name (ARN) that identifies the resource policy.
     * @return A collection of values returned by getResourcePolicy.
     */
    public suspend fun getResourcePolicy(resourceArn: String): GetResourcePolicyResult {
        val argument = GetResourcePolicyPlainArgs(
            resourceArn = resourceArn,
        )
        return getResourcePolicyResultToKotlin(getResourcePolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getResourcePolicy].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;networkfirewall&#46;kotlin&#46;inputs&#46;GetResourcePolicyPlainArgs].
     * @return A collection of values returned by getResourcePolicy.
     */
    public suspend fun getResourcePolicy(argument: suspend GetResourcePolicyPlainArgsBuilder.() -> Unit): GetResourcePolicyResult {
        val builder = GetResourcePolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getResourcePolicyResultToKotlin(getResourcePolicyPlain(builtArgument.toJava()).await())
    }
}
