@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin

import com.pulumi.aws.networkfirewall.kotlin.outputs.TlsInspectionConfigurationCertificate
import com.pulumi.aws.networkfirewall.kotlin.outputs.TlsInspectionConfigurationCertificateAuthority
import com.pulumi.aws.networkfirewall.kotlin.outputs.TlsInspectionConfigurationEncryptionConfiguration
import com.pulumi.aws.networkfirewall.kotlin.outputs.TlsInspectionConfigurationTimeouts
import com.pulumi.aws.networkfirewall.kotlin.outputs.TlsInspectionConfigurationTlsInspectionConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.networkfirewall.kotlin.outputs.TlsInspectionConfigurationCertificate.Companion.toKotlin as tlsInspectionConfigurationCertificateToKotlin
import com.pulumi.aws.networkfirewall.kotlin.outputs.TlsInspectionConfigurationCertificateAuthority.Companion.toKotlin as tlsInspectionConfigurationCertificateAuthorityToKotlin
import com.pulumi.aws.networkfirewall.kotlin.outputs.TlsInspectionConfigurationEncryptionConfiguration.Companion.toKotlin as tlsInspectionConfigurationEncryptionConfigurationToKotlin
import com.pulumi.aws.networkfirewall.kotlin.outputs.TlsInspectionConfigurationTimeouts.Companion.toKotlin as tlsInspectionConfigurationTimeoutsToKotlin
import com.pulumi.aws.networkfirewall.kotlin.outputs.TlsInspectionConfigurationTlsInspectionConfiguration.Companion.toKotlin as tlsInspectionConfigurationTlsInspectionConfigurationToKotlin

/**
 * Builder for [TlsInspectionConfiguration].
 */
@PulumiTagMarker
public class TlsInspectionConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TlsInspectionConfigurationArgs = TlsInspectionConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TlsInspectionConfigurationArgsBuilder.() -> Unit) {
        val builder = TlsInspectionConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TlsInspectionConfiguration {
        val builtJavaResource =
            com.pulumi.aws.networkfirewall.TlsInspectionConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TlsInspectionConfiguration(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Network Firewall TLS Inspection Configuration.
 * ## Example Usage
 * > **NOTE:** You must configure either inbound inspection, outbound inspection, or both.
 * ### Basic inbound/ingress inspection
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkfirewall.TlsInspectionConfiguration("example", {
 *     name: "example",
 *     description: "example",
 *     encryptionConfigurations: [{
 *         keyId: "AWS_OWNED_KMS_KEY",
 *         type: "AWS_OWNED_KMS_KEY",
 *     }],
 *     tlsInspectionConfiguration: {
 *         serverCertificateConfiguration: {
 *             serverCertificates: [{
 *                 resourceArn: example1.arn,
 *             }],
 *             scopes: [{
 *                 protocols: [6],
 *                 destinationPorts: [{
 *                     fromPort: 443,
 *                     toPort: 443,
 *                 }],
 *                 destinations: [{
 *                     addressDefinition: "0.0.0.0/0",
 *                 }],
 *                 sourcePorts: [{
 *                     fromPort: 0,
 *                     toPort: 65535,
 *                 }],
 *                 sources: [{
 *                     addressDefinition: "0.0.0.0/0",
 *                 }],
 *             }],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkfirewall.TlsInspectionConfiguration("example",
 *     name="example",
 *     description="example",
 *     encryption_configurations=[{
 *         "key_id": "AWS_OWNED_KMS_KEY",
 *         "type": "AWS_OWNED_KMS_KEY",
 *     }],
 *     tls_inspection_configuration={
 *         "server_certificate_configuration": {
 *             "server_certificates": [{
 *                 "resource_arn": example1["arn"],
 *             }],
 *             "scopes": [{
 *                 "protocols": [6],
 *                 "destination_ports": [{
 *                     "from_port": 443,
 *                     "to_port": 443,
 *                 }],
 *                 "destinations": [{
 *                     "address_definition": "0.0.0.0/0",
 *                 }],
 *                 "source_ports": [{
 *                     "from_port": 0,
 *                     "to_port": 65535,
 *                 }],
 *                 "sources": [{
 *                     "address_definition": "0.0.0.0/0",
 *                 }],
 *             }],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkFirewall.TlsInspectionConfiguration("example", new()
 *     {
 *         Name = "example",
 *         Description = "example",
 *         EncryptionConfigurations = new[]
 *         {
 *             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationEncryptionConfigurationArgs
 *             {
 *                 KeyId = "AWS_OWNED_KMS_KEY",
 *                 Type = "AWS_OWNED_KMS_KEY",
 *             },
 *         },
 *         TlsInspectionConfig = new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationArgs
 *         {
 *             ServerCertificateConfiguration = new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs
 *             {
 *                 ServerCertificates = new[]
 *                 {
 *                     new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgs
 *                     {
 *                         ResourceArn = example1.Arn,
 *                     },
 *                 },
 *                 Scopes = new[]
 *                 {
 *                     new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs
 *                     {
 *                         Protocols = new[]
 *                         {
 *                             6,
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs
 *                             {
 *                                 FromPort = 443,
 *                                 ToPort = 443,
 *                             },
 *                         },
 *                         Destinations = new[]
 *                         {
 *                             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgs
 *                             {
 *                                 AddressDefinition = "0.0.0.0/0",
 *                             },
 *                         },
 *                         SourcePorts = new[]
 *                         {
 *                             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgs
 *                             {
 *                                 FromPort = 0,
 *                                 ToPort = 65535,
 *                             },
 *                         },
 *                         Sources = new[]
 *                         {
 *                             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs
 *                             {
 *                                 AddressDefinition = "0.0.0.0/0",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkfirewall.NewTlsInspectionConfiguration(ctx, "example", &networkfirewall.TlsInspectionConfigurationArgs{
 * 			Name:        pulumi.String("example"),
 * 			Description: pulumi.String("example"),
 * 			EncryptionConfigurations: networkfirewall.TlsInspectionConfigurationEncryptionConfigurationArray{
 * 				&networkfirewall.TlsInspectionConfigurationEncryptionConfigurationArgs{
 * 					KeyId: pulumi.String("AWS_OWNED_KMS_KEY"),
 * 					Type:  pulumi.String("AWS_OWNED_KMS_KEY"),
 * 				},
 * 			},
 * 			TlsInspectionConfiguration: &networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationArgs{
 * 				ServerCertificateConfiguration: &networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs{
 * 					ServerCertificates: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArray{
 * 						&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgs{
 * 							ResourceArn: pulumi.Any(example1.Arn),
 * 						},
 * 					},
 * 					Scopes: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArray{
 * 						&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs{
 * 							Protocols: pulumi.IntArray{
 * 								pulumi.Int(6),
 * 							},
 * 							DestinationPorts: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArray{
 * 								&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs{
 * 									FromPort: pulumi.Int(443),
 * 									ToPort:   pulumi.Int(443),
 * 								},
 * 							},
 * 							Destinations: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArray{
 * 								&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgs{
 * 									AddressDefinition: pulumi.String("0.0.0.0/0"),
 * 								},
 * 							},
 * 							SourcePorts: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArray{
 * 								&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgs{
 * 									FromPort: pulumi.Int(0),
 * 									ToPort:   pulumi.Int(65535),
 * 								},
 * 							},
 * 							Sources: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArray{
 * 								&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs{
 * 									AddressDefinition: pulumi.String("0.0.0.0/0"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.TlsInspectionConfiguration;
 * import com.pulumi.aws.networkfirewall.TlsInspectionConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationEncryptionConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TlsInspectionConfiguration("example", TlsInspectionConfigurationArgs.builder()
 *             .name("example")
 *             .description("example")
 *             .encryptionConfigurations(TlsInspectionConfigurationEncryptionConfigurationArgs.builder()
 *                 .keyId("AWS_OWNED_KMS_KEY")
 *                 .type("AWS_OWNED_KMS_KEY")
 *                 .build())
 *             .tlsInspectionConfiguration(TlsInspectionConfigurationTlsInspectionConfigurationArgs.builder()
 *                 .serverCertificateConfiguration(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs.builder()
 *                     .serverCertificates(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgs.builder()
 *                         .resourceArn(example1.arn())
 *                         .build())
 *                     .scopes(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs.builder()
 *                         .protocols(6)
 *                         .destinationPorts(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs.builder()
 *                             .fromPort(443)
 *                             .toPort(443)
 *                             .build())
 *                         .destinations(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgs.builder()
 *                             .addressDefinition("0.0.0.0/0")
 *                             .build())
 *                         .sourcePorts(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgs.builder()
 *                             .fromPort(0)
 *                             .toPort(65535)
 *                             .build())
 *                         .sources(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs.builder()
 *                             .addressDefinition("0.0.0.0/0")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkfirewall:TlsInspectionConfiguration
 *     properties:
 *       name: example
 *       description: example
 *       encryptionConfigurations:
 *         - keyId: AWS_OWNED_KMS_KEY
 *           type: AWS_OWNED_KMS_KEY
 *       tlsInspectionConfiguration:
 *         serverCertificateConfiguration:
 *           serverCertificates:
 *             - resourceArn: ${example1.arn}
 *           scopes:
 *             - protocols:
 *                 - 6
 *               destinationPorts:
 *                 - fromPort: 443
 *                   toPort: 443
 *               destinations:
 *                 - addressDefinition: 0.0.0.0/0
 *               sourcePorts:
 *                 - fromPort: 0
 *                   toPort: 65535
 *               sources:
 *                 - addressDefinition: 0.0.0.0/0
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Basic outbound/engress inspection
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkfirewall.TlsInspectionConfiguration("example", {
 *     name: "example",
 *     description: "example",
 *     encryptionConfigurations: [{
 *         keyId: "AWS_OWNED_KMS_KEY",
 *         type: "AWS_OWNED_KMS_KEY",
 *     }],
 *     tlsInspectionConfiguration: {
 *         serverCertificateConfiguration: {
 *             certificateAuthorityArn: example1.arn,
 *             checkCertificateRevocationStatus: {
 *                 revokedStatusAction: "REJECT",
 *                 unknownStatusAction: "PASS",
 *             },
 *             scopes: [{
 *                 protocols: [6],
 *                 destinationPorts: [{
 *                     fromPort: 443,
 *                     toPort: 443,
 *                 }],
 *                 destinations: [{
 *                     addressDefinition: "0.0.0.0/0",
 *                 }],
 *                 sourcePorts: [{
 *                     fromPort: 0,
 *                     toPort: 65535,
 *                 }],
 *                 sources: [{
 *                     addressDefinition: "0.0.0.0/0",
 *                 }],
 *             }],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkfirewall.TlsInspectionConfiguration("example",
 *     name="example",
 *     description="example",
 *     encryption_configurations=[{
 *         "key_id": "AWS_OWNED_KMS_KEY",
 *         "type": "AWS_OWNED_KMS_KEY",
 *     }],
 *     tls_inspection_configuration={
 *         "server_certificate_configuration": {
 *             "certificate_authority_arn": example1["arn"],
 *             "check_certificate_revocation_status": {
 *                 "revoked_status_action": "REJECT",
 *                 "unknown_status_action": "PASS",
 *             },
 *             "scopes": [{
 *                 "protocols": [6],
 *                 "destination_ports": [{
 *                     "from_port": 443,
 *                     "to_port": 443,
 *                 }],
 *                 "destinations": [{
 *                     "address_definition": "0.0.0.0/0",
 *                 }],
 *                 "source_ports": [{
 *                     "from_port": 0,
 *                     "to_port": 65535,
 *                 }],
 *                 "sources": [{
 *                     "address_definition": "0.0.0.0/0",
 *                 }],
 *             }],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkFirewall.TlsInspectionConfiguration("example", new()
 *     {
 *         Name = "example",
 *         Description = "example",
 *         EncryptionConfigurations = new[]
 *         {
 *             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationEncryptionConfigurationArgs
 *             {
 *                 KeyId = "AWS_OWNED_KMS_KEY",
 *                 Type = "AWS_OWNED_KMS_KEY",
 *             },
 *         },
 *         TlsInspectionConfig = new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationArgs
 *         {
 *             ServerCertificateConfiguration = new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs
 *             {
 *                 CertificateAuthorityArn = example1.Arn,
 *                 CheckCertificateRevocationStatus = new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationCheckCertificateRevocationStatusArgs
 *                 {
 *                     RevokedStatusAction = "REJECT",
 *                     UnknownStatusAction = "PASS",
 *                 },
 *                 Scopes = new[]
 *                 {
 *                     new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs
 *                     {
 *                         Protocols = new[]
 *                         {
 *                             6,
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs
 *                             {
 *                                 FromPort = 443,
 *                                 ToPort = 443,
 *                             },
 *                         },
 *                         Destinations = new[]
 *                         {
 *                             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgs
 *                             {
 *                                 AddressDefinition = "0.0.0.0/0",
 *                             },
 *                         },
 *                         SourcePorts = new[]
 *                         {
 *                             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgs
 *                             {
 *                                 FromPort = 0,
 *                                 ToPort = 65535,
 *                             },
 *                         },
 *                         Sources = new[]
 *                         {
 *                             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs
 *                             {
 *                                 AddressDefinition = "0.0.0.0/0",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkfirewall.NewTlsInspectionConfiguration(ctx, "example", &networkfirewall.TlsInspectionConfigurationArgs{
 * 			Name:        pulumi.String("example"),
 * 			Description: pulumi.String("example"),
 * 			EncryptionConfigurations: networkfirewall.TlsInspectionConfigurationEncryptionConfigurationArray{
 * 				&networkfirewall.TlsInspectionConfigurationEncryptionConfigurationArgs{
 * 					KeyId: pulumi.String("AWS_OWNED_KMS_KEY"),
 * 					Type:  pulumi.String("AWS_OWNED_KMS_KEY"),
 * 				},
 * 			},
 * 			TlsInspectionConfiguration: &networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationArgs{
 * 				ServerCertificateConfiguration: &networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs{
 * 					CertificateAuthorityArn: pulumi.Any(example1.Arn),
 * 					CheckCertificateRevocationStatus: &networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationCheckCertificateRevocationStatusArgs{
 * 						RevokedStatusAction: pulumi.String("REJECT"),
 * 						UnknownStatusAction: pulumi.String("PASS"),
 * 					},
 * 					Scopes: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArray{
 * 						&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs{
 * 							Protocols: pulumi.IntArray{
 * 								pulumi.Int(6),
 * 							},
 * 							DestinationPorts: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArray{
 * 								&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs{
 * 									FromPort: pulumi.Int(443),
 * 									ToPort:   pulumi.Int(443),
 * 								},
 * 							},
 * 							Destinations: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArray{
 * 								&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgs{
 * 									AddressDefinition: pulumi.String("0.0.0.0/0"),
 * 								},
 * 							},
 * 							SourcePorts: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArray{
 * 								&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgs{
 * 									FromPort: pulumi.Int(0),
 * 									ToPort:   pulumi.Int(65535),
 * 								},
 * 							},
 * 							Sources: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArray{
 * 								&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs{
 * 									AddressDefinition: pulumi.String("0.0.0.0/0"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.TlsInspectionConfiguration;
 * import com.pulumi.aws.networkfirewall.TlsInspectionConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationEncryptionConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationCheckCertificateRevocationStatusArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TlsInspectionConfiguration("example", TlsInspectionConfigurationArgs.builder()
 *             .name("example")
 *             .description("example")
 *             .encryptionConfigurations(TlsInspectionConfigurationEncryptionConfigurationArgs.builder()
 *                 .keyId("AWS_OWNED_KMS_KEY")
 *                 .type("AWS_OWNED_KMS_KEY")
 *                 .build())
 *             .tlsInspectionConfiguration(TlsInspectionConfigurationTlsInspectionConfigurationArgs.builder()
 *                 .serverCertificateConfiguration(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs.builder()
 *                     .certificateAuthorityArn(example1.arn())
 *                     .checkCertificateRevocationStatus(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationCheckCertificateRevocationStatusArgs.builder()
 *                         .revokedStatusAction("REJECT")
 *                         .unknownStatusAction("PASS")
 *                         .build())
 *                     .scopes(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs.builder()
 *                         .protocols(6)
 *                         .destinationPorts(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs.builder()
 *                             .fromPort(443)
 *                             .toPort(443)
 *                             .build())
 *                         .destinations(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgs.builder()
 *                             .addressDefinition("0.0.0.0/0")
 *                             .build())
 *                         .sourcePorts(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgs.builder()
 *                             .fromPort(0)
 *                             .toPort(65535)
 *                             .build())
 *                         .sources(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs.builder()
 *                             .addressDefinition("0.0.0.0/0")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkfirewall:TlsInspectionConfiguration
 *     properties:
 *       name: example
 *       description: example
 *       encryptionConfigurations:
 *         - keyId: AWS_OWNED_KMS_KEY
 *           type: AWS_OWNED_KMS_KEY
 *       tlsInspectionConfiguration:
 *         serverCertificateConfiguration:
 *           certificateAuthorityArn: ${example1.arn}
 *           checkCertificateRevocationStatus:
 *             revokedStatusAction: REJECT
 *             unknownStatusAction: PASS
 *           scopes:
 *             - protocols:
 *                 - 6
 *               destinationPorts:
 *                 - fromPort: 443
 *                   toPort: 443
 *               destinations:
 *                 - addressDefinition: 0.0.0.0/0
 *               sourcePorts:
 *                 - fromPort: 0
 *                   toPort: 65535
 *               sources:
 *                 - addressDefinition: 0.0.0.0/0
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Inbound with encryption configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.kms.Key("example", {
 *     description: "example",
 *     deletionWindowInDays: 7,
 * });
 * const exampleTlsInspectionConfiguration = new aws.networkfirewall.TlsInspectionConfiguration("example", {
 *     name: "example",
 *     description: "example",
 *     encryptionConfigurations: [{
 *         keyId: example.arn,
 *         type: "CUSTOMER_KMS",
 *     }],
 *     tlsInspectionConfiguration: {
 *         serverCertificateConfiguration: {
 *             serverCertificates: [{
 *                 resourceArn: example1.arn,
 *             }],
 *             scopes: [{
 *                 protocols: [6],
 *                 destinationPorts: [{
 *                     fromPort: 443,
 *                     toPort: 443,
 *                 }],
 *                 destinations: [{
 *                     addressDefinition: "0.0.0.0/0",
 *                 }],
 *                 sourcePorts: [{
 *                     fromPort: 0,
 *                     toPort: 65535,
 *                 }],
 *                 sources: [{
 *                     addressDefinition: "0.0.0.0/0",
 *                 }],
 *             }],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.kms.Key("example",
 *     description="example",
 *     deletion_window_in_days=7)
 * example_tls_inspection_configuration = aws.networkfirewall.TlsInspectionConfiguration("example",
 *     name="example",
 *     description="example",
 *     encryption_configurations=[{
 *         "key_id": example.arn,
 *         "type": "CUSTOMER_KMS",
 *     }],
 *     tls_inspection_configuration={
 *         "server_certificate_configuration": {
 *             "server_certificates": [{
 *                 "resource_arn": example1["arn"],
 *             }],
 *             "scopes": [{
 *                 "protocols": [6],
 *                 "destination_ports": [{
 *                     "from_port": 443,
 *                     "to_port": 443,
 *                 }],
 *                 "destinations": [{
 *                     "address_definition": "0.0.0.0/0",
 *                 }],
 *                 "source_ports": [{
 *                     "from_port": 0,
 *                     "to_port": 65535,
 *                 }],
 *                 "sources": [{
 *                     "address_definition": "0.0.0.0/0",
 *                 }],
 *             }],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Kms.Key("example", new()
 *     {
 *         Description = "example",
 *         DeletionWindowInDays = 7,
 *     });
 *     var exampleTlsInspectionConfiguration = new Aws.NetworkFirewall.TlsInspectionConfiguration("example", new()
 *     {
 *         Name = "example",
 *         Description = "example",
 *         EncryptionConfigurations = new[]
 *         {
 *             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationEncryptionConfigurationArgs
 *             {
 *                 KeyId = example.Arn,
 *                 Type = "CUSTOMER_KMS",
 *             },
 *         },
 *         TlsInspectionConfig = new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationArgs
 *         {
 *             ServerCertificateConfiguration = new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs
 *             {
 *                 ServerCertificates = new[]
 *                 {
 *                     new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgs
 *                     {
 *                         ResourceArn = example1.Arn,
 *                     },
 *                 },
 *                 Scopes = new[]
 *                 {
 *                     new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs
 *                     {
 *                         Protocols = new[]
 *                         {
 *                             6,
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs
 *                             {
 *                                 FromPort = 443,
 *                                 ToPort = 443,
 *                             },
 *                         },
 *                         Destinations = new[]
 *                         {
 *                             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgs
 *                             {
 *                                 AddressDefinition = "0.0.0.0/0",
 *                             },
 *                         },
 *                         SourcePorts = new[]
 *                         {
 *                             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgs
 *                             {
 *                                 FromPort = 0,
 *                                 ToPort = 65535,
 *                             },
 *                         },
 *                         Sources = new[]
 *                         {
 *                             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs
 *                             {
 *                                 AddressDefinition = "0.0.0.0/0",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := kms.NewKey(ctx, "example", &kms.KeyArgs{
 * 			Description:          pulumi.String("example"),
 * 			DeletionWindowInDays: pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = networkfirewall.NewTlsInspectionConfiguration(ctx, "example", &networkfirewall.TlsInspectionConfigurationArgs{
 * 			Name:        pulumi.String("example"),
 * 			Description: pulumi.String("example"),
 * 			EncryptionConfigurations: networkfirewall.TlsInspectionConfigurationEncryptionConfigurationArray{
 * 				&networkfirewall.TlsInspectionConfigurationEncryptionConfigurationArgs{
 * 					KeyId: example.Arn,
 * 					Type:  pulumi.String("CUSTOMER_KMS"),
 * 				},
 * 			},
 * 			TlsInspectionConfiguration: &networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationArgs{
 * 				ServerCertificateConfiguration: &networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs{
 * 					ServerCertificates: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArray{
 * 						&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgs{
 * 							ResourceArn: pulumi.Any(example1.Arn),
 * 						},
 * 					},
 * 					Scopes: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArray{
 * 						&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs{
 * 							Protocols: pulumi.IntArray{
 * 								pulumi.Int(6),
 * 							},
 * 							DestinationPorts: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArray{
 * 								&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs{
 * 									FromPort: pulumi.Int(443),
 * 									ToPort:   pulumi.Int(443),
 * 								},
 * 							},
 * 							Destinations: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArray{
 * 								&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgs{
 * 									AddressDefinition: pulumi.String("0.0.0.0/0"),
 * 								},
 * 							},
 * 							SourcePorts: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArray{
 * 								&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgs{
 * 									FromPort: pulumi.Int(0),
 * 									ToPort:   pulumi.Int(65535),
 * 								},
 * 							},
 * 							Sources: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArray{
 * 								&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs{
 * 									AddressDefinition: pulumi.String("0.0.0.0/0"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.networkfirewall.TlsInspectionConfiguration;
 * import com.pulumi.aws.networkfirewall.TlsInspectionConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationEncryptionConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Key("example", KeyArgs.builder()
 *             .description("example")
 *             .deletionWindowInDays(7)
 *             .build());
 *         var exampleTlsInspectionConfiguration = new TlsInspectionConfiguration("exampleTlsInspectionConfiguration", TlsInspectionConfigurationArgs.builder()
 *             .name("example")
 *             .description("example")
 *             .encryptionConfigurations(TlsInspectionConfigurationEncryptionConfigurationArgs.builder()
 *                 .keyId(example.arn())
 *                 .type("CUSTOMER_KMS")
 *                 .build())
 *             .tlsInspectionConfiguration(TlsInspectionConfigurationTlsInspectionConfigurationArgs.builder()
 *                 .serverCertificateConfiguration(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs.builder()
 *                     .serverCertificates(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgs.builder()
 *                         .resourceArn(example1.arn())
 *                         .build())
 *                     .scopes(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs.builder()
 *                         .protocols(6)
 *                         .destinationPorts(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs.builder()
 *                             .fromPort(443)
 *                             .toPort(443)
 *                             .build())
 *                         .destinations(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgs.builder()
 *                             .addressDefinition("0.0.0.0/0")
 *                             .build())
 *                         .sourcePorts(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgs.builder()
 *                             .fromPort(0)
 *                             .toPort(65535)
 *                             .build())
 *                         .sources(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs.builder()
 *                             .addressDefinition("0.0.0.0/0")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kms:Key
 *     properties:
 *       description: example
 *       deletionWindowInDays: 7
 *   exampleTlsInspectionConfiguration:
 *     type: aws:networkfirewall:TlsInspectionConfiguration
 *     name: example
 *     properties:
 *       name: example
 *       description: example
 *       encryptionConfigurations:
 *         - keyId: ${example.arn}
 *           type: CUSTOMER_KMS
 *       tlsInspectionConfiguration:
 *         serverCertificateConfiguration:
 *           serverCertificates:
 *             - resourceArn: ${example1.arn}
 *           scopes:
 *             - protocols:
 *                 - 6
 *               destinationPorts:
 *                 - fromPort: 443
 *                   toPort: 443
 *               destinations:
 *                 - addressDefinition: 0.0.0.0/0
 *               sourcePorts:
 *                 - fromPort: 0
 *                   toPort: 65535
 *               sources:
 *                 - addressDefinition: 0.0.0.0/0
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Outbound with encryption configuration
 * <!--Start PulumiCodeChooser -->
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.networkfirewall.TlsInspectionConfiguration;
 * import com.pulumi.aws.networkfirewall.TlsInspectionConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationEncryptionConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Key("example", KeyArgs.builder()
 *             .description("example")
 *             .deletionWindowInDays(7)
 *             .build());
 *         var exampleTlsInspectionConfiguration = new TlsInspectionConfiguration("exampleTlsInspectionConfiguration", TlsInspectionConfigurationArgs.builder()
 *             .name("example")
 *             .description("example")
 *             .encryptionConfigurations(TlsInspectionConfigurationEncryptionConfigurationArgs.builder()
 *                 .keyId(example.arn())
 *                 .type("CUSTOMER_KMS")
 *                 .build())
 *             .tlsInspectionConfiguration(TlsInspectionConfigurationTlsInspectionConfigurationArgs.builder()
 *                 .serverCertificateConfigurations(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kms:Key
 *     properties:
 *       description: example
 *       deletionWindowInDays: 7
 *   exampleTlsInspectionConfiguration:
 *     type: aws:networkfirewall:TlsInspectionConfiguration
 *     name: example
 *     properties:
 *       name: example
 *       description: example
 *       encryptionConfigurations:
 *         - keyId: ${example.arn}
 *           type: CUSTOMER_KMS
 *       tlsInspectionConfiguration:
 *         serverCertificateConfigurations:
 *           - certificateAuthorityArn: ${example1.arn}
 *             checkCertificateRevocationStatus:
 *               - revokedStatusAction: REJECT
 *                 unknownStatusAction: PASS
 *             scope:
 *               - protocols:
 *                   - 6
 *                 destinationPorts:
 *                   - fromPort: 443
 *                     toPort: 443
 *                 destination:
 *                   - addressDefinition: 0.0.0.0/0
 *                 sourcePorts:
 *                   - fromPort: 0
 *                     toPort: 65535
 *                 source:
 *                   - addressDefinition: 0.0.0.0/0
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Combined inbound and outbound
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkfirewall.TlsInspectionConfiguration("example", {
 *     name: "example",
 *     description: "example",
 *     encryptionConfigurations: [{
 *         keyId: "AWS_OWNED_KMS_KEY",
 *         type: "AWS_OWNED_KMS_KEY",
 *     }],
 *     tlsInspectionConfiguration: {
 *         serverCertificateConfiguration: {
 *             certificateAuthorityArn: example1.arn,
 *             checkCertificateRevocationStatus: {
 *                 revokedStatusAction: "REJECT",
 *                 unknownStatusAction: "PASS",
 *             },
 *             serverCertificates: [{
 *                 resourceArn: example2.arn,
 *             }],
 *             scopes: [{
 *                 protocols: [6],
 *                 destinationPorts: [{
 *                     fromPort: 443,
 *                     toPort: 443,
 *                 }],
 *                 destinations: [{
 *                     addressDefinition: "0.0.0.0/0",
 *                 }],
 *                 sourcePorts: [{
 *                     fromPort: 0,
 *                     toPort: 65535,
 *                 }],
 *                 sources: [{
 *                     addressDefinition: "0.0.0.0/0",
 *                 }],
 *             }],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkfirewall.TlsInspectionConfiguration("example",
 *     name="example",
 *     description="example",
 *     encryption_configurations=[{
 *         "key_id": "AWS_OWNED_KMS_KEY",
 *         "type": "AWS_OWNED_KMS_KEY",
 *     }],
 *     tls_inspection_configuration={
 *         "server_certificate_configuration": {
 *             "certificate_authority_arn": example1["arn"],
 *             "check_certificate_revocation_status": {
 *                 "revoked_status_action": "REJECT",
 *                 "unknown_status_action": "PASS",
 *             },
 *             "server_certificates": [{
 *                 "resource_arn": example2["arn"],
 *             }],
 *             "scopes": [{
 *                 "protocols": [6],
 *                 "destination_ports": [{
 *                     "from_port": 443,
 *                     "to_port": 443,
 *                 }],
 *                 "destinations": [{
 *                     "address_definition": "0.0.0.0/0",
 *                 }],
 *                 "source_ports": [{
 *                     "from_port": 0,
 *                     "to_port": 65535,
 *                 }],
 *                 "sources": [{
 *                     "address_definition": "0.0.0.0/0",
 *                 }],
 *             }],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkFirewall.TlsInspectionConfiguration("example", new()
 *     {
 *         Name = "example",
 *         Description = "example",
 *         EncryptionConfigurations = new[]
 *         {
 *             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationEncryptionConfigurationArgs
 *             {
 *                 KeyId = "AWS_OWNED_KMS_KEY",
 *                 Type = "AWS_OWNED_KMS_KEY",
 *             },
 *         },
 *         TlsInspectionConfig = new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationArgs
 *         {
 *             ServerCertificateConfiguration = new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs
 *             {
 *                 CertificateAuthorityArn = example1.Arn,
 *                 CheckCertificateRevocationStatus = new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationCheckCertificateRevocationStatusArgs
 *                 {
 *                     RevokedStatusAction = "REJECT",
 *                     UnknownStatusAction = "PASS",
 *                 },
 *                 ServerCertificates = new[]
 *                 {
 *                     new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgs
 *                     {
 *                         ResourceArn = example2.Arn,
 *                     },
 *                 },
 *                 Scopes = new[]
 *                 {
 *                     new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs
 *                     {
 *                         Protocols = new[]
 *                         {
 *                             6,
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs
 *                             {
 *                                 FromPort = 443,
 *                                 ToPort = 443,
 *                             },
 *                         },
 *                         Destinations = new[]
 *                         {
 *                             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgs
 *                             {
 *                                 AddressDefinition = "0.0.0.0/0",
 *                             },
 *                         },
 *                         SourcePorts = new[]
 *                         {
 *                             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgs
 *                             {
 *                                 FromPort = 0,
 *                                 ToPort = 65535,
 *                             },
 *                         },
 *                         Sources = new[]
 *                         {
 *                             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs
 *                             {
 *                                 AddressDefinition = "0.0.0.0/0",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkfirewall.NewTlsInspectionConfiguration(ctx, "example", &networkfirewall.TlsInspectionConfigurationArgs{
 * 			Name:        pulumi.String("example"),
 * 			Description: pulumi.String("example"),
 * 			EncryptionConfigurations: networkfirewall.TlsInspectionConfigurationEncryptionConfigurationArray{
 * 				&networkfirewall.TlsInspectionConfigurationEncryptionConfigurationArgs{
 * 					KeyId: pulumi.String("AWS_OWNED_KMS_KEY"),
 * 					Type:  pulumi.String("AWS_OWNED_KMS_KEY"),
 * 				},
 * 			},
 * 			TlsInspectionConfiguration: &networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationArgs{
 * 				ServerCertificateConfiguration: &networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs{
 * 					CertificateAuthorityArn: pulumi.Any(example1.Arn),
 * 					CheckCertificateRevocationStatus: &networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationCheckCertificateRevocationStatusArgs{
 * 						RevokedStatusAction: pulumi.String("REJECT"),
 * 						UnknownStatusAction: pulumi.String("PASS"),
 * 					},
 * 					ServerCertificates: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArray{
 * 						&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgs{
 * 							ResourceArn: pulumi.Any(example2.Arn),
 * 						},
 * 					},
 * 					Scopes: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArray{
 * 						&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs{
 * 							Protocols: pulumi.IntArray{
 * 								pulumi.Int(6),
 * 							},
 * 							DestinationPorts: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArray{
 * 								&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs{
 * 									FromPort: pulumi.Int(443),
 * 									ToPort:   pulumi.Int(443),
 * 								},
 * 							},
 * 							Destinations: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArray{
 * 								&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgs{
 * 									AddressDefinition: pulumi.String("0.0.0.0/0"),
 * 								},
 * 							},
 * 							SourcePorts: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArray{
 * 								&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgs{
 * 									FromPort: pulumi.Int(0),
 * 									ToPort:   pulumi.Int(65535),
 * 								},
 * 							},
 * 							Sources: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArray{
 * 								&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs{
 * 									AddressDefinition: pulumi.String("0.0.0.0/0"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.TlsInspectionConfiguration;
 * import com.pulumi.aws.networkfirewall.TlsInspectionConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationEncryptionConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationCheckCertificateRevocationStatusArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TlsInspectionConfiguration("example", TlsInspectionConfigurationArgs.builder()
 *             .name("example")
 *             .description("example")
 *             .encryptionConfigurations(TlsInspectionConfigurationEncryptionConfigurationArgs.builder()
 *                 .keyId("AWS_OWNED_KMS_KEY")
 *                 .type("AWS_OWNED_KMS_KEY")
 *                 .build())
 *             .tlsInspectionConfiguration(TlsInspectionConfigurationTlsInspectionConfigurationArgs.builder()
 *                 .serverCertificateConfiguration(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs.builder()
 *                     .certificateAuthorityArn(example1.arn())
 *                     .checkCertificateRevocationStatus(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationCheckCertificateRevocationStatusArgs.builder()
 *                         .revokedStatusAction("REJECT")
 *                         .unknownStatusAction("PASS")
 *                         .build())
 *                     .serverCertificates(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgs.builder()
 *                         .resourceArn(example2.arn())
 *                         .build())
 *                     .scopes(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs.builder()
 *                         .protocols(6)
 *                         .destinationPorts(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs.builder()
 *                             .fromPort(443)
 *                             .toPort(443)
 *                             .build())
 *                         .destinations(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgs.builder()
 *                             .addressDefinition("0.0.0.0/0")
 *                             .build())
 *                         .sourcePorts(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgs.builder()
 *                             .fromPort(0)
 *                             .toPort(65535)
 *                             .build())
 *                         .sources(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs.builder()
 *                             .addressDefinition("0.0.0.0/0")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkfirewall:TlsInspectionConfiguration
 *     properties:
 *       name: example
 *       description: example
 *       encryptionConfigurations:
 *         - keyId: AWS_OWNED_KMS_KEY
 *           type: AWS_OWNED_KMS_KEY
 *       tlsInspectionConfiguration:
 *         serverCertificateConfiguration:
 *           certificateAuthorityArn: ${example1.arn}
 *           checkCertificateRevocationStatus:
 *             revokedStatusAction: REJECT
 *             unknownStatusAction: PASS
 *           serverCertificates:
 *             - resourceArn: ${example2.arn}
 *           scopes:
 *             - protocols:
 *                 - 6
 *               destinationPorts:
 *                 - fromPort: 443
 *                   toPort: 443
 *               destinations:
 *                 - addressDefinition: 0.0.0.0/0
 *               sourcePorts:
 *                 - fromPort: 0
 *                   toPort: 65535
 *               sources:
 *                 - addressDefinition: 0.0.0.0/0
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Network Firewall TLS Inspection Configuration using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:networkfirewall/tlsInspectionConfiguration:TlsInspectionConfiguration example arn:aws:network-firewall::<region>:<account_id>:tls-configuration/example
 * ```
 */
public class TlsInspectionConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.networkfirewall.TlsInspectionConfiguration,
) : KotlinCustomResource(javaResource, TlsInspectionConfigurationMapper) {
    /**
     * ARN of the TLS Inspection Configuration.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Certificate Manager certificate block. See Certificate Authority below for details.
     */
    public val certificateAuthorities: Output<List<TlsInspectionConfigurationCertificateAuthority>>
        get() = javaResource.certificateAuthorities().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> tlsInspectionConfigurationCertificateAuthorityToKotlin(args0) })
            })
        })

    /**
     * List of certificate blocks describing certificates associated with the TLS inspection configuration. See Certificates below for details.
     */
    public val certificates: Output<List<TlsInspectionConfigurationCertificate>>
        get() = javaResource.certificates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    tlsInspectionConfigurationCertificateToKotlin(args0)
                })
            })
        })

    /**
     * Description of the TLS inspection configuration.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Encryption configuration block. Detailed below.
     */
    public val encryptionConfigurations:
        Output<List<TlsInspectionConfigurationEncryptionConfiguration>>
        get() = javaResource.encryptionConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> tlsInspectionConfigurationEncryptionConfigurationToKotlin(args0) })
            })
        })

    /**
     * Descriptive name of the TLS inspection configuration.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Number of firewall policies that use this TLS inspection configuration.
     */
    public val numberOfAssociations: Output<Int>
        get() = javaResource.numberOfAssociations().applyValue({ args0 -> args0 })

    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val timeouts: Output<TlsInspectionConfigurationTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    tlsInspectionConfigurationTimeoutsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * TLS inspection configuration block. Detailed below.
     * The following arguments are optional:
     */
    public val tlsInspectionConfiguration:
        Output<TlsInspectionConfigurationTlsInspectionConfiguration>?
        get() = javaResource.tlsInspectionConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    tlsInspectionConfigurationTlsInspectionConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * A unique identifier for the TLS inspection configuration.
     */
    public val tlsInspectionConfigurationId: Output<String>
        get() = javaResource.tlsInspectionConfigurationId().applyValue({ args0 -> args0 })

    /**
     * String token used when updating the rule group.
     */
    public val updateToken: Output<String>
        get() = javaResource.updateToken().applyValue({ args0 -> args0 })
}

public object TlsInspectionConfigurationMapper : ResourceMapper<TlsInspectionConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.networkfirewall.TlsInspectionConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): TlsInspectionConfiguration =
        TlsInspectionConfiguration(
            javaResource as
                com.pulumi.aws.networkfirewall.TlsInspectionConfiguration,
        )
}

/**
 * @see [TlsInspectionConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TlsInspectionConfiguration].
 */
public suspend fun tlsInspectionConfiguration(
    name: String,
    block: suspend TlsInspectionConfigurationResourceBuilder.() -> Unit,
): TlsInspectionConfiguration {
    val builder = TlsInspectionConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TlsInspectionConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun tlsInspectionConfiguration(name: String): TlsInspectionConfiguration {
    val builder = TlsInspectionConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
