@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin

import com.pulumi.aws.networkfirewall.TlsInspectionConfigurationArgs.builder
import com.pulumi.aws.networkfirewall.kotlin.inputs.TlsInspectionConfigurationEncryptionConfigurationArgs
import com.pulumi.aws.networkfirewall.kotlin.inputs.TlsInspectionConfigurationEncryptionConfigurationArgsBuilder
import com.pulumi.aws.networkfirewall.kotlin.inputs.TlsInspectionConfigurationTimeoutsArgs
import com.pulumi.aws.networkfirewall.kotlin.inputs.TlsInspectionConfigurationTimeoutsArgsBuilder
import com.pulumi.aws.networkfirewall.kotlin.inputs.TlsInspectionConfigurationTlsInspectionConfigurationArgs
import com.pulumi.aws.networkfirewall.kotlin.inputs.TlsInspectionConfigurationTlsInspectionConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Network Firewall TLS Inspection Configuration.
 * ## Example Usage
 * > **NOTE:** You must configure either inbound inspection, outbound inspection, or both.
 * ### Basic inbound/ingress inspection
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkfirewall.TlsInspectionConfiguration("example", {
 *     name: "example",
 *     description: "example",
 *     encryptionConfigurations: [{
 *         keyId: "AWS_OWNED_KMS_KEY",
 *         type: "AWS_OWNED_KMS_KEY",
 *     }],
 *     tlsInspectionConfiguration: {
 *         serverCertificateConfiguration: {
 *             serverCertificates: [{
 *                 resourceArn: example1.arn,
 *             }],
 *             scopes: [{
 *                 protocols: [6],
 *                 destinationPorts: [{
 *                     fromPort: 443,
 *                     toPort: 443,
 *                 }],
 *                 destinations: [{
 *                     addressDefinition: "0.0.0.0/0",
 *                 }],
 *                 sourcePorts: [{
 *                     fromPort: 0,
 *                     toPort: 65535,
 *                 }],
 *                 sources: [{
 *                     addressDefinition: "0.0.0.0/0",
 *                 }],
 *             }],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkfirewall.TlsInspectionConfiguration("example",
 *     name="example",
 *     description="example",
 *     encryption_configurations=[{
 *         "key_id": "AWS_OWNED_KMS_KEY",
 *         "type": "AWS_OWNED_KMS_KEY",
 *     }],
 *     tls_inspection_configuration={
 *         "server_certificate_configuration": {
 *             "server_certificates": [{
 *                 "resource_arn": example1["arn"],
 *             }],
 *             "scopes": [{
 *                 "protocols": [6],
 *                 "destination_ports": [{
 *                     "from_port": 443,
 *                     "to_port": 443,
 *                 }],
 *                 "destinations": [{
 *                     "address_definition": "0.0.0.0/0",
 *                 }],
 *                 "source_ports": [{
 *                     "from_port": 0,
 *                     "to_port": 65535,
 *                 }],
 *                 "sources": [{
 *                     "address_definition": "0.0.0.0/0",
 *                 }],
 *             }],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkFirewall.TlsInspectionConfiguration("example", new()
 *     {
 *         Name = "example",
 *         Description = "example",
 *         EncryptionConfigurations = new[]
 *         {
 *             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationEncryptionConfigurationArgs
 *             {
 *                 KeyId = "AWS_OWNED_KMS_KEY",
 *                 Type = "AWS_OWNED_KMS_KEY",
 *             },
 *         },
 *         TlsInspectionConfig = new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationArgs
 *         {
 *             ServerCertificateConfiguration = new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs
 *             {
 *                 ServerCertificates = new[]
 *                 {
 *                     new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgs
 *                     {
 *                         ResourceArn = example1.Arn,
 *                     },
 *                 },
 *                 Scopes = new[]
 *                 {
 *                     new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs
 *                     {
 *                         Protocols = new[]
 *                         {
 *                             6,
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs
 *                             {
 *                                 FromPort = 443,
 *                                 ToPort = 443,
 *                             },
 *                         },
 *                         Destinations = new[]
 *                         {
 *                             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgs
 *                             {
 *                                 AddressDefinition = "0.0.0.0/0",
 *                             },
 *                         },
 *                         SourcePorts = new[]
 *                         {
 *                             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgs
 *                             {
 *                                 FromPort = 0,
 *                                 ToPort = 65535,
 *                             },
 *                         },
 *                         Sources = new[]
 *                         {
 *                             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs
 *                             {
 *                                 AddressDefinition = "0.0.0.0/0",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkfirewall.NewTlsInspectionConfiguration(ctx, "example", &networkfirewall.TlsInspectionConfigurationArgs{
 * 			Name:        pulumi.String("example"),
 * 			Description: pulumi.String("example"),
 * 			EncryptionConfigurations: networkfirewall.TlsInspectionConfigurationEncryptionConfigurationArray{
 * 				&networkfirewall.TlsInspectionConfigurationEncryptionConfigurationArgs{
 * 					KeyId: pulumi.String("AWS_OWNED_KMS_KEY"),
 * 					Type:  pulumi.String("AWS_OWNED_KMS_KEY"),
 * 				},
 * 			},
 * 			TlsInspectionConfiguration: &networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationArgs{
 * 				ServerCertificateConfiguration: &networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs{
 * 					ServerCertificates: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArray{
 * 						&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgs{
 * 							ResourceArn: pulumi.Any(example1.Arn),
 * 						},
 * 					},
 * 					Scopes: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArray{
 * 						&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs{
 * 							Protocols: pulumi.IntArray{
 * 								pulumi.Int(6),
 * 							},
 * 							DestinationPorts: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArray{
 * 								&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs{
 * 									FromPort: pulumi.Int(443),
 * 									ToPort:   pulumi.Int(443),
 * 								},
 * 							},
 * 							Destinations: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArray{
 * 								&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgs{
 * 									AddressDefinition: pulumi.String("0.0.0.0/0"),
 * 								},
 * 							},
 * 							SourcePorts: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArray{
 * 								&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgs{
 * 									FromPort: pulumi.Int(0),
 * 									ToPort:   pulumi.Int(65535),
 * 								},
 * 							},
 * 							Sources: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArray{
 * 								&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs{
 * 									AddressDefinition: pulumi.String("0.0.0.0/0"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.TlsInspectionConfiguration;
 * import com.pulumi.aws.networkfirewall.TlsInspectionConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationEncryptionConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TlsInspectionConfiguration("example", TlsInspectionConfigurationArgs.builder()
 *             .name("example")
 *             .description("example")
 *             .encryptionConfigurations(TlsInspectionConfigurationEncryptionConfigurationArgs.builder()
 *                 .keyId("AWS_OWNED_KMS_KEY")
 *                 .type("AWS_OWNED_KMS_KEY")
 *                 .build())
 *             .tlsInspectionConfiguration(TlsInspectionConfigurationTlsInspectionConfigurationArgs.builder()
 *                 .serverCertificateConfiguration(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs.builder()
 *                     .serverCertificates(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgs.builder()
 *                         .resourceArn(example1.arn())
 *                         .build())
 *                     .scopes(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs.builder()
 *                         .protocols(6)
 *                         .destinationPorts(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs.builder()
 *                             .fromPort(443)
 *                             .toPort(443)
 *                             .build())
 *                         .destinations(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgs.builder()
 *                             .addressDefinition("0.0.0.0/0")
 *                             .build())
 *                         .sourcePorts(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgs.builder()
 *                             .fromPort(0)
 *                             .toPort(65535)
 *                             .build())
 *                         .sources(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs.builder()
 *                             .addressDefinition("0.0.0.0/0")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkfirewall:TlsInspectionConfiguration
 *     properties:
 *       name: example
 *       description: example
 *       encryptionConfigurations:
 *         - keyId: AWS_OWNED_KMS_KEY
 *           type: AWS_OWNED_KMS_KEY
 *       tlsInspectionConfiguration:
 *         serverCertificateConfiguration:
 *           serverCertificates:
 *             - resourceArn: ${example1.arn}
 *           scopes:
 *             - protocols:
 *                 - 6
 *               destinationPorts:
 *                 - fromPort: 443
 *                   toPort: 443
 *               destinations:
 *                 - addressDefinition: 0.0.0.0/0
 *               sourcePorts:
 *                 - fromPort: 0
 *                   toPort: 65535
 *               sources:
 *                 - addressDefinition: 0.0.0.0/0
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Basic outbound/engress inspection
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkfirewall.TlsInspectionConfiguration("example", {
 *     name: "example",
 *     description: "example",
 *     encryptionConfigurations: [{
 *         keyId: "AWS_OWNED_KMS_KEY",
 *         type: "AWS_OWNED_KMS_KEY",
 *     }],
 *     tlsInspectionConfiguration: {
 *         serverCertificateConfiguration: {
 *             certificateAuthorityArn: example1.arn,
 *             checkCertificateRevocationStatus: {
 *                 revokedStatusAction: "REJECT",
 *                 unknownStatusAction: "PASS",
 *             },
 *             scopes: [{
 *                 protocols: [6],
 *                 destinationPorts: [{
 *                     fromPort: 443,
 *                     toPort: 443,
 *                 }],
 *                 destinations: [{
 *                     addressDefinition: "0.0.0.0/0",
 *                 }],
 *                 sourcePorts: [{
 *                     fromPort: 0,
 *                     toPort: 65535,
 *                 }],
 *                 sources: [{
 *                     addressDefinition: "0.0.0.0/0",
 *                 }],
 *             }],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkfirewall.TlsInspectionConfiguration("example",
 *     name="example",
 *     description="example",
 *     encryption_configurations=[{
 *         "key_id": "AWS_OWNED_KMS_KEY",
 *         "type": "AWS_OWNED_KMS_KEY",
 *     }],
 *     tls_inspection_configuration={
 *         "server_certificate_configuration": {
 *             "certificate_authority_arn": example1["arn"],
 *             "check_certificate_revocation_status": {
 *                 "revoked_status_action": "REJECT",
 *                 "unknown_status_action": "PASS",
 *             },
 *             "scopes": [{
 *                 "protocols": [6],
 *                 "destination_ports": [{
 *                     "from_port": 443,
 *                     "to_port": 443,
 *                 }],
 *                 "destinations": [{
 *                     "address_definition": "0.0.0.0/0",
 *                 }],
 *                 "source_ports": [{
 *                     "from_port": 0,
 *                     "to_port": 65535,
 *                 }],
 *                 "sources": [{
 *                     "address_definition": "0.0.0.0/0",
 *                 }],
 *             }],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkFirewall.TlsInspectionConfiguration("example", new()
 *     {
 *         Name = "example",
 *         Description = "example",
 *         EncryptionConfigurations = new[]
 *         {
 *             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationEncryptionConfigurationArgs
 *             {
 *                 KeyId = "AWS_OWNED_KMS_KEY",
 *                 Type = "AWS_OWNED_KMS_KEY",
 *             },
 *         },
 *         TlsInspectionConfig = new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationArgs
 *         {
 *             ServerCertificateConfiguration = new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs
 *             {
 *                 CertificateAuthorityArn = example1.Arn,
 *                 CheckCertificateRevocationStatus = new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationCheckCertificateRevocationStatusArgs
 *                 {
 *                     RevokedStatusAction = "REJECT",
 *                     UnknownStatusAction = "PASS",
 *                 },
 *                 Scopes = new[]
 *                 {
 *                     new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs
 *                     {
 *                         Protocols = new[]
 *                         {
 *                             6,
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs
 *                             {
 *                                 FromPort = 443,
 *                                 ToPort = 443,
 *                             },
 *                         },
 *                         Destinations = new[]
 *                         {
 *                             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgs
 *                             {
 *                                 AddressDefinition = "0.0.0.0/0",
 *                             },
 *                         },
 *                         SourcePorts = new[]
 *                         {
 *                             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgs
 *                             {
 *                                 FromPort = 0,
 *                                 ToPort = 65535,
 *                             },
 *                         },
 *                         Sources = new[]
 *                         {
 *                             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs
 *                             {
 *                                 AddressDefinition = "0.0.0.0/0",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkfirewall.NewTlsInspectionConfiguration(ctx, "example", &networkfirewall.TlsInspectionConfigurationArgs{
 * 			Name:        pulumi.String("example"),
 * 			Description: pulumi.String("example"),
 * 			EncryptionConfigurations: networkfirewall.TlsInspectionConfigurationEncryptionConfigurationArray{
 * 				&networkfirewall.TlsInspectionConfigurationEncryptionConfigurationArgs{
 * 					KeyId: pulumi.String("AWS_OWNED_KMS_KEY"),
 * 					Type:  pulumi.String("AWS_OWNED_KMS_KEY"),
 * 				},
 * 			},
 * 			TlsInspectionConfiguration: &networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationArgs{
 * 				ServerCertificateConfiguration: &networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs{
 * 					CertificateAuthorityArn: pulumi.Any(example1.Arn),
 * 					CheckCertificateRevocationStatus: &networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationCheckCertificateRevocationStatusArgs{
 * 						RevokedStatusAction: pulumi.String("REJECT"),
 * 						UnknownStatusAction: pulumi.String("PASS"),
 * 					},
 * 					Scopes: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArray{
 * 						&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs{
 * 							Protocols: pulumi.IntArray{
 * 								pulumi.Int(6),
 * 							},
 * 							DestinationPorts: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArray{
 * 								&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs{
 * 									FromPort: pulumi.Int(443),
 * 									ToPort:   pulumi.Int(443),
 * 								},
 * 							},
 * 							Destinations: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArray{
 * 								&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgs{
 * 									AddressDefinition: pulumi.String("0.0.0.0/0"),
 * 								},
 * 							},
 * 							SourcePorts: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArray{
 * 								&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgs{
 * 									FromPort: pulumi.Int(0),
 * 									ToPort:   pulumi.Int(65535),
 * 								},
 * 							},
 * 							Sources: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArray{
 * 								&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs{
 * 									AddressDefinition: pulumi.String("0.0.0.0/0"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.TlsInspectionConfiguration;
 * import com.pulumi.aws.networkfirewall.TlsInspectionConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationEncryptionConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationCheckCertificateRevocationStatusArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TlsInspectionConfiguration("example", TlsInspectionConfigurationArgs.builder()
 *             .name("example")
 *             .description("example")
 *             .encryptionConfigurations(TlsInspectionConfigurationEncryptionConfigurationArgs.builder()
 *                 .keyId("AWS_OWNED_KMS_KEY")
 *                 .type("AWS_OWNED_KMS_KEY")
 *                 .build())
 *             .tlsInspectionConfiguration(TlsInspectionConfigurationTlsInspectionConfigurationArgs.builder()
 *                 .serverCertificateConfiguration(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs.builder()
 *                     .certificateAuthorityArn(example1.arn())
 *                     .checkCertificateRevocationStatus(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationCheckCertificateRevocationStatusArgs.builder()
 *                         .revokedStatusAction("REJECT")
 *                         .unknownStatusAction("PASS")
 *                         .build())
 *                     .scopes(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs.builder()
 *                         .protocols(6)
 *                         .destinationPorts(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs.builder()
 *                             .fromPort(443)
 *                             .toPort(443)
 *                             .build())
 *                         .destinations(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgs.builder()
 *                             .addressDefinition("0.0.0.0/0")
 *                             .build())
 *                         .sourcePorts(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgs.builder()
 *                             .fromPort(0)
 *                             .toPort(65535)
 *                             .build())
 *                         .sources(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs.builder()
 *                             .addressDefinition("0.0.0.0/0")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkfirewall:TlsInspectionConfiguration
 *     properties:
 *       name: example
 *       description: example
 *       encryptionConfigurations:
 *         - keyId: AWS_OWNED_KMS_KEY
 *           type: AWS_OWNED_KMS_KEY
 *       tlsInspectionConfiguration:
 *         serverCertificateConfiguration:
 *           certificateAuthorityArn: ${example1.arn}
 *           checkCertificateRevocationStatus:
 *             revokedStatusAction: REJECT
 *             unknownStatusAction: PASS
 *           scopes:
 *             - protocols:
 *                 - 6
 *               destinationPorts:
 *                 - fromPort: 443
 *                   toPort: 443
 *               destinations:
 *                 - addressDefinition: 0.0.0.0/0
 *               sourcePorts:
 *                 - fromPort: 0
 *                   toPort: 65535
 *               sources:
 *                 - addressDefinition: 0.0.0.0/0
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Inbound with encryption configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.kms.Key("example", {
 *     description: "example",
 *     deletionWindowInDays: 7,
 * });
 * const exampleTlsInspectionConfiguration = new aws.networkfirewall.TlsInspectionConfiguration("example", {
 *     name: "example",
 *     description: "example",
 *     encryptionConfigurations: [{
 *         keyId: example.arn,
 *         type: "CUSTOMER_KMS",
 *     }],
 *     tlsInspectionConfiguration: {
 *         serverCertificateConfiguration: {
 *             serverCertificates: [{
 *                 resourceArn: example1.arn,
 *             }],
 *             scopes: [{
 *                 protocols: [6],
 *                 destinationPorts: [{
 *                     fromPort: 443,
 *                     toPort: 443,
 *                 }],
 *                 destinations: [{
 *                     addressDefinition: "0.0.0.0/0",
 *                 }],
 *                 sourcePorts: [{
 *                     fromPort: 0,
 *                     toPort: 65535,
 *                 }],
 *                 sources: [{
 *                     addressDefinition: "0.0.0.0/0",
 *                 }],
 *             }],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.kms.Key("example",
 *     description="example",
 *     deletion_window_in_days=7)
 * example_tls_inspection_configuration = aws.networkfirewall.TlsInspectionConfiguration("example",
 *     name="example",
 *     description="example",
 *     encryption_configurations=[{
 *         "key_id": example.arn,
 *         "type": "CUSTOMER_KMS",
 *     }],
 *     tls_inspection_configuration={
 *         "server_certificate_configuration": {
 *             "server_certificates": [{
 *                 "resource_arn": example1["arn"],
 *             }],
 *             "scopes": [{
 *                 "protocols": [6],
 *                 "destination_ports": [{
 *                     "from_port": 443,
 *                     "to_port": 443,
 *                 }],
 *                 "destinations": [{
 *                     "address_definition": "0.0.0.0/0",
 *                 }],
 *                 "source_ports": [{
 *                     "from_port": 0,
 *                     "to_port": 65535,
 *                 }],
 *                 "sources": [{
 *                     "address_definition": "0.0.0.0/0",
 *                 }],
 *             }],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Kms.Key("example", new()
 *     {
 *         Description = "example",
 *         DeletionWindowInDays = 7,
 *     });
 *     var exampleTlsInspectionConfiguration = new Aws.NetworkFirewall.TlsInspectionConfiguration("example", new()
 *     {
 *         Name = "example",
 *         Description = "example",
 *         EncryptionConfigurations = new[]
 *         {
 *             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationEncryptionConfigurationArgs
 *             {
 *                 KeyId = example.Arn,
 *                 Type = "CUSTOMER_KMS",
 *             },
 *         },
 *         TlsInspectionConfig = new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationArgs
 *         {
 *             ServerCertificateConfiguration = new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs
 *             {
 *                 ServerCertificates = new[]
 *                 {
 *                     new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgs
 *                     {
 *                         ResourceArn = example1.Arn,
 *                     },
 *                 },
 *                 Scopes = new[]
 *                 {
 *                     new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs
 *                     {
 *                         Protocols = new[]
 *                         {
 *                             6,
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs
 *                             {
 *                                 FromPort = 443,
 *                                 ToPort = 443,
 *                             },
 *                         },
 *                         Destinations = new[]
 *                         {
 *                             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgs
 *                             {
 *                                 AddressDefinition = "0.0.0.0/0",
 *                             },
 *                         },
 *                         SourcePorts = new[]
 *                         {
 *                             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgs
 *                             {
 *                                 FromPort = 0,
 *                                 ToPort = 65535,
 *                             },
 *                         },
 *                         Sources = new[]
 *                         {
 *                             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs
 *                             {
 *                                 AddressDefinition = "0.0.0.0/0",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := kms.NewKey(ctx, "example", &kms.KeyArgs{
 * 			Description:          pulumi.String("example"),
 * 			DeletionWindowInDays: pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = networkfirewall.NewTlsInspectionConfiguration(ctx, "example", &networkfirewall.TlsInspectionConfigurationArgs{
 * 			Name:        pulumi.String("example"),
 * 			Description: pulumi.String("example"),
 * 			EncryptionConfigurations: networkfirewall.TlsInspectionConfigurationEncryptionConfigurationArray{
 * 				&networkfirewall.TlsInspectionConfigurationEncryptionConfigurationArgs{
 * 					KeyId: example.Arn,
 * 					Type:  pulumi.String("CUSTOMER_KMS"),
 * 				},
 * 			},
 * 			TlsInspectionConfiguration: &networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationArgs{
 * 				ServerCertificateConfiguration: &networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs{
 * 					ServerCertificates: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArray{
 * 						&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgs{
 * 							ResourceArn: pulumi.Any(example1.Arn),
 * 						},
 * 					},
 * 					Scopes: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArray{
 * 						&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs{
 * 							Protocols: pulumi.IntArray{
 * 								pulumi.Int(6),
 * 							},
 * 							DestinationPorts: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArray{
 * 								&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs{
 * 									FromPort: pulumi.Int(443),
 * 									ToPort:   pulumi.Int(443),
 * 								},
 * 							},
 * 							Destinations: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArray{
 * 								&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgs{
 * 									AddressDefinition: pulumi.String("0.0.0.0/0"),
 * 								},
 * 							},
 * 							SourcePorts: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArray{
 * 								&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgs{
 * 									FromPort: pulumi.Int(0),
 * 									ToPort:   pulumi.Int(65535),
 * 								},
 * 							},
 * 							Sources: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArray{
 * 								&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs{
 * 									AddressDefinition: pulumi.String("0.0.0.0/0"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.networkfirewall.TlsInspectionConfiguration;
 * import com.pulumi.aws.networkfirewall.TlsInspectionConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationEncryptionConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Key("example", KeyArgs.builder()
 *             .description("example")
 *             .deletionWindowInDays(7)
 *             .build());
 *         var exampleTlsInspectionConfiguration = new TlsInspectionConfiguration("exampleTlsInspectionConfiguration", TlsInspectionConfigurationArgs.builder()
 *             .name("example")
 *             .description("example")
 *             .encryptionConfigurations(TlsInspectionConfigurationEncryptionConfigurationArgs.builder()
 *                 .keyId(example.arn())
 *                 .type("CUSTOMER_KMS")
 *                 .build())
 *             .tlsInspectionConfiguration(TlsInspectionConfigurationTlsInspectionConfigurationArgs.builder()
 *                 .serverCertificateConfiguration(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs.builder()
 *                     .serverCertificates(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgs.builder()
 *                         .resourceArn(example1.arn())
 *                         .build())
 *                     .scopes(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs.builder()
 *                         .protocols(6)
 *                         .destinationPorts(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs.builder()
 *                             .fromPort(443)
 *                             .toPort(443)
 *                             .build())
 *                         .destinations(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgs.builder()
 *                             .addressDefinition("0.0.0.0/0")
 *                             .build())
 *                         .sourcePorts(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgs.builder()
 *                             .fromPort(0)
 *                             .toPort(65535)
 *                             .build())
 *                         .sources(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs.builder()
 *                             .addressDefinition("0.0.0.0/0")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kms:Key
 *     properties:
 *       description: example
 *       deletionWindowInDays: 7
 *   exampleTlsInspectionConfiguration:
 *     type: aws:networkfirewall:TlsInspectionConfiguration
 *     name: example
 *     properties:
 *       name: example
 *       description: example
 *       encryptionConfigurations:
 *         - keyId: ${example.arn}
 *           type: CUSTOMER_KMS
 *       tlsInspectionConfiguration:
 *         serverCertificateConfiguration:
 *           serverCertificates:
 *             - resourceArn: ${example1.arn}
 *           scopes:
 *             - protocols:
 *                 - 6
 *               destinationPorts:
 *                 - fromPort: 443
 *                   toPort: 443
 *               destinations:
 *                 - addressDefinition: 0.0.0.0/0
 *               sourcePorts:
 *                 - fromPort: 0
 *                   toPort: 65535
 *               sources:
 *                 - addressDefinition: 0.0.0.0/0
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Outbound with encryption configuration
 * <!--Start PulumiCodeChooser -->
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.networkfirewall.TlsInspectionConfiguration;
 * import com.pulumi.aws.networkfirewall.TlsInspectionConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationEncryptionConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Key("example", KeyArgs.builder()
 *             .description("example")
 *             .deletionWindowInDays(7)
 *             .build());
 *         var exampleTlsInspectionConfiguration = new TlsInspectionConfiguration("exampleTlsInspectionConfiguration", TlsInspectionConfigurationArgs.builder()
 *             .name("example")
 *             .description("example")
 *             .encryptionConfigurations(TlsInspectionConfigurationEncryptionConfigurationArgs.builder()
 *                 .keyId(example.arn())
 *                 .type("CUSTOMER_KMS")
 *                 .build())
 *             .tlsInspectionConfiguration(TlsInspectionConfigurationTlsInspectionConfigurationArgs.builder()
 *                 .serverCertificateConfigurations(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kms:Key
 *     properties:
 *       description: example
 *       deletionWindowInDays: 7
 *   exampleTlsInspectionConfiguration:
 *     type: aws:networkfirewall:TlsInspectionConfiguration
 *     name: example
 *     properties:
 *       name: example
 *       description: example
 *       encryptionConfigurations:
 *         - keyId: ${example.arn}
 *           type: CUSTOMER_KMS
 *       tlsInspectionConfiguration:
 *         serverCertificateConfigurations:
 *           - certificateAuthorityArn: ${example1.arn}
 *             checkCertificateRevocationStatus:
 *               - revokedStatusAction: REJECT
 *                 unknownStatusAction: PASS
 *             scope:
 *               - protocols:
 *                   - 6
 *                 destinationPorts:
 *                   - fromPort: 443
 *                     toPort: 443
 *                 destination:
 *                   - addressDefinition: 0.0.0.0/0
 *                 sourcePorts:
 *                   - fromPort: 0
 *                     toPort: 65535
 *                 source:
 *                   - addressDefinition: 0.0.0.0/0
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Combined inbound and outbound
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkfirewall.TlsInspectionConfiguration("example", {
 *     name: "example",
 *     description: "example",
 *     encryptionConfigurations: [{
 *         keyId: "AWS_OWNED_KMS_KEY",
 *         type: "AWS_OWNED_KMS_KEY",
 *     }],
 *     tlsInspectionConfiguration: {
 *         serverCertificateConfiguration: {
 *             certificateAuthorityArn: example1.arn,
 *             checkCertificateRevocationStatus: {
 *                 revokedStatusAction: "REJECT",
 *                 unknownStatusAction: "PASS",
 *             },
 *             serverCertificates: [{
 *                 resourceArn: example2.arn,
 *             }],
 *             scopes: [{
 *                 protocols: [6],
 *                 destinationPorts: [{
 *                     fromPort: 443,
 *                     toPort: 443,
 *                 }],
 *                 destinations: [{
 *                     addressDefinition: "0.0.0.0/0",
 *                 }],
 *                 sourcePorts: [{
 *                     fromPort: 0,
 *                     toPort: 65535,
 *                 }],
 *                 sources: [{
 *                     addressDefinition: "0.0.0.0/0",
 *                 }],
 *             }],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkfirewall.TlsInspectionConfiguration("example",
 *     name="example",
 *     description="example",
 *     encryption_configurations=[{
 *         "key_id": "AWS_OWNED_KMS_KEY",
 *         "type": "AWS_OWNED_KMS_KEY",
 *     }],
 *     tls_inspection_configuration={
 *         "server_certificate_configuration": {
 *             "certificate_authority_arn": example1["arn"],
 *             "check_certificate_revocation_status": {
 *                 "revoked_status_action": "REJECT",
 *                 "unknown_status_action": "PASS",
 *             },
 *             "server_certificates": [{
 *                 "resource_arn": example2["arn"],
 *             }],
 *             "scopes": [{
 *                 "protocols": [6],
 *                 "destination_ports": [{
 *                     "from_port": 443,
 *                     "to_port": 443,
 *                 }],
 *                 "destinations": [{
 *                     "address_definition": "0.0.0.0/0",
 *                 }],
 *                 "source_ports": [{
 *                     "from_port": 0,
 *                     "to_port": 65535,
 *                 }],
 *                 "sources": [{
 *                     "address_definition": "0.0.0.0/0",
 *                 }],
 *             }],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkFirewall.TlsInspectionConfiguration("example", new()
 *     {
 *         Name = "example",
 *         Description = "example",
 *         EncryptionConfigurations = new[]
 *         {
 *             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationEncryptionConfigurationArgs
 *             {
 *                 KeyId = "AWS_OWNED_KMS_KEY",
 *                 Type = "AWS_OWNED_KMS_KEY",
 *             },
 *         },
 *         TlsInspectionConfig = new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationArgs
 *         {
 *             ServerCertificateConfiguration = new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs
 *             {
 *                 CertificateAuthorityArn = example1.Arn,
 *                 CheckCertificateRevocationStatus = new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationCheckCertificateRevocationStatusArgs
 *                 {
 *                     RevokedStatusAction = "REJECT",
 *                     UnknownStatusAction = "PASS",
 *                 },
 *                 ServerCertificates = new[]
 *                 {
 *                     new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgs
 *                     {
 *                         ResourceArn = example2.Arn,
 *                     },
 *                 },
 *                 Scopes = new[]
 *                 {
 *                     new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs
 *                     {
 *                         Protocols = new[]
 *                         {
 *                             6,
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs
 *                             {
 *                                 FromPort = 443,
 *                                 ToPort = 443,
 *                             },
 *                         },
 *                         Destinations = new[]
 *                         {
 *                             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgs
 *                             {
 *                                 AddressDefinition = "0.0.0.0/0",
 *                             },
 *                         },
 *                         SourcePorts = new[]
 *                         {
 *                             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgs
 *                             {
 *                                 FromPort = 0,
 *                                 ToPort = 65535,
 *                             },
 *                         },
 *                         Sources = new[]
 *                         {
 *                             new Aws.NetworkFirewall.Inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs
 *                             {
 *                                 AddressDefinition = "0.0.0.0/0",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkfirewall"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkfirewall.NewTlsInspectionConfiguration(ctx, "example", &networkfirewall.TlsInspectionConfigurationArgs{
 * 			Name:        pulumi.String("example"),
 * 			Description: pulumi.String("example"),
 * 			EncryptionConfigurations: networkfirewall.TlsInspectionConfigurationEncryptionConfigurationArray{
 * 				&networkfirewall.TlsInspectionConfigurationEncryptionConfigurationArgs{
 * 					KeyId: pulumi.String("AWS_OWNED_KMS_KEY"),
 * 					Type:  pulumi.String("AWS_OWNED_KMS_KEY"),
 * 				},
 * 			},
 * 			TlsInspectionConfiguration: &networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationArgs{
 * 				ServerCertificateConfiguration: &networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs{
 * 					CertificateAuthorityArn: pulumi.Any(example1.Arn),
 * 					CheckCertificateRevocationStatus: &networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationCheckCertificateRevocationStatusArgs{
 * 						RevokedStatusAction: pulumi.String("REJECT"),
 * 						UnknownStatusAction: pulumi.String("PASS"),
 * 					},
 * 					ServerCertificates: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArray{
 * 						&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgs{
 * 							ResourceArn: pulumi.Any(example2.Arn),
 * 						},
 * 					},
 * 					Scopes: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArray{
 * 						&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs{
 * 							Protocols: pulumi.IntArray{
 * 								pulumi.Int(6),
 * 							},
 * 							DestinationPorts: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArray{
 * 								&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs{
 * 									FromPort: pulumi.Int(443),
 * 									ToPort:   pulumi.Int(443),
 * 								},
 * 							},
 * 							Destinations: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArray{
 * 								&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgs{
 * 									AddressDefinition: pulumi.String("0.0.0.0/0"),
 * 								},
 * 							},
 * 							SourcePorts: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArray{
 * 								&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgs{
 * 									FromPort: pulumi.Int(0),
 * 									ToPort:   pulumi.Int(65535),
 * 								},
 * 							},
 * 							Sources: networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArray{
 * 								&networkfirewall.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs{
 * 									AddressDefinition: pulumi.String("0.0.0.0/0"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.TlsInspectionConfiguration;
 * import com.pulumi.aws.networkfirewall.TlsInspectionConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationEncryptionConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationCheckCertificateRevocationStatusArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TlsInspectionConfiguration("example", TlsInspectionConfigurationArgs.builder()
 *             .name("example")
 *             .description("example")
 *             .encryptionConfigurations(TlsInspectionConfigurationEncryptionConfigurationArgs.builder()
 *                 .keyId("AWS_OWNED_KMS_KEY")
 *                 .type("AWS_OWNED_KMS_KEY")
 *                 .build())
 *             .tlsInspectionConfiguration(TlsInspectionConfigurationTlsInspectionConfigurationArgs.builder()
 *                 .serverCertificateConfiguration(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs.builder()
 *                     .certificateAuthorityArn(example1.arn())
 *                     .checkCertificateRevocationStatus(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationCheckCertificateRevocationStatusArgs.builder()
 *                         .revokedStatusAction("REJECT")
 *                         .unknownStatusAction("PASS")
 *                         .build())
 *                     .serverCertificates(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgs.builder()
 *                         .resourceArn(example2.arn())
 *                         .build())
 *                     .scopes(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs.builder()
 *                         .protocols(6)
 *                         .destinationPorts(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs.builder()
 *                             .fromPort(443)
 *                             .toPort(443)
 *                             .build())
 *                         .destinations(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgs.builder()
 *                             .addressDefinition("0.0.0.0/0")
 *                             .build())
 *                         .sourcePorts(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgs.builder()
 *                             .fromPort(0)
 *                             .toPort(65535)
 *                             .build())
 *                         .sources(TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs.builder()
 *                             .addressDefinition("0.0.0.0/0")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkfirewall:TlsInspectionConfiguration
 *     properties:
 *       name: example
 *       description: example
 *       encryptionConfigurations:
 *         - keyId: AWS_OWNED_KMS_KEY
 *           type: AWS_OWNED_KMS_KEY
 *       tlsInspectionConfiguration:
 *         serverCertificateConfiguration:
 *           certificateAuthorityArn: ${example1.arn}
 *           checkCertificateRevocationStatus:
 *             revokedStatusAction: REJECT
 *             unknownStatusAction: PASS
 *           serverCertificates:
 *             - resourceArn: ${example2.arn}
 *           scopes:
 *             - protocols:
 *                 - 6
 *               destinationPorts:
 *                 - fromPort: 443
 *                   toPort: 443
 *               destinations:
 *                 - addressDefinition: 0.0.0.0/0
 *               sourcePorts:
 *                 - fromPort: 0
 *                   toPort: 65535
 *               sources:
 *                 - addressDefinition: 0.0.0.0/0
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Network Firewall TLS Inspection Configuration using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:networkfirewall/tlsInspectionConfiguration:TlsInspectionConfiguration example arn:aws:network-firewall::<region>:<account_id>:tls-configuration/example
 * ```
 * @property description Description of the TLS inspection configuration.
 * @property encryptionConfigurations Encryption configuration block. Detailed below.
 * @property name Descriptive name of the TLS inspection configuration.
 * @property tags
 * @property timeouts
 * @property tlsInspectionConfiguration TLS inspection configuration block. Detailed below.
 * The following arguments are optional:
 */
public data class TlsInspectionConfigurationArgs(
    public val description: Output<String>? = null,
    public val encryptionConfigurations: Output<List<TlsInspectionConfigurationEncryptionConfigurationArgs>>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeouts: Output<TlsInspectionConfigurationTimeoutsArgs>? = null,
    public val tlsInspectionConfiguration: Output<TlsInspectionConfigurationTlsInspectionConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkfirewall.TlsInspectionConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.networkfirewall.TlsInspectionConfigurationArgs =
        com.pulumi.aws.networkfirewall.TlsInspectionConfigurationArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptionConfigurations(
                encryptionConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tlsInspectionConfiguration(
                tlsInspectionConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [TlsInspectionConfigurationArgs].
 */
@PulumiTagMarker
public class TlsInspectionConfigurationArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var encryptionConfigurations:
        Output<List<TlsInspectionConfigurationEncryptionConfigurationArgs>>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeouts: Output<TlsInspectionConfigurationTimeoutsArgs>? = null

    private var tlsInspectionConfiguration:
        Output<TlsInspectionConfigurationTlsInspectionConfigurationArgs>? = null

    /**
     * @param value Description of the TLS inspection configuration.
     */
    @JvmName("mwrqsotuekryafxa")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Encryption configuration block. Detailed below.
     */
    @JvmName("piseqkgkstdlyewn")
    public suspend fun encryptionConfigurations(`value`: Output<List<TlsInspectionConfigurationEncryptionConfigurationArgs>>) {
        this.encryptionConfigurations = value
    }

    @JvmName("yxttxntumyflmtkc")
    public suspend fun encryptionConfigurations(vararg values: Output<TlsInspectionConfigurationEncryptionConfigurationArgs>) {
        this.encryptionConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Encryption configuration block. Detailed below.
     */
    @JvmName("vrrdpqefyndihyox")
    public suspend fun encryptionConfigurations(values: List<Output<TlsInspectionConfigurationEncryptionConfigurationArgs>>) {
        this.encryptionConfigurations = Output.all(values)
    }

    /**
     * @param value Descriptive name of the TLS inspection configuration.
     */
    @JvmName("lvsurvqoottxfjnm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("glrpjosuhxmpanro")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("ltvbvlvliajddfxk")
    public suspend fun timeouts(`value`: Output<TlsInspectionConfigurationTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value TLS inspection configuration block. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("flftlmkyegpjmtaj")
    public suspend fun tlsInspectionConfiguration(`value`: Output<TlsInspectionConfigurationTlsInspectionConfigurationArgs>) {
        this.tlsInspectionConfiguration = value
    }

    /**
     * @param value Description of the TLS inspection configuration.
     */
    @JvmName("fbkotoqxatvdhrnx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Encryption configuration block. Detailed below.
     */
    @JvmName("quhubdblavhnvsyp")
    public suspend fun encryptionConfigurations(`value`: List<TlsInspectionConfigurationEncryptionConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionConfigurations = mapped
    }

    /**
     * @param argument Encryption configuration block. Detailed below.
     */
    @JvmName("tpjkkjfhmheimiyj")
    public suspend fun encryptionConfigurations(argument: List<suspend TlsInspectionConfigurationEncryptionConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TlsInspectionConfigurationEncryptionConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.encryptionConfigurations = mapped
    }

    /**
     * @param argument Encryption configuration block. Detailed below.
     */
    @JvmName("bkryfdnpubjrgjcw")
    public suspend fun encryptionConfigurations(vararg argument: suspend TlsInspectionConfigurationEncryptionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TlsInspectionConfigurationEncryptionConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.encryptionConfigurations = mapped
    }

    /**
     * @param argument Encryption configuration block. Detailed below.
     */
    @JvmName("dxtaavbmwgfuccho")
    public suspend fun encryptionConfigurations(argument: suspend TlsInspectionConfigurationEncryptionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                TlsInspectionConfigurationEncryptionConfigurationArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.encryptionConfigurations = mapped
    }

    /**
     * @param values Encryption configuration block. Detailed below.
     */
    @JvmName("lywiexuvhgjlmcad")
    public suspend fun encryptionConfigurations(vararg values: TlsInspectionConfigurationEncryptionConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionConfigurations = mapped
    }

    /**
     * @param value Descriptive name of the TLS inspection configuration.
     */
    @JvmName("kkihxrknthwxpmvf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("wgpjthmsgajgptur")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("jtksxistoioqumdk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("odyrfgemqswnxqoo")
    public suspend fun timeouts(`value`: TlsInspectionConfigurationTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("vmjuawegflxhigbt")
    public suspend fun timeouts(argument: suspend TlsInspectionConfigurationTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = TlsInspectionConfigurationTimeoutsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    /**
     * @param value TLS inspection configuration block. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("vjfuwjuffwswosjf")
    public suspend fun tlsInspectionConfiguration(`value`: TlsInspectionConfigurationTlsInspectionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tlsInspectionConfiguration = mapped
    }

    /**
     * @param argument TLS inspection configuration block. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("jpxdlvtchtthgpnu")
    public suspend fun tlsInspectionConfiguration(argument: suspend TlsInspectionConfigurationTlsInspectionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = TlsInspectionConfigurationTlsInspectionConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.tlsInspectionConfiguration = mapped
    }

    internal fun build(): TlsInspectionConfigurationArgs = TlsInspectionConfigurationArgs(
        description = description,
        encryptionConfigurations = encryptionConfigurations,
        name = name,
        tags = tags,
        timeouts = timeouts,
        tlsInspectionConfiguration = tlsInspectionConfiguration,
    )
}
