@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.FirewallEncryptionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property keyId The ID of the customer managed key. You can use any of the [key identifiers](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id) that KMS supports, unless you're using a key that's managed by another account. If you're using a key managed by another account, then specify the key ARN.
 * @property type The type of AWS KMS key to use for encryption of your Network Firewall resources. Valid values are `CUSTOMER_KMS` and `AWS_OWNED_KMS_KEY`.
 */
public data class FirewallEncryptionConfigurationArgs(
    public val keyId: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.FirewallEncryptionConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.networkfirewall.inputs.FirewallEncryptionConfigurationArgs =
        com.pulumi.aws.networkfirewall.inputs.FirewallEncryptionConfigurationArgs.builder()
            .keyId(keyId?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirewallEncryptionConfigurationArgs].
 */
@PulumiTagMarker
public class FirewallEncryptionConfigurationArgsBuilder internal constructor() {
    private var keyId: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The ID of the customer managed key. You can use any of the [key identifiers](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id) that KMS supports, unless you're using a key that's managed by another account. If you're using a key managed by another account, then specify the key ARN.
     */
    @JvmName("tkvwltlpmpmmcswr")
    public suspend fun keyId(`value`: Output<String>) {
        this.keyId = value
    }

    /**
     * @param value The type of AWS KMS key to use for encryption of your Network Firewall resources. Valid values are `CUSTOMER_KMS` and `AWS_OWNED_KMS_KEY`.
     */
    @JvmName("ghchdrpjbtitpdcm")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The ID of the customer managed key. You can use any of the [key identifiers](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id) that KMS supports, unless you're using a key that's managed by another account. If you're using a key managed by another account, then specify the key ARN.
     */
    @JvmName("yyiyfngirrluqhex")
    public suspend fun keyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyId = mapped
    }

    /**
     * @param value The type of AWS KMS key to use for encryption of your Network Firewall resources. Valid values are `CUSTOMER_KMS` and `AWS_OWNED_KMS_KEY`.
     */
    @JvmName("oaxoyjuxqongoyuj")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): FirewallEncryptionConfigurationArgs = FirewallEncryptionConfigurationArgs(
        keyId = keyId,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
