@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property policyVariables . Contains variables that you can use to override default Suricata settings in your firewall policy. See Rule Variables for details.
 * @property statefulDefaultActions Set of actions to take on a packet if it does not match any stateful rules in the policy. This can only be specified if the policy has a `stateful_engine_options` block with a `rule_order` value of `STRICT_ORDER`. You can specify one of either or neither values of `aws:drop_strict` or `aws:drop_established`, as well as any combination of `aws:alert_strict` and `aws:alert_established`.
 * @property statefulEngineOptions A configuration block that defines options on how the policy handles stateful rules. See Stateful Engine Options below for details.
 * @property statefulRuleGroupReferences Set of configuration blocks containing references to the stateful rule groups that are used in the policy. See Stateful Rule Group Reference below for details.
 * @property statelessCustomActions Set of configuration blocks describing the custom action definitions that are available for use in the firewall policy's `stateless_default_actions`. See Stateless Custom Action below for details.
 * @property statelessDefaultActions Set of actions to take on a packet if it does not match any of the stateless rules in the policy. You must specify one of the standard actions including: `aws:drop`, `aws:pass`, or `aws:forward_to_sfe`.
 * In addition, you can specify custom actions that are compatible with your standard action choice. If you want non-matching packets to be forwarded for stateful inspection, specify `aws:forward_to_sfe`.
 * @property statelessFragmentDefaultActions Set of actions to take on a fragmented packet if it does not match any of the stateless rules in the policy. You must specify one of the standard actions including: `aws:drop`, `aws:pass`, or `aws:forward_to_sfe`.
 * In addition, you can specify custom actions that are compatible with your standard action choice. If you want non-matching packets to be forwarded for stateful inspection, specify `aws:forward_to_sfe`.
 * @property statelessRuleGroupReferences Set of configuration blocks containing references to the stateless rule groups that are used in the policy. See Stateless Rule Group Reference below for details.
 * @property tlsInspectionConfigurationArn The (ARN) of the TLS Inspection policy to attach to the FW Policy.  This must be added at creation of the resource per AWS documentation. "You can only add a TLS inspection configuration to a new policy, not to an existing policy."  This cannot be removed from a FW Policy.
 */
public data class FirewallPolicyFirewallPolicyArgs(
    public val policyVariables: Output<FirewallPolicyFirewallPolicyPolicyVariablesArgs>? = null,
    public val statefulDefaultActions: Output<List<String>>? = null,
    public val statefulEngineOptions: Output<FirewallPolicyFirewallPolicyStatefulEngineOptionsArgs>? =
        null,
    public val statefulRuleGroupReferences: Output<List<FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceArgs>>? = null,
    public val statelessCustomActions: Output<List<FirewallPolicyFirewallPolicyStatelessCustomActionArgs>>? = null,
    public val statelessDefaultActions: Output<List<String>>,
    public val statelessFragmentDefaultActions: Output<List<String>>,
    public val statelessRuleGroupReferences: Output<List<FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgs>>? = null,
    public val tlsInspectionConfigurationArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyArgs> {
    override fun toJava(): com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyArgs =
        com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyArgs.builder()
            .policyVariables(policyVariables?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .statefulDefaultActions(
                statefulDefaultActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .statefulEngineOptions(
                statefulEngineOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .statefulRuleGroupReferences(
                statefulRuleGroupReferences?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .statelessCustomActions(
                statelessCustomActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .statelessDefaultActions(
                statelessDefaultActions.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .statelessFragmentDefaultActions(
                statelessFragmentDefaultActions.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .statelessRuleGroupReferences(
                statelessRuleGroupReferences?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .tlsInspectionConfigurationArn(
                tlsInspectionConfigurationArn?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [FirewallPolicyFirewallPolicyArgs].
 */
@PulumiTagMarker
public class FirewallPolicyFirewallPolicyArgsBuilder internal constructor() {
    private var policyVariables: Output<FirewallPolicyFirewallPolicyPolicyVariablesArgs>? = null

    private var statefulDefaultActions: Output<List<String>>? = null

    private var statefulEngineOptions: Output<FirewallPolicyFirewallPolicyStatefulEngineOptionsArgs>? =
        null

    private var statefulRuleGroupReferences:
        Output<List<FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceArgs>>? = null

    private var statelessCustomActions:
        Output<List<FirewallPolicyFirewallPolicyStatelessCustomActionArgs>>? = null

    private var statelessDefaultActions: Output<List<String>>? = null

    private var statelessFragmentDefaultActions: Output<List<String>>? = null

    private var statelessRuleGroupReferences:
        Output<List<FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgs>>? = null

    private var tlsInspectionConfigurationArn: Output<String>? = null

    /**
     * @param value . Contains variables that you can use to override default Suricata settings in your firewall policy. See Rule Variables for details.
     */
    @JvmName("tijvkfyacwgcblkq")
    public suspend fun policyVariables(`value`: Output<FirewallPolicyFirewallPolicyPolicyVariablesArgs>) {
        this.policyVariables = value
    }

    /**
     * @param value Set of actions to take on a packet if it does not match any stateful rules in the policy. This can only be specified if the policy has a `stateful_engine_options` block with a `rule_order` value of `STRICT_ORDER`. You can specify one of either or neither values of `aws:drop_strict` or `aws:drop_established`, as well as any combination of `aws:alert_strict` and `aws:alert_established`.
     */
    @JvmName("wpibrhfhetsygcml")
    public suspend fun statefulDefaultActions(`value`: Output<List<String>>) {
        this.statefulDefaultActions = value
    }

    @JvmName("bdgslalfiowaiykd")
    public suspend fun statefulDefaultActions(vararg values: Output<String>) {
        this.statefulDefaultActions = Output.all(values.asList())
    }

    /**
     * @param values Set of actions to take on a packet if it does not match any stateful rules in the policy. This can only be specified if the policy has a `stateful_engine_options` block with a `rule_order` value of `STRICT_ORDER`. You can specify one of either or neither values of `aws:drop_strict` or `aws:drop_established`, as well as any combination of `aws:alert_strict` and `aws:alert_established`.
     */
    @JvmName("bmxafwgqhkmpsfrp")
    public suspend fun statefulDefaultActions(values: List<Output<String>>) {
        this.statefulDefaultActions = Output.all(values)
    }

    /**
     * @param value A configuration block that defines options on how the policy handles stateful rules. See Stateful Engine Options below for details.
     */
    @JvmName("phvvfhlvgskmkutr")
    public suspend fun statefulEngineOptions(`value`: Output<FirewallPolicyFirewallPolicyStatefulEngineOptionsArgs>) {
        this.statefulEngineOptions = value
    }

    /**
     * @param value Set of configuration blocks containing references to the stateful rule groups that are used in the policy. See Stateful Rule Group Reference below for details.
     */
    @JvmName("lfnultggjlurrxpu")
    public suspend fun statefulRuleGroupReferences(`value`: Output<List<FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceArgs>>) {
        this.statefulRuleGroupReferences = value
    }

    @JvmName("hhxlwgiagvyhvfly")
    public suspend fun statefulRuleGroupReferences(vararg values: Output<FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceArgs>) {
        this.statefulRuleGroupReferences = Output.all(values.asList())
    }

    /**
     * @param values Set of configuration blocks containing references to the stateful rule groups that are used in the policy. See Stateful Rule Group Reference below for details.
     */
    @JvmName("bmumdkhohrfhxytr")
    public suspend fun statefulRuleGroupReferences(values: List<Output<FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceArgs>>) {
        this.statefulRuleGroupReferences = Output.all(values)
    }

    /**
     * @param value Set of configuration blocks describing the custom action definitions that are available for use in the firewall policy's `stateless_default_actions`. See Stateless Custom Action below for details.
     */
    @JvmName("eupjkalncfbpbnbn")
    public suspend fun statelessCustomActions(`value`: Output<List<FirewallPolicyFirewallPolicyStatelessCustomActionArgs>>) {
        this.statelessCustomActions = value
    }

    @JvmName("waofafyxbbecrfnk")
    public suspend fun statelessCustomActions(vararg values: Output<FirewallPolicyFirewallPolicyStatelessCustomActionArgs>) {
        this.statelessCustomActions = Output.all(values.asList())
    }

    /**
     * @param values Set of configuration blocks describing the custom action definitions that are available for use in the firewall policy's `stateless_default_actions`. See Stateless Custom Action below for details.
     */
    @JvmName("equksrbknlvnvjur")
    public suspend fun statelessCustomActions(values: List<Output<FirewallPolicyFirewallPolicyStatelessCustomActionArgs>>) {
        this.statelessCustomActions = Output.all(values)
    }

    /**
     * @param value Set of actions to take on a packet if it does not match any of the stateless rules in the policy. You must specify one of the standard actions including: `aws:drop`, `aws:pass`, or `aws:forward_to_sfe`.
     * In addition, you can specify custom actions that are compatible with your standard action choice. If you want non-matching packets to be forwarded for stateful inspection, specify `aws:forward_to_sfe`.
     */
    @JvmName("facjrqxgmwquwsms")
    public suspend fun statelessDefaultActions(`value`: Output<List<String>>) {
        this.statelessDefaultActions = value
    }

    @JvmName("wyfpiqiftcqsaloi")
    public suspend fun statelessDefaultActions(vararg values: Output<String>) {
        this.statelessDefaultActions = Output.all(values.asList())
    }

    /**
     * @param values Set of actions to take on a packet if it does not match any of the stateless rules in the policy. You must specify one of the standard actions including: `aws:drop`, `aws:pass`, or `aws:forward_to_sfe`.
     * In addition, you can specify custom actions that are compatible with your standard action choice. If you want non-matching packets to be forwarded for stateful inspection, specify `aws:forward_to_sfe`.
     */
    @JvmName("nqnqurrjiynxpxec")
    public suspend fun statelessDefaultActions(values: List<Output<String>>) {
        this.statelessDefaultActions = Output.all(values)
    }

    /**
     * @param value Set of actions to take on a fragmented packet if it does not match any of the stateless rules in the policy. You must specify one of the standard actions including: `aws:drop`, `aws:pass`, or `aws:forward_to_sfe`.
     * In addition, you can specify custom actions that are compatible with your standard action choice. If you want non-matching packets to be forwarded for stateful inspection, specify `aws:forward_to_sfe`.
     */
    @JvmName("gbaqutqfsnumbkqn")
    public suspend fun statelessFragmentDefaultActions(`value`: Output<List<String>>) {
        this.statelessFragmentDefaultActions = value
    }

    @JvmName("hxkmldfrhkgmrhyy")
    public suspend fun statelessFragmentDefaultActions(vararg values: Output<String>) {
        this.statelessFragmentDefaultActions = Output.all(values.asList())
    }

    /**
     * @param values Set of actions to take on a fragmented packet if it does not match any of the stateless rules in the policy. You must specify one of the standard actions including: `aws:drop`, `aws:pass`, or `aws:forward_to_sfe`.
     * In addition, you can specify custom actions that are compatible with your standard action choice. If you want non-matching packets to be forwarded for stateful inspection, specify `aws:forward_to_sfe`.
     */
    @JvmName("vsnxfkllljyoipdj")
    public suspend fun statelessFragmentDefaultActions(values: List<Output<String>>) {
        this.statelessFragmentDefaultActions = Output.all(values)
    }

    /**
     * @param value Set of configuration blocks containing references to the stateless rule groups that are used in the policy. See Stateless Rule Group Reference below for details.
     */
    @JvmName("muirkxucxxqurfmi")
    public suspend fun statelessRuleGroupReferences(`value`: Output<List<FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgs>>) {
        this.statelessRuleGroupReferences = value
    }

    @JvmName("iepjytkwtpshdauq")
    public suspend fun statelessRuleGroupReferences(vararg values: Output<FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgs>) {
        this.statelessRuleGroupReferences = Output.all(values.asList())
    }

    /**
     * @param values Set of configuration blocks containing references to the stateless rule groups that are used in the policy. See Stateless Rule Group Reference below for details.
     */
    @JvmName("udsnulrjeusifipk")
    public suspend fun statelessRuleGroupReferences(values: List<Output<FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgs>>) {
        this.statelessRuleGroupReferences = Output.all(values)
    }

    /**
     * @param value The (ARN) of the TLS Inspection policy to attach to the FW Policy.  This must be added at creation of the resource per AWS documentation. "You can only add a TLS inspection configuration to a new policy, not to an existing policy."  This cannot be removed from a FW Policy.
     */
    @JvmName("vsxmsdbnatldqspk")
    public suspend fun tlsInspectionConfigurationArn(`value`: Output<String>) {
        this.tlsInspectionConfigurationArn = value
    }

    /**
     * @param value . Contains variables that you can use to override default Suricata settings in your firewall policy. See Rule Variables for details.
     */
    @JvmName("rrhgjyrmdvhcrbry")
    public suspend fun policyVariables(`value`: FirewallPolicyFirewallPolicyPolicyVariablesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyVariables = mapped
    }

    /**
     * @param argument . Contains variables that you can use to override default Suricata settings in your firewall policy. See Rule Variables for details.
     */
    @JvmName("gqwlcqnlesvurgjt")
    public suspend fun policyVariables(argument: suspend FirewallPolicyFirewallPolicyPolicyVariablesArgsBuilder.() -> Unit) {
        val toBeMapped = FirewallPolicyFirewallPolicyPolicyVariablesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.policyVariables = mapped
    }

    /**
     * @param value Set of actions to take on a packet if it does not match any stateful rules in the policy. This can only be specified if the policy has a `stateful_engine_options` block with a `rule_order` value of `STRICT_ORDER`. You can specify one of either or neither values of `aws:drop_strict` or `aws:drop_established`, as well as any combination of `aws:alert_strict` and `aws:alert_established`.
     */
    @JvmName("ieshbqlunkbxlvhk")
    public suspend fun statefulDefaultActions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statefulDefaultActions = mapped
    }

    /**
     * @param values Set of actions to take on a packet if it does not match any stateful rules in the policy. This can only be specified if the policy has a `stateful_engine_options` block with a `rule_order` value of `STRICT_ORDER`. You can specify one of either or neither values of `aws:drop_strict` or `aws:drop_established`, as well as any combination of `aws:alert_strict` and `aws:alert_established`.
     */
    @JvmName("qiqbimmxtdfufrhm")
    public suspend fun statefulDefaultActions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statefulDefaultActions = mapped
    }

    /**
     * @param value A configuration block that defines options on how the policy handles stateful rules. See Stateful Engine Options below for details.
     */
    @JvmName("ommlewkcvnlupfgm")
    public suspend fun statefulEngineOptions(`value`: FirewallPolicyFirewallPolicyStatefulEngineOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statefulEngineOptions = mapped
    }

    /**
     * @param argument A configuration block that defines options on how the policy handles stateful rules. See Stateful Engine Options below for details.
     */
    @JvmName("kqpmbrrrabdewawf")
    public suspend fun statefulEngineOptions(argument: suspend FirewallPolicyFirewallPolicyStatefulEngineOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = FirewallPolicyFirewallPolicyStatefulEngineOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.statefulEngineOptions = mapped
    }

    /**
     * @param value Set of configuration blocks containing references to the stateful rule groups that are used in the policy. See Stateful Rule Group Reference below for details.
     */
    @JvmName("bohmqhcuqereitvu")
    public suspend fun statefulRuleGroupReferences(`value`: List<FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statefulRuleGroupReferences = mapped
    }

    /**
     * @param argument Set of configuration blocks containing references to the stateful rule groups that are used in the policy. See Stateful Rule Group Reference below for details.
     */
    @JvmName("vxgxrvgulpjntfwh")
    public suspend fun statefulRuleGroupReferences(argument: List<suspend FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.statefulRuleGroupReferences = mapped
    }

    /**
     * @param argument Set of configuration blocks containing references to the stateful rule groups that are used in the policy. See Stateful Rule Group Reference below for details.
     */
    @JvmName("xvfbyquebwfllcbl")
    public suspend fun statefulRuleGroupReferences(vararg argument: suspend FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.statefulRuleGroupReferences = mapped
    }

    /**
     * @param argument Set of configuration blocks containing references to the stateful rule groups that are used in the policy. See Stateful Rule Group Reference below for details.
     */
    @JvmName("cvkhaaotfdwaybbu")
    public suspend fun statefulRuleGroupReferences(argument: suspend FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.statefulRuleGroupReferences = mapped
    }

    /**
     * @param values Set of configuration blocks containing references to the stateful rule groups that are used in the policy. See Stateful Rule Group Reference below for details.
     */
    @JvmName("kdfpsnvrnyunfdes")
    public suspend fun statefulRuleGroupReferences(vararg values: FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statefulRuleGroupReferences = mapped
    }

    /**
     * @param value Set of configuration blocks describing the custom action definitions that are available for use in the firewall policy's `stateless_default_actions`. See Stateless Custom Action below for details.
     */
    @JvmName("oildwpltsdouavtc")
    public suspend fun statelessCustomActions(`value`: List<FirewallPolicyFirewallPolicyStatelessCustomActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statelessCustomActions = mapped
    }

    /**
     * @param argument Set of configuration blocks describing the custom action definitions that are available for use in the firewall policy's `stateless_default_actions`. See Stateless Custom Action below for details.
     */
    @JvmName("uhfwkigovhwpibbc")
    public suspend fun statelessCustomActions(argument: List<suspend FirewallPolicyFirewallPolicyStatelessCustomActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirewallPolicyFirewallPolicyStatelessCustomActionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.statelessCustomActions = mapped
    }

    /**
     * @param argument Set of configuration blocks describing the custom action definitions that are available for use in the firewall policy's `stateless_default_actions`. See Stateless Custom Action below for details.
     */
    @JvmName("djaeppthfqhxgolw")
    public suspend fun statelessCustomActions(vararg argument: suspend FirewallPolicyFirewallPolicyStatelessCustomActionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FirewallPolicyFirewallPolicyStatelessCustomActionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.statelessCustomActions = mapped
    }

    /**
     * @param argument Set of configuration blocks describing the custom action definitions that are available for use in the firewall policy's `stateless_default_actions`. See Stateless Custom Action below for details.
     */
    @JvmName("gakviuqpkpiqvsql")
    public suspend fun statelessCustomActions(argument: suspend FirewallPolicyFirewallPolicyStatelessCustomActionArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                FirewallPolicyFirewallPolicyStatelessCustomActionArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.statelessCustomActions = mapped
    }

    /**
     * @param values Set of configuration blocks describing the custom action definitions that are available for use in the firewall policy's `stateless_default_actions`. See Stateless Custom Action below for details.
     */
    @JvmName("dvhcxbxxmlgmlxhr")
    public suspend fun statelessCustomActions(vararg values: FirewallPolicyFirewallPolicyStatelessCustomActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statelessCustomActions = mapped
    }

    /**
     * @param value Set of actions to take on a packet if it does not match any of the stateless rules in the policy. You must specify one of the standard actions including: `aws:drop`, `aws:pass`, or `aws:forward_to_sfe`.
     * In addition, you can specify custom actions that are compatible with your standard action choice. If you want non-matching packets to be forwarded for stateful inspection, specify `aws:forward_to_sfe`.
     */
    @JvmName("bqxgyanfgtdopkuq")
    public suspend fun statelessDefaultActions(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statelessDefaultActions = mapped
    }

    /**
     * @param values Set of actions to take on a packet if it does not match any of the stateless rules in the policy. You must specify one of the standard actions including: `aws:drop`, `aws:pass`, or `aws:forward_to_sfe`.
     * In addition, you can specify custom actions that are compatible with your standard action choice. If you want non-matching packets to be forwarded for stateful inspection, specify `aws:forward_to_sfe`.
     */
    @JvmName("hognlhytbojnmuti")
    public suspend fun statelessDefaultActions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statelessDefaultActions = mapped
    }

    /**
     * @param value Set of actions to take on a fragmented packet if it does not match any of the stateless rules in the policy. You must specify one of the standard actions including: `aws:drop`, `aws:pass`, or `aws:forward_to_sfe`.
     * In addition, you can specify custom actions that are compatible with your standard action choice. If you want non-matching packets to be forwarded for stateful inspection, specify `aws:forward_to_sfe`.
     */
    @JvmName("amdwaqrcuqpvfamh")
    public suspend fun statelessFragmentDefaultActions(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statelessFragmentDefaultActions = mapped
    }

    /**
     * @param values Set of actions to take on a fragmented packet if it does not match any of the stateless rules in the policy. You must specify one of the standard actions including: `aws:drop`, `aws:pass`, or `aws:forward_to_sfe`.
     * In addition, you can specify custom actions that are compatible with your standard action choice. If you want non-matching packets to be forwarded for stateful inspection, specify `aws:forward_to_sfe`.
     */
    @JvmName("hblirxusooyapijl")
    public suspend fun statelessFragmentDefaultActions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statelessFragmentDefaultActions = mapped
    }

    /**
     * @param value Set of configuration blocks containing references to the stateless rule groups that are used in the policy. See Stateless Rule Group Reference below for details.
     */
    @JvmName("rrmoppsoncauogqw")
    public suspend fun statelessRuleGroupReferences(`value`: List<FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statelessRuleGroupReferences = mapped
    }

    /**
     * @param argument Set of configuration blocks containing references to the stateless rule groups that are used in the policy. See Stateless Rule Group Reference below for details.
     */
    @JvmName("eowdlamjnkfehdeu")
    public suspend fun statelessRuleGroupReferences(argument: List<suspend FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.statelessRuleGroupReferences = mapped
    }

    /**
     * @param argument Set of configuration blocks containing references to the stateless rule groups that are used in the policy. See Stateless Rule Group Reference below for details.
     */
    @JvmName("kfivenfitwxcnyip")
    public suspend fun statelessRuleGroupReferences(vararg argument: suspend FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.statelessRuleGroupReferences = mapped
    }

    /**
     * @param argument Set of configuration blocks containing references to the stateless rule groups that are used in the policy. See Stateless Rule Group Reference below for details.
     */
    @JvmName("lwjvaurnbqaygiib")
    public suspend fun statelessRuleGroupReferences(argument: suspend FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.statelessRuleGroupReferences = mapped
    }

    /**
     * @param values Set of configuration blocks containing references to the stateless rule groups that are used in the policy. See Stateless Rule Group Reference below for details.
     */
    @JvmName("rfubyiljaybstnvy")
    public suspend fun statelessRuleGroupReferences(vararg values: FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statelessRuleGroupReferences = mapped
    }

    /**
     * @param value The (ARN) of the TLS Inspection policy to attach to the FW Policy.  This must be added at creation of the resource per AWS documentation. "You can only add a TLS inspection configuration to a new policy, not to an existing policy."  This cannot be removed from a FW Policy.
     */
    @JvmName("qfbgjtfpgykiknlj")
    public suspend fun tlsInspectionConfigurationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tlsInspectionConfigurationArn = mapped
    }

    internal fun build(): FirewallPolicyFirewallPolicyArgs = FirewallPolicyFirewallPolicyArgs(
        policyVariables = policyVariables,
        statefulDefaultActions = statefulDefaultActions,
        statefulEngineOptions = statefulEngineOptions,
        statefulRuleGroupReferences = statefulRuleGroupReferences,
        statelessCustomActions = statelessCustomActions,
        statelessDefaultActions = statelessDefaultActions ?: throw
            PulumiNullFieldException("statelessDefaultActions"),
        statelessFragmentDefaultActions = statelessFragmentDefaultActions ?: throw
            PulumiNullFieldException("statelessFragmentDefaultActions"),
        statelessRuleGroupReferences = statelessRuleGroupReferences,
        tlsInspectionConfigurationArn = tlsInspectionConfigurationArn,
    )
}
