@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property ipSet A configuration block that defines a set of IP addresses. See IP Set below for details.
 * @property key An alphanumeric string to identify the `ip_set`. Valid values: `HOME_NET`
 */
public data class FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableArgs(
    public val ipSet: Output<FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableIpSetArgs>,
    public val key: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableArgs> {
    override fun toJava(): com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableArgs =
        com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableArgs.builder()
            .ipSet(ipSet.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .key(key.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableArgs].
 */
@PulumiTagMarker
public class FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableArgsBuilder internal constructor() {
    private var ipSet: Output<FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableIpSetArgs>? =
        null

    private var key: Output<String>? = null

    /**
     * @param value A configuration block that defines a set of IP addresses. See IP Set below for details.
     */
    @JvmName("nwqwjjbaqlsgcrxp")
    public suspend fun ipSet(`value`: Output<FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableIpSetArgs>) {
        this.ipSet = value
    }

    /**
     * @param value An alphanumeric string to identify the `ip_set`. Valid values: `HOME_NET`
     */
    @JvmName("garyhonmosmlrvbt")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value A configuration block that defines a set of IP addresses. See IP Set below for details.
     */
    @JvmName("qrjeyxhwanelqtcn")
    public suspend fun ipSet(`value`: FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableIpSetArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipSet = mapped
    }

    /**
     * @param argument A configuration block that defines a set of IP addresses. See IP Set below for details.
     */
    @JvmName("hywioktmhjwtmijs")
    public suspend fun ipSet(argument: suspend FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableIpSetArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableIpSetArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ipSet = mapped
    }

    /**
     * @param value An alphanumeric string to identify the `ip_set`. Valid values: `HOME_NET`
     */
    @JvmName("qwmrkrfiyehcmjle")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    internal fun build(): FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableArgs =
        FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableArgs(
            ipSet = ipSet ?: throw PulumiNullFieldException("ipSet"),
            key = key ?: throw PulumiNullFieldException("key"),
        )
}
