@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableIpSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property definitions Set of IPv4 or IPv6 addresses in CIDR notation to use for the Suricata `HOME_NET` variable.
 */
public data class FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableIpSetArgs(
    public val definitions: Output<List<String>>,
) :
    ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableIpSetArgs> {
    override fun toJava(): com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableIpSetArgs =
        com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableIpSetArgs.builder()
            .definitions(definitions.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableIpSetArgs].
 */
@PulumiTagMarker
public class FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableIpSetArgsBuilder internal constructor() {
    private var definitions: Output<List<String>>? = null

    /**
     * @param value Set of IPv4 or IPv6 addresses in CIDR notation to use for the Suricata `HOME_NET` variable.
     */
    @JvmName("mbbswstcxsrcpdmd")
    public suspend fun definitions(`value`: Output<List<String>>) {
        this.definitions = value
    }

    @JvmName("remwontyjxjknolt")
    public suspend fun definitions(vararg values: Output<String>) {
        this.definitions = Output.all(values.asList())
    }

    /**
     * @param values Set of IPv4 or IPv6 addresses in CIDR notation to use for the Suricata `HOME_NET` variable.
     */
    @JvmName("npckkdpgwabltgpv")
    public suspend fun definitions(values: List<Output<String>>) {
        this.definitions = Output.all(values)
    }

    /**
     * @param value Set of IPv4 or IPv6 addresses in CIDR notation to use for the Suricata `HOME_NET` variable.
     */
    @JvmName("cltsamjidxhfchkh")
    public suspend fun definitions(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.definitions = mapped
    }

    /**
     * @param values Set of IPv4 or IPv6 addresses in CIDR notation to use for the Suricata `HOME_NET` variable.
     */
    @JvmName("ldfpwmueqxvobaxx")
    public suspend fun definitions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.definitions = mapped
    }

    internal fun build(): FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableIpSetArgs =
        FirewallPolicyFirewallPolicyPolicyVariablesRuleVariableIpSetArgs(
            definitions = definitions ?: throw PulumiNullFieldException("definitions"),
        )
}
