@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property priority An integer setting that indicates the order in which to run the stateless rule groups in a single policy. AWS Network Firewall applies each stateless rule group to a packet starting with the group that has the lowest priority setting.
 * @property resourceArn The Amazon Resource Name (ARN) of the stateless rule group.
 */
public data class FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgs(
    public val priority: Output<Int>,
    public val resourceArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgs> {
    override fun toJava(): com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgs =
        com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgs.builder()
            .priority(priority.applyValue({ args0 -> args0 }))
            .resourceArn(resourceArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgs].
 */
@PulumiTagMarker
public class FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgsBuilder internal constructor() {
    private var priority: Output<Int>? = null

    private var resourceArn: Output<String>? = null

    /**
     * @param value An integer setting that indicates the order in which to run the stateless rule groups in a single policy. AWS Network Firewall applies each stateless rule group to a packet starting with the group that has the lowest priority setting.
     */
    @JvmName("munpryuqconpjfes")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the stateless rule group.
     */
    @JvmName("xjduhwsrwhdhywya")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value An integer setting that indicates the order in which to run the stateless rule groups in a single policy. AWS Network Firewall applies each stateless rule group to a packet starting with the group that has the lowest priority setting.
     */
    @JvmName("gdbnctngsqyvyjbs")
    public suspend fun priority(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the stateless rule group.
     */
    @JvmName("trdymjdbftrhougr")
    public suspend fun resourceArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    internal fun build(): FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgs =
        FirewallPolicyFirewallPolicyStatelessRuleGroupReferenceArgs(
            priority = priority ?: throw PulumiNullFieldException("priority"),
            resourceArn = resourceArn ?: throw PulumiNullFieldException("resourceArn"),
        )
}
