@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.FirewallSubnetMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ipAddressType The subnet's IP address type. Valida values: `"DUALSTACK"`, `"IPV4"`.
 * @property subnetId The unique identifier for the subnet.
 */
public data class FirewallSubnetMappingArgs(
    public val ipAddressType: Output<String>? = null,
    public val subnetId: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.FirewallSubnetMappingArgs> {
    override fun toJava(): com.pulumi.aws.networkfirewall.inputs.FirewallSubnetMappingArgs =
        com.pulumi.aws.networkfirewall.inputs.FirewallSubnetMappingArgs.builder()
            .ipAddressType(ipAddressType?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirewallSubnetMappingArgs].
 */
@PulumiTagMarker
public class FirewallSubnetMappingArgsBuilder internal constructor() {
    private var ipAddressType: Output<String>? = null

    private var subnetId: Output<String>? = null

    /**
     * @param value The subnet's IP address type. Valida values: `"DUALSTACK"`, `"IPV4"`.
     */
    @JvmName("gmnynwtdtyigwmhb")
    public suspend fun ipAddressType(`value`: Output<String>) {
        this.ipAddressType = value
    }

    /**
     * @param value The unique identifier for the subnet.
     */
    @JvmName("wujwrudxkhtkcjsa")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value The subnet's IP address type. Valida values: `"DUALSTACK"`, `"IPV4"`.
     */
    @JvmName("tbrsmitytuvphksr")
    public suspend fun ipAddressType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddressType = mapped
    }

    /**
     * @param value The unique identifier for the subnet.
     */
    @JvmName("xsamcolvnjcllulk")
    public suspend fun subnetId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    internal fun build(): FirewallSubnetMappingArgs = FirewallSubnetMappingArgs(
        ipAddressType = ipAddressType,
        subnetId = subnetId ?: throw PulumiNullFieldException("subnetId"),
    )
}
