@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.GetFirewallPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getFirewallPolicy.
 * @property arn ARN of the firewall policy.
 * @property name Descriptive name of the firewall policy.
 * @property tags Key-value tags for the firewall policy.
 */
public data class GetFirewallPolicyPlainArgs(
    public val arn: String? = null,
    public val name: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.GetFirewallPolicyPlainArgs> {
    override fun toJava(): com.pulumi.aws.networkfirewall.inputs.GetFirewallPolicyPlainArgs =
        com.pulumi.aws.networkfirewall.inputs.GetFirewallPolicyPlainArgs.builder()
            .arn(arn?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetFirewallPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetFirewallPolicyPlainArgsBuilder internal constructor() {
    private var arn: String? = null

    private var name: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value ARN of the firewall policy.
     */
    @JvmName("mnldtbcdlvjhvfhy")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.arn = mapped
    }

    /**
     * @param value Descriptive name of the firewall policy.
     */
    @JvmName("swoklhkceghqkjky")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Key-value tags for the firewall policy.
     */
    @JvmName("urqhqurrenceilvk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the firewall policy.
     */
    @JvmName("hhnaygbbadqgavlj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetFirewallPolicyPlainArgs = GetFirewallPolicyPlainArgs(
        arn = arn,
        name = name,
        tags = tags,
    )
}
