@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.GetResourcePolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getResourcePolicy.
 * @property resourceArn The Amazon Resource Name (ARN) that identifies the resource policy.
 */
public data class GetResourcePolicyPlainArgs(
    public val resourceArn: String,
) : ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.GetResourcePolicyPlainArgs> {
    override fun toJava(): com.pulumi.aws.networkfirewall.inputs.GetResourcePolicyPlainArgs =
        com.pulumi.aws.networkfirewall.inputs.GetResourcePolicyPlainArgs.builder()
            .resourceArn(resourceArn.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetResourcePolicyPlainArgs].
 */
@PulumiTagMarker
public class GetResourcePolicyPlainArgsBuilder internal constructor() {
    private var resourceArn: String? = null

    /**
     * @param value The Amazon Resource Name (ARN) that identifies the resource policy.
     */
    @JvmName("denqjlxbufywahsx")
    public suspend fun resourceArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceArn = mapped
    }

    internal fun build(): GetResourcePolicyPlainArgs = GetResourcePolicyPlainArgs(
        resourceArn = resourceArn ?: throw PulumiNullFieldException("resourceArn"),
    )
}
