@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.LoggingConfigurationLoggingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property logDestinationConfigs Set of configuration blocks describing the logging details for a firewall. See Log Destination Config below for details. At most, only two blocks can be specified; one for `FLOW` logs and one for `ALERT` logs.
 */
public data class LoggingConfigurationLoggingConfigurationArgs(
    public val logDestinationConfigs: Output<List<LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.LoggingConfigurationLoggingConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.networkfirewall.inputs.LoggingConfigurationLoggingConfigurationArgs =
        com.pulumi.aws.networkfirewall.inputs.LoggingConfigurationLoggingConfigurationArgs.builder()
            .logDestinationConfigs(
                logDestinationConfigs.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [LoggingConfigurationLoggingConfigurationArgs].
 */
@PulumiTagMarker
public class LoggingConfigurationLoggingConfigurationArgsBuilder internal constructor() {
    private var logDestinationConfigs:
        Output<List<LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs>>? = null

    /**
     * @param value Set of configuration blocks describing the logging details for a firewall. See Log Destination Config below for details. At most, only two blocks can be specified; one for `FLOW` logs and one for `ALERT` logs.
     */
    @JvmName("hsuudxhwobiitqoj")
    public suspend fun logDestinationConfigs(`value`: Output<List<LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs>>) {
        this.logDestinationConfigs = value
    }

    @JvmName("bfgbkyrsnvjepenc")
    public suspend fun logDestinationConfigs(vararg values: Output<LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs>) {
        this.logDestinationConfigs = Output.all(values.asList())
    }

    /**
     * @param values Set of configuration blocks describing the logging details for a firewall. See Log Destination Config below for details. At most, only two blocks can be specified; one for `FLOW` logs and one for `ALERT` logs.
     */
    @JvmName("sltvegqlhpqhxflx")
    public suspend fun logDestinationConfigs(values: List<Output<LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs>>) {
        this.logDestinationConfigs = Output.all(values)
    }

    /**
     * @param value Set of configuration blocks describing the logging details for a firewall. See Log Destination Config below for details. At most, only two blocks can be specified; one for `FLOW` logs and one for `ALERT` logs.
     */
    @JvmName("osbpytudlvfioojh")
    public suspend fun logDestinationConfigs(`value`: List<LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logDestinationConfigs = mapped
    }

    /**
     * @param argument Set of configuration blocks describing the logging details for a firewall. See Log Destination Config below for details. At most, only two blocks can be specified; one for `FLOW` logs and one for `ALERT` logs.
     */
    @JvmName("kijymrwxuamscthn")
    public suspend fun logDestinationConfigs(argument: List<suspend LoggingConfigurationLoggingConfigurationLogDestinationConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LoggingConfigurationLoggingConfigurationLogDestinationConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.logDestinationConfigs = mapped
    }

    /**
     * @param argument Set of configuration blocks describing the logging details for a firewall. See Log Destination Config below for details. At most, only two blocks can be specified; one for `FLOW` logs and one for `ALERT` logs.
     */
    @JvmName("fxmqknvwiyuamenh")
    public suspend fun logDestinationConfigs(vararg argument: suspend LoggingConfigurationLoggingConfigurationLogDestinationConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LoggingConfigurationLoggingConfigurationLogDestinationConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.logDestinationConfigs = mapped
    }

    /**
     * @param argument Set of configuration blocks describing the logging details for a firewall. See Log Destination Config below for details. At most, only two blocks can be specified; one for `FLOW` logs and one for `ALERT` logs.
     */
    @JvmName("gchdnmgioiioteik")
    public suspend fun logDestinationConfigs(argument: suspend LoggingConfigurationLoggingConfigurationLogDestinationConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                LoggingConfigurationLoggingConfigurationLogDestinationConfigArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.logDestinationConfigs = mapped
    }

    /**
     * @param values Set of configuration blocks describing the logging details for a firewall. See Log Destination Config below for details. At most, only two blocks can be specified; one for `FLOW` logs and one for `ALERT` logs.
     */
    @JvmName("rhqreuwabfdgvggr")
    public suspend fun logDestinationConfigs(vararg values: LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logDestinationConfigs = mapped
    }

    internal fun build(): LoggingConfigurationLoggingConfigurationArgs =
        LoggingConfigurationLoggingConfigurationArgs(
            logDestinationConfigs = logDestinationConfigs ?: throw
                PulumiNullFieldException("logDestinationConfigs"),
        )
}
