@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupReferenceSetsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property ipSetReferences
 */
public data class RuleGroupRuleGroupReferenceSetsArgs(
    public val ipSetReferences: Output<List<RuleGroupRuleGroupReferenceSetsIpSetReferenceArgs>>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupReferenceSetsArgs> {
    override fun toJava(): com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupReferenceSetsArgs =
        com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupReferenceSetsArgs.builder()
            .ipSetReferences(
                ipSetReferences?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleGroupReferenceSetsArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleGroupReferenceSetsArgsBuilder internal constructor() {
    private var ipSetReferences: Output<List<RuleGroupRuleGroupReferenceSetsIpSetReferenceArgs>>? =
        null

    /**
     * @param value
     */
    @JvmName("ejwpgofnyknfrmqc")
    public suspend fun ipSetReferences(`value`: Output<List<RuleGroupRuleGroupReferenceSetsIpSetReferenceArgs>>) {
        this.ipSetReferences = value
    }

    @JvmName("ytjwqikgowjbnjse")
    public suspend fun ipSetReferences(vararg values: Output<RuleGroupRuleGroupReferenceSetsIpSetReferenceArgs>) {
        this.ipSetReferences = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("imasgeshfqtapkrv")
    public suspend fun ipSetReferences(values: List<Output<RuleGroupRuleGroupReferenceSetsIpSetReferenceArgs>>) {
        this.ipSetReferences = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("xgicjdmirwymhobm")
    public suspend fun ipSetReferences(`value`: List<RuleGroupRuleGroupReferenceSetsIpSetReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipSetReferences = mapped
    }

    /**
     * @param argument
     */
    @JvmName("agpdqepyvwqihdka")
    public suspend fun ipSetReferences(argument: List<suspend RuleGroupRuleGroupReferenceSetsIpSetReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleGroupReferenceSetsIpSetReferenceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipSetReferences = mapped
    }

    /**
     * @param argument
     */
    @JvmName("igbuvkutppdgsqba")
    public suspend fun ipSetReferences(vararg argument: suspend RuleGroupRuleGroupReferenceSetsIpSetReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleGroupReferenceSetsIpSetReferenceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipSetReferences = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ykmobfsopwnwqrav")
    public suspend fun ipSetReferences(argument: suspend RuleGroupRuleGroupReferenceSetsIpSetReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RuleGroupRuleGroupReferenceSetsIpSetReferenceArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.ipSetReferences = mapped
    }

    /**
     * @param values
     */
    @JvmName("qciwdfvacsdtfqlj")
    public suspend fun ipSetReferences(vararg values: RuleGroupRuleGroupReferenceSetsIpSetReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipSetReferences = mapped
    }

    internal fun build(): RuleGroupRuleGroupReferenceSetsArgs = RuleGroupRuleGroupReferenceSetsArgs(
        ipSetReferences = ipSetReferences,
    )
}
