@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupReferenceSetsIpSetReferenceIpSetReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property referenceArn Set of Managed Prefix IP ARN(s)
 */
public data class RuleGroupRuleGroupReferenceSetsIpSetReferenceIpSetReferenceArgs(
    public val referenceArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupReferenceSetsIpSetReferenceIpSetReferenceArgs> {
    override fun toJava(): com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupReferenceSetsIpSetReferenceIpSetReferenceArgs =
        com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupReferenceSetsIpSetReferenceIpSetReferenceArgs.builder()
            .referenceArn(referenceArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleGroupRuleGroupReferenceSetsIpSetReferenceIpSetReferenceArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleGroupReferenceSetsIpSetReferenceIpSetReferenceArgsBuilder internal constructor() {
    private var referenceArn: Output<String>? = null

    /**
     * @param value Set of Managed Prefix IP ARN(s)
     */
    @JvmName("yrosnefynvlpumux")
    public suspend fun referenceArn(`value`: Output<String>) {
        this.referenceArn = value
    }

    /**
     * @param value Set of Managed Prefix IP ARN(s)
     */
    @JvmName("kkodouypdkqmshof")
    public suspend fun referenceArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.referenceArn = mapped
    }

    internal fun build(): RuleGroupRuleGroupReferenceSetsIpSetReferenceIpSetReferenceArgs =
        RuleGroupRuleGroupReferenceSetsIpSetReferenceIpSetReferenceArgs(
            referenceArn = referenceArn ?: throw PulumiNullFieldException("referenceArn"),
        )
}
