@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRuleVariablesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property ipSets Set of configuration blocks that define IP address information. See IP Sets below for details.
 * @property portSets Set of configuration blocks that define port range information. See Port Sets below for details.
 */
public data class RuleGroupRuleGroupRuleVariablesArgs(
    public val ipSets: Output<List<RuleGroupRuleGroupRuleVariablesIpSetArgs>>? = null,
    public val portSets: Output<List<RuleGroupRuleGroupRuleVariablesPortSetArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRuleVariablesArgs> {
    override fun toJava(): com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRuleVariablesArgs =
        com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRuleVariablesArgs.builder()
            .ipSets(ipSets?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .portSets(
                portSets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleGroupRuleVariablesArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleGroupRuleVariablesArgsBuilder internal constructor() {
    private var ipSets: Output<List<RuleGroupRuleGroupRuleVariablesIpSetArgs>>? = null

    private var portSets: Output<List<RuleGroupRuleGroupRuleVariablesPortSetArgs>>? = null

    /**
     * @param value Set of configuration blocks that define IP address information. See IP Sets below for details.
     */
    @JvmName("yavdbopacvieauna")
    public suspend fun ipSets(`value`: Output<List<RuleGroupRuleGroupRuleVariablesIpSetArgs>>) {
        this.ipSets = value
    }

    @JvmName("abwpigsiyhtfwwgv")
    public suspend fun ipSets(vararg values: Output<RuleGroupRuleGroupRuleVariablesIpSetArgs>) {
        this.ipSets = Output.all(values.asList())
    }

    /**
     * @param values Set of configuration blocks that define IP address information. See IP Sets below for details.
     */
    @JvmName("agxfpemljutmdvye")
    public suspend fun ipSets(values: List<Output<RuleGroupRuleGroupRuleVariablesIpSetArgs>>) {
        this.ipSets = Output.all(values)
    }

    /**
     * @param value Set of configuration blocks that define port range information. See Port Sets below for details.
     */
    @JvmName("tquyusochjmlnhpu")
    public suspend fun portSets(`value`: Output<List<RuleGroupRuleGroupRuleVariablesPortSetArgs>>) {
        this.portSets = value
    }

    @JvmName("sylkmknxhobxtxgj")
    public suspend fun portSets(vararg values: Output<RuleGroupRuleGroupRuleVariablesPortSetArgs>) {
        this.portSets = Output.all(values.asList())
    }

    /**
     * @param values Set of configuration blocks that define port range information. See Port Sets below for details.
     */
    @JvmName("sfkbpnwhrbqclonk")
    public suspend fun portSets(values: List<Output<RuleGroupRuleGroupRuleVariablesPortSetArgs>>) {
        this.portSets = Output.all(values)
    }

    /**
     * @param value Set of configuration blocks that define IP address information. See IP Sets below for details.
     */
    @JvmName("cfxjctbllppdojef")
    public suspend fun ipSets(`value`: List<RuleGroupRuleGroupRuleVariablesIpSetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipSets = mapped
    }

    /**
     * @param argument Set of configuration blocks that define IP address information. See IP Sets below for details.
     */
    @JvmName("xopumavkovdutvyj")
    public suspend fun ipSets(argument: List<suspend RuleGroupRuleGroupRuleVariablesIpSetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleGroupRuleVariablesIpSetArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipSets = mapped
    }

    /**
     * @param argument Set of configuration blocks that define IP address information. See IP Sets below for details.
     */
    @JvmName("ytrfmsnwftduciww")
    public suspend fun ipSets(vararg argument: suspend RuleGroupRuleGroupRuleVariablesIpSetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleGroupRuleVariablesIpSetArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipSets = mapped
    }

    /**
     * @param argument Set of configuration blocks that define IP address information. See IP Sets below for details.
     */
    @JvmName("vjnmiwswsdpxkics")
    public suspend fun ipSets(argument: suspend RuleGroupRuleGroupRuleVariablesIpSetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RuleGroupRuleGroupRuleVariablesIpSetArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ipSets = mapped
    }

    /**
     * @param values Set of configuration blocks that define IP address information. See IP Sets below for details.
     */
    @JvmName("kycnimiinwjmejbp")
    public suspend fun ipSets(vararg values: RuleGroupRuleGroupRuleVariablesIpSetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipSets = mapped
    }

    /**
     * @param value Set of configuration blocks that define port range information. See Port Sets below for details.
     */
    @JvmName("chxpjidlgrhqpjjs")
    public suspend fun portSets(`value`: List<RuleGroupRuleGroupRuleVariablesPortSetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portSets = mapped
    }

    /**
     * @param argument Set of configuration blocks that define port range information. See Port Sets below for details.
     */
    @JvmName("paksapsbadcmwaop")
    public suspend fun portSets(argument: List<suspend RuleGroupRuleGroupRuleVariablesPortSetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleGroupRuleVariablesPortSetArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.portSets = mapped
    }

    /**
     * @param argument Set of configuration blocks that define port range information. See Port Sets below for details.
     */
    @JvmName("axiaqnmbprsfybii")
    public suspend fun portSets(vararg argument: suspend RuleGroupRuleGroupRuleVariablesPortSetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleGroupRuleVariablesPortSetArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.portSets = mapped
    }

    /**
     * @param argument Set of configuration blocks that define port range information. See Port Sets below for details.
     */
    @JvmName("quujggllxdcolqqd")
    public suspend fun portSets(argument: suspend RuleGroupRuleGroupRuleVariablesPortSetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RuleGroupRuleGroupRuleVariablesPortSetArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.portSets = mapped
    }

    /**
     * @param values Set of configuration blocks that define port range information. See Port Sets below for details.
     */
    @JvmName("aqfvimflvjufjfja")
    public suspend fun portSets(vararg values: RuleGroupRuleGroupRuleVariablesPortSetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.portSets = mapped
    }

    internal fun build(): RuleGroupRuleGroupRuleVariablesArgs = RuleGroupRuleGroupRuleVariablesArgs(
        ipSets = ipSets,
        portSets = portSets,
    )
}
