@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRuleVariablesIpSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property ipSet A configuration block that defines a set of IP addresses. See IP Set below for details.
 * @property key A unique alphanumeric string to identify the `ip_set`.
 */
public data class RuleGroupRuleGroupRuleVariablesIpSetArgs(
    public val ipSet: Output<RuleGroupRuleGroupRuleVariablesIpSetIpSetArgs>,
    public val key: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRuleVariablesIpSetArgs> {
    override fun toJava(): com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRuleVariablesIpSetArgs =
        com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRuleVariablesIpSetArgs.builder()
            .ipSet(ipSet.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .key(key.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleGroupRuleGroupRuleVariablesIpSetArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleGroupRuleVariablesIpSetArgsBuilder internal constructor() {
    private var ipSet: Output<RuleGroupRuleGroupRuleVariablesIpSetIpSetArgs>? = null

    private var key: Output<String>? = null

    /**
     * @param value A configuration block that defines a set of IP addresses. See IP Set below for details.
     */
    @JvmName("nixhnmrrcnmxfxry")
    public suspend fun ipSet(`value`: Output<RuleGroupRuleGroupRuleVariablesIpSetIpSetArgs>) {
        this.ipSet = value
    }

    /**
     * @param value A unique alphanumeric string to identify the `ip_set`.
     */
    @JvmName("dvgmwlwhhdfcqngu")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value A configuration block that defines a set of IP addresses. See IP Set below for details.
     */
    @JvmName("jousctgfubmqyhiq")
    public suspend fun ipSet(`value`: RuleGroupRuleGroupRuleVariablesIpSetIpSetArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipSet = mapped
    }

    /**
     * @param argument A configuration block that defines a set of IP addresses. See IP Set below for details.
     */
    @JvmName("dcywtxwkgnvfgrbe")
    public suspend fun ipSet(argument: suspend RuleGroupRuleGroupRuleVariablesIpSetIpSetArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleGroupRuleVariablesIpSetIpSetArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.ipSet = mapped
    }

    /**
     * @param value A unique alphanumeric string to identify the `ip_set`.
     */
    @JvmName("kpihnifhoojmtvcx")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    internal fun build(): RuleGroupRuleGroupRuleVariablesIpSetArgs =
        RuleGroupRuleGroupRuleVariablesIpSetArgs(
            ipSet = ipSet ?: throw PulumiNullFieldException("ipSet"),
            key = key ?: throw PulumiNullFieldException("key"),
        )
}
