@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRuleVariablesPortSetPortSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property definitions Set of port ranges.
 */
public data class RuleGroupRuleGroupRuleVariablesPortSetPortSetArgs(
    public val definitions: Output<List<String>>,
) :
    ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRuleVariablesPortSetPortSetArgs> {
    override fun toJava(): com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRuleVariablesPortSetPortSetArgs =
        com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRuleVariablesPortSetPortSetArgs.builder()
            .definitions(definitions.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [RuleGroupRuleGroupRuleVariablesPortSetPortSetArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleGroupRuleVariablesPortSetPortSetArgsBuilder internal constructor() {
    private var definitions: Output<List<String>>? = null

    /**
     * @param value Set of port ranges.
     */
    @JvmName("mwhlomvuoronvrbh")
    public suspend fun definitions(`value`: Output<List<String>>) {
        this.definitions = value
    }

    @JvmName("vjbbcmrurfbvnnjl")
    public suspend fun definitions(vararg values: Output<String>) {
        this.definitions = Output.all(values.asList())
    }

    /**
     * @param values Set of port ranges.
     */
    @JvmName("kxfjcxnnvoitwpqr")
    public suspend fun definitions(values: List<Output<String>>) {
        this.definitions = Output.all(values)
    }

    /**
     * @param value Set of port ranges.
     */
    @JvmName("nmhpljiadfbvhbbc")
    public suspend fun definitions(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.definitions = mapped
    }

    /**
     * @param values Set of port ranges.
     */
    @JvmName("qxvdmhsfyxpaqqkg")
    public suspend fun definitions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.definitions = mapped
    }

    internal fun build(): RuleGroupRuleGroupRuleVariablesPortSetPortSetArgs =
        RuleGroupRuleGroupRuleVariablesPortSetPortSetArgs(
            definitions = definitions ?: throw PulumiNullFieldException("definitions"),
        )
}
