@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceStatefulRuleHeaderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property destination The destination IP address or address range to inspect for, in CIDR notation. To match with any address, specify `ANY`.
 * @property destinationPort The destination port to inspect for. To match with any address, specify `ANY`.
 * @property direction The direction of traffic flow to inspect. Valid values: `ANY` or `FORWARD`.
 * @property protocol The protocol to inspect. Valid values: `IP`, `TCP`, `UDP`, `ICMP`, `HTTP`, `FTP`, `TLS`, `SMB`, `DNS`, `DCERPC`, `SSH`, `SMTP`, `IMAP`, `MSN`, `KRB5`, `IKEV2`, `TFTP`, `NTP`, `DHCP`.
 * @property source The source IP address or address range for, in CIDR notation. To match with any address, specify `ANY`.
 * @property sourcePort The source port to inspect for. To match with any address, specify `ANY`.
 */
public data class RuleGroupRuleGroupRulesSourceStatefulRuleHeaderArgs(
    public val destination: Output<String>,
    public val destinationPort: Output<String>,
    public val direction: Output<String>,
    public val protocol: Output<String>,
    public val source: Output<String>,
    public val sourcePort: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceStatefulRuleHeaderArgs> {
    override fun toJava(): com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceStatefulRuleHeaderArgs =
        com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceStatefulRuleHeaderArgs.builder()
            .destination(destination.applyValue({ args0 -> args0 }))
            .destinationPort(destinationPort.applyValue({ args0 -> args0 }))
            .direction(direction.applyValue({ args0 -> args0 }))
            .protocol(protocol.applyValue({ args0 -> args0 }))
            .source(source.applyValue({ args0 -> args0 }))
            .sourcePort(sourcePort.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleGroupRuleGroupRulesSourceStatefulRuleHeaderArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleGroupRulesSourceStatefulRuleHeaderArgsBuilder internal constructor() {
    private var destination: Output<String>? = null

    private var destinationPort: Output<String>? = null

    private var direction: Output<String>? = null

    private var protocol: Output<String>? = null

    private var source: Output<String>? = null

    private var sourcePort: Output<String>? = null

    /**
     * @param value The destination IP address or address range to inspect for, in CIDR notation. To match with any address, specify `ANY`.
     */
    @JvmName("uwjnkevelqljcytd")
    public suspend fun destination(`value`: Output<String>) {
        this.destination = value
    }

    /**
     * @param value The destination port to inspect for. To match with any address, specify `ANY`.
     */
    @JvmName("hcqixrwvsaqjrywq")
    public suspend fun destinationPort(`value`: Output<String>) {
        this.destinationPort = value
    }

    /**
     * @param value The direction of traffic flow to inspect. Valid values: `ANY` or `FORWARD`.
     */
    @JvmName("voqmlsoxygbxnyan")
    public suspend fun direction(`value`: Output<String>) {
        this.direction = value
    }

    /**
     * @param value The protocol to inspect. Valid values: `IP`, `TCP`, `UDP`, `ICMP`, `HTTP`, `FTP`, `TLS`, `SMB`, `DNS`, `DCERPC`, `SSH`, `SMTP`, `IMAP`, `MSN`, `KRB5`, `IKEV2`, `TFTP`, `NTP`, `DHCP`.
     */
    @JvmName("ykoawrbfyrakeorm")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value The source IP address or address range for, in CIDR notation. To match with any address, specify `ANY`.
     */
    @JvmName("mbdnngclxpopxvkr")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value The source port to inspect for. To match with any address, specify `ANY`.
     */
    @JvmName("ktgihlpgqdthlxwf")
    public suspend fun sourcePort(`value`: Output<String>) {
        this.sourcePort = value
    }

    /**
     * @param value The destination IP address or address range to inspect for, in CIDR notation. To match with any address, specify `ANY`.
     */
    @JvmName("jnbnqjhgenfgswri")
    public suspend fun destination(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param value The destination port to inspect for. To match with any address, specify `ANY`.
     */
    @JvmName("oewauegevbncpeut")
    public suspend fun destinationPort(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationPort = mapped
    }

    /**
     * @param value The direction of traffic flow to inspect. Valid values: `ANY` or `FORWARD`.
     */
    @JvmName("pvbtkwegjmdnaaqo")
    public suspend fun direction(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value The protocol to inspect. Valid values: `IP`, `TCP`, `UDP`, `ICMP`, `HTTP`, `FTP`, `TLS`, `SMB`, `DNS`, `DCERPC`, `SSH`, `SMTP`, `IMAP`, `MSN`, `KRB5`, `IKEV2`, `TFTP`, `NTP`, `DHCP`.
     */
    @JvmName("xjogwyuqfgshmroc")
    public suspend fun protocol(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The source IP address or address range for, in CIDR notation. To match with any address, specify `ANY`.
     */
    @JvmName("tsroxaacxxcvdiaw")
    public suspend fun source(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value The source port to inspect for. To match with any address, specify `ANY`.
     */
    @JvmName("ptkclehkhvbebjsw")
    public suspend fun sourcePort(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourcePort = mapped
    }

    internal fun build(): RuleGroupRuleGroupRulesSourceStatefulRuleHeaderArgs =
        RuleGroupRuleGroupRulesSourceStatefulRuleHeaderArgs(
            destination = destination ?: throw PulumiNullFieldException("destination"),
            destinationPort = destinationPort ?: throw PulumiNullFieldException("destinationPort"),
            direction = direction ?: throw PulumiNullFieldException("direction"),
            protocol = protocol ?: throw PulumiNullFieldException("protocol"),
            source = source ?: throw PulumiNullFieldException("source"),
            sourcePort = sourcePort ?: throw PulumiNullFieldException("sourcePort"),
        )
}
