@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceStatefulRuleRuleOptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property keyword Keyword defined by open source detection systems like Snort or Suricata for stateful rule inspection.
 * See [Snort General Rule Options](http://manual-snort-org&#46;s3-website-us-east-1&#46;amazonaws&#46;com/node31&#46;html) or [Suricata Rule Options](https://suricata.readthedocs.io/en/suricata-5.0.1/rules/intro.html#rule-options) for more details.
 * @property settings Set of strings for additional settings to use in stateful rule inspection.
 */
public data class RuleGroupRuleGroupRulesSourceStatefulRuleRuleOptionArgs(
    public val keyword: Output<String>,
    public val settings: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceStatefulRuleRuleOptionArgs> {
    override fun toJava(): com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceStatefulRuleRuleOptionArgs =
        com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceStatefulRuleRuleOptionArgs.builder()
            .keyword(keyword.applyValue({ args0 -> args0 }))
            .settings(settings?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [RuleGroupRuleGroupRulesSourceStatefulRuleRuleOptionArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleGroupRulesSourceStatefulRuleRuleOptionArgsBuilder internal constructor() {
    private var keyword: Output<String>? = null

    private var settings: Output<List<String>>? = null

    /**
     * @param value Keyword defined by open source detection systems like Snort or Suricata for stateful rule inspection.
     * See [Snort General Rule Options](http://manual-snort-org&#46;s3-website-us-east-1&#46;amazonaws&#46;com/node31&#46;html) or [Suricata Rule Options](https://suricata.readthedocs.io/en/suricata-5.0.1/rules/intro.html#rule-options) for more details.
     */
    @JvmName("mbctyygvcoxbtgwg")
    public suspend fun keyword(`value`: Output<String>) {
        this.keyword = value
    }

    /**
     * @param value Set of strings for additional settings to use in stateful rule inspection.
     */
    @JvmName("ooyotsgrxcmxoodi")
    public suspend fun settings(`value`: Output<List<String>>) {
        this.settings = value
    }

    @JvmName("scyeliqxnpeunqtg")
    public suspend fun settings(vararg values: Output<String>) {
        this.settings = Output.all(values.asList())
    }

    /**
     * @param values Set of strings for additional settings to use in stateful rule inspection.
     */
    @JvmName("kuoroqduopnljomd")
    public suspend fun settings(values: List<Output<String>>) {
        this.settings = Output.all(values)
    }

    /**
     * @param value Keyword defined by open source detection systems like Snort or Suricata for stateful rule inspection.
     * See [Snort General Rule Options](http://manual-snort-org&#46;s3-website-us-east-1&#46;amazonaws&#46;com/node31&#46;html) or [Suricata Rule Options](https://suricata.readthedocs.io/en/suricata-5.0.1/rules/intro.html#rule-options) for more details.
     */
    @JvmName("arpxdtpnumbtpjpo")
    public suspend fun keyword(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyword = mapped
    }

    /**
     * @param value Set of strings for additional settings to use in stateful rule inspection.
     */
    @JvmName("nljkiyfgyfyqandh")
    public suspend fun settings(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param values Set of strings for additional settings to use in stateful rule inspection.
     */
    @JvmName("uprowjidjekclscv")
    public suspend fun settings(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    internal fun build(): RuleGroupRuleGroupRulesSourceStatefulRuleRuleOptionArgs =
        RuleGroupRuleGroupRulesSourceStatefulRuleRuleOptionArgs(
            keyword = keyword ?: throw PulumiNullFieldException("keyword"),
            settings = settings,
        )
}
