@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleRuleDefinitionMatchAttributesTcpFlagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property flags Set of flags to look for in a packet. This setting can only specify values that are also specified in `masks`.
 * Valid values: `FIN`, `SYN`, `RST`, `PSH`, `ACK`, `URG`, `ECE`, `CWR`.
 * @property masks Set of flags to consider in the inspection. To inspect all flags, leave this empty.
 * Valid values: `FIN`, `SYN`, `RST`, `PSH`, `ACK`, `URG`, `ECE`, `CWR`.
 */
public data class
RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleRuleDefinitionMatchAttributesTcpFlagArgs(
    public val flags: Output<List<String>>,
    public val masks: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleRuleDefinitionMatchAttributesTcpFlagArgs> {
    override fun toJava(): com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleRuleDefinitionMatchAttributesTcpFlagArgs =
        com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleRuleDefinitionMatchAttributesTcpFlagArgs.builder()
            .flags(flags.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .masks(masks?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleRuleDefinitionMatchAttributesTcpFlagArgs].
 */
@PulumiTagMarker
public class
RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleRuleDefinitionMatchAttributesTcpFlagArgsBuilder
internal constructor() {
    private var flags: Output<List<String>>? = null

    private var masks: Output<List<String>>? = null

    /**
     * @param value Set of flags to look for in a packet. This setting can only specify values that are also specified in `masks`.
     * Valid values: `FIN`, `SYN`, `RST`, `PSH`, `ACK`, `URG`, `ECE`, `CWR`.
     */
    @JvmName("yrqgotqianbgshrs")
    public suspend fun flags(`value`: Output<List<String>>) {
        this.flags = value
    }

    @JvmName("pngohyrntnkurxco")
    public suspend fun flags(vararg values: Output<String>) {
        this.flags = Output.all(values.asList())
    }

    /**
     * @param values Set of flags to look for in a packet. This setting can only specify values that are also specified in `masks`.
     * Valid values: `FIN`, `SYN`, `RST`, `PSH`, `ACK`, `URG`, `ECE`, `CWR`.
     */
    @JvmName("gtuyolvcoafvnjgp")
    public suspend fun flags(values: List<Output<String>>) {
        this.flags = Output.all(values)
    }

    /**
     * @param value Set of flags to consider in the inspection. To inspect all flags, leave this empty.
     * Valid values: `FIN`, `SYN`, `RST`, `PSH`, `ACK`, `URG`, `ECE`, `CWR`.
     */
    @JvmName("jedicqoaccsnxenx")
    public suspend fun masks(`value`: Output<List<String>>) {
        this.masks = value
    }

    @JvmName("vannkttxhomuggmr")
    public suspend fun masks(vararg values: Output<String>) {
        this.masks = Output.all(values.asList())
    }

    /**
     * @param values Set of flags to consider in the inspection. To inspect all flags, leave this empty.
     * Valid values: `FIN`, `SYN`, `RST`, `PSH`, `ACK`, `URG`, `ECE`, `CWR`.
     */
    @JvmName("gqyanjfjxnigyxvm")
    public suspend fun masks(values: List<Output<String>>) {
        this.masks = Output.all(values)
    }

    /**
     * @param value Set of flags to look for in a packet. This setting can only specify values that are also specified in `masks`.
     * Valid values: `FIN`, `SYN`, `RST`, `PSH`, `ACK`, `URG`, `ECE`, `CWR`.
     */
    @JvmName("sgmeqbktsfxhdblu")
    public suspend fun flags(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.flags = mapped
    }

    /**
     * @param values Set of flags to look for in a packet. This setting can only specify values that are also specified in `masks`.
     * Valid values: `FIN`, `SYN`, `RST`, `PSH`, `ACK`, `URG`, `ECE`, `CWR`.
     */
    @JvmName("yfncbacdothxfdro")
    public suspend fun flags(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.flags = mapped
    }

    /**
     * @param value Set of flags to consider in the inspection. To inspect all flags, leave this empty.
     * Valid values: `FIN`, `SYN`, `RST`, `PSH`, `ACK`, `URG`, `ECE`, `CWR`.
     */
    @JvmName("ajipmlivnrvsvjtg")
    public suspend fun masks(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masks = mapped
    }

    /**
     * @param values Set of flags to consider in the inspection. To inspect all flags, leave this empty.
     * Valid values: `FIN`, `SYN`, `RST`, `PSH`, `ACK`, `URG`, `ECE`, `CWR`.
     */
    @JvmName("kcouykisvmkjgixw")
    public suspend fun masks(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.masks = mapped
    }

    internal fun build(): RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleRuleDefinitionMatchAttributesTcpFlagArgs =
        RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleRuleDefinitionMatchAttributesTcpFlagArgs(
            flags = flags ?: throw PulumiNullFieldException("flags"),
            masks = masks,
        )
}
