@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationEncryptionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property keyId ARN of the Amazon Web Services Key Management Service (KMS) customer managed key.
 * @property type Type of KMS key to use for encryption of your Network Firewall resources. Valid values: `AWS_OWNED_KMS_KEY`, `CUSTOMER_KMS`.
 */
public data class TlsInspectionConfigurationEncryptionConfigurationArgs(
    public val keyId: Output<String>,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationEncryptionConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationEncryptionConfigurationArgs =
        com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationEncryptionConfigurationArgs.builder()
            .keyId(keyId.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TlsInspectionConfigurationEncryptionConfigurationArgs].
 */
@PulumiTagMarker
public class TlsInspectionConfigurationEncryptionConfigurationArgsBuilder internal constructor() {
    private var keyId: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value ARN of the Amazon Web Services Key Management Service (KMS) customer managed key.
     */
    @JvmName("qtmbmudmnamvrolc")
    public suspend fun keyId(`value`: Output<String>) {
        this.keyId = value
    }

    /**
     * @param value Type of KMS key to use for encryption of your Network Firewall resources. Valid values: `AWS_OWNED_KMS_KEY`, `CUSTOMER_KMS`.
     */
    @JvmName("yjeetohxareovsom")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value ARN of the Amazon Web Services Key Management Service (KMS) customer managed key.
     */
    @JvmName("wxnxldjeemurrxxs")
    public suspend fun keyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyId = mapped
    }

    /**
     * @param value Type of KMS key to use for encryption of your Network Firewall resources. Valid values: `AWS_OWNED_KMS_KEY`, `CUSTOMER_KMS`.
     */
    @JvmName("pghyfwaxmgafwoke")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): TlsInspectionConfigurationEncryptionConfigurationArgs =
        TlsInspectionConfigurationEncryptionConfigurationArgs(
            keyId = keyId ?: throw PulumiNullFieldException("keyId"),
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
