@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property serverCertificateConfiguration Server certificate configurations that are associated with the TLS configuration. Detailed below.
 */
public data class TlsInspectionConfigurationTlsInspectionConfigurationArgs(
    public val serverCertificateConfiguration: Output<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationArgs =
        com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationArgs.builder()
            .serverCertificateConfiguration(
                serverCertificateConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [TlsInspectionConfigurationTlsInspectionConfigurationArgs].
 */
@PulumiTagMarker
public class TlsInspectionConfigurationTlsInspectionConfigurationArgsBuilder internal constructor() {
    private var serverCertificateConfiguration:
        Output<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs>? =
        null

    /**
     * @param value Server certificate configurations that are associated with the TLS configuration. Detailed below.
     */
    @JvmName("najvkntwdbyckrpn")
    public suspend fun serverCertificateConfiguration(`value`: Output<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs>) {
        this.serverCertificateConfiguration = value
    }

    /**
     * @param value Server certificate configurations that are associated with the TLS configuration. Detailed below.
     */
    @JvmName("xrxhvstvixdlslws")
    public suspend fun serverCertificateConfiguration(`value`: TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverCertificateConfiguration = mapped
    }

    /**
     * @param argument Server certificate configurations that are associated with the TLS configuration. Detailed below.
     */
    @JvmName("xfscjopaqpuaebkv")
    public suspend fun serverCertificateConfiguration(argument: suspend TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.serverCertificateConfiguration = mapped
    }

    internal fun build(): TlsInspectionConfigurationTlsInspectionConfigurationArgs =
        TlsInspectionConfigurationTlsInspectionConfigurationArgs(
            serverCertificateConfiguration = serverCertificateConfiguration,
        )
}
