@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property certificateAuthorityArn ARN of the imported certificate authority (CA) certificate within Certificate Manager (ACM) to use for outbound SSL/TLS inspection. See [Using SSL/TLS certificates with TLS inspection configurations](https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection-certificate-requirements.html) for limitations on CA certificates.
 * @property checkCertificateRevocationStatus Check Certificate Revocation Status block. Detailed below.
 * @property scopes Scope block. Detailed below.
 * @property serverCertificates Server certificates to use for inbound SSL/TLS inspection. See [Using SSL/TLS certificates with TLS inspection configurations](https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection-certificate-requirements.html).
 */
public data class
TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs(
    public val certificateAuthorityArn: Output<String>? = null,
    public val checkCertificateRevocationStatus: Output<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationCheckCertificateRevocationStatusArgs>? =
        null,
    public val scopes: Output<List<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs>>? =
        null,
    public val serverCertificates: Output<List<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs =
        com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs.builder()
            .certificateAuthorityArn(certificateAuthorityArn?.applyValue({ args0 -> args0 }))
            .checkCertificateRevocationStatus(
                checkCertificateRevocationStatus?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .scopes(scopes?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .serverCertificates(
                serverCertificates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs].
 */
@PulumiTagMarker
public class
TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgsBuilder
internal constructor() {
    private var certificateAuthorityArn: Output<String>? = null

    private var checkCertificateRevocationStatus:
        Output<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationCheckCertificateRevocationStatusArgs>? =
        null

    private var scopes:
        Output<List<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs>>? =
        null

    private var serverCertificates:
        Output<List<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgs>>? =
        null

    /**
     * @param value ARN of the imported certificate authority (CA) certificate within Certificate Manager (ACM) to use for outbound SSL/TLS inspection. See [Using SSL/TLS certificates with TLS inspection configurations](https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection-certificate-requirements.html) for limitations on CA certificates.
     */
    @JvmName("kbqjswrvjhsalbhd")
    public suspend fun certificateAuthorityArn(`value`: Output<String>) {
        this.certificateAuthorityArn = value
    }

    /**
     * @param value Check Certificate Revocation Status block. Detailed below.
     */
    @JvmName("cjdcybvgwxhhnrhk")
    public suspend fun checkCertificateRevocationStatus(`value`: Output<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationCheckCertificateRevocationStatusArgs>) {
        this.checkCertificateRevocationStatus = value
    }

    /**
     * @param value Scope block. Detailed below.
     */
    @JvmName("yebfppmxrmbuhkjr")
    public suspend fun scopes(`value`: Output<List<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs>>) {
        this.scopes = value
    }

    @JvmName("nqqqvcmbxelnhenu")
    public suspend fun scopes(vararg values: Output<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs>) {
        this.scopes = Output.all(values.asList())
    }

    /**
     * @param values Scope block. Detailed below.
     */
    @JvmName("nqbhdlgmpxtaecve")
    public suspend fun scopes(values: List<Output<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs>>) {
        this.scopes = Output.all(values)
    }

    /**
     * @param value Server certificates to use for inbound SSL/TLS inspection. See [Using SSL/TLS certificates with TLS inspection configurations](https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection-certificate-requirements.html).
     */
    @JvmName("qeeyllqmlsnhmeep")
    public suspend fun serverCertificates(`value`: Output<List<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgs>>) {
        this.serverCertificates = value
    }

    @JvmName("joshhteueodhprsl")
    public suspend fun serverCertificates(vararg values: Output<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgs>) {
        this.serverCertificates = Output.all(values.asList())
    }

    /**
     * @param values Server certificates to use for inbound SSL/TLS inspection. See [Using SSL/TLS certificates with TLS inspection configurations](https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection-certificate-requirements.html).
     */
    @JvmName("dfetjwjorqwbptql")
    public suspend fun serverCertificates(values: List<Output<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgs>>) {
        this.serverCertificates = Output.all(values)
    }

    /**
     * @param value ARN of the imported certificate authority (CA) certificate within Certificate Manager (ACM) to use for outbound SSL/TLS inspection. See [Using SSL/TLS certificates with TLS inspection configurations](https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection-certificate-requirements.html) for limitations on CA certificates.
     */
    @JvmName("hlcabnchuxmbcavs")
    public suspend fun certificateAuthorityArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateAuthorityArn = mapped
    }

    /**
     * @param value Check Certificate Revocation Status block. Detailed below.
     */
    @JvmName("yihommyvkulmqacm")
    public suspend fun checkCertificateRevocationStatus(`value`: TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationCheckCertificateRevocationStatusArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.checkCertificateRevocationStatus = mapped
    }

    /**
     * @param argument Check Certificate Revocation Status block. Detailed below.
     */
    @JvmName("aafkiewntieiaygi")
    public suspend fun checkCertificateRevocationStatus(argument: suspend TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationCheckCertificateRevocationStatusArgsBuilder.() -> Unit) {
        val toBeMapped =
            TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationCheckCertificateRevocationStatusArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.checkCertificateRevocationStatus = mapped
    }

    /**
     * @param value Scope block. Detailed below.
     */
    @JvmName("rsksdcrhioyirtmx")
    public suspend fun scopes(`value`: List<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param argument Scope block. Detailed below.
     */
    @JvmName("btsjxogmniobywya")
    public suspend fun scopes(argument: List<suspend TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.scopes = mapped
    }

    /**
     * @param argument Scope block. Detailed below.
     */
    @JvmName("gwmhyjacfuyhgbsl")
    public suspend fun scopes(vararg argument: suspend TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.scopes = mapped
    }

    /**
     * @param argument Scope block. Detailed below.
     */
    @JvmName("xewxoeadhgbapouf")
    public suspend fun scopes(argument: suspend TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.scopes = mapped
    }

    /**
     * @param values Scope block. Detailed below.
     */
    @JvmName("rgpjjvlsnrjhpftv")
    public suspend fun scopes(vararg values: TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param value Server certificates to use for inbound SSL/TLS inspection. See [Using SSL/TLS certificates with TLS inspection configurations](https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection-certificate-requirements.html).
     */
    @JvmName("mfrxeahyuvjuwfwv")
    public suspend fun serverCertificates(`value`: List<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverCertificates = mapped
    }

    /**
     * @param argument Server certificates to use for inbound SSL/TLS inspection. See [Using SSL/TLS certificates with TLS inspection configurations](https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection-certificate-requirements.html).
     */
    @JvmName("qebrudsqxruvgpfo")
    public suspend fun serverCertificates(argument: List<suspend TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serverCertificates = mapped
    }

    /**
     * @param argument Server certificates to use for inbound SSL/TLS inspection. See [Using SSL/TLS certificates with TLS inspection configurations](https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection-certificate-requirements.html).
     */
    @JvmName("rleefgncxkonuatg")
    public suspend fun serverCertificates(vararg argument: suspend TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serverCertificates = mapped
    }

    /**
     * @param argument Server certificates to use for inbound SSL/TLS inspection. See [Using SSL/TLS certificates with TLS inspection configurations](https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection-certificate-requirements.html).
     */
    @JvmName("glktooaohedrucpg")
    public suspend fun serverCertificates(argument: suspend TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.serverCertificates = mapped
    }

    /**
     * @param values Server certificates to use for inbound SSL/TLS inspection. See [Using SSL/TLS certificates with TLS inspection configurations](https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection-certificate-requirements.html).
     */
    @JvmName("mbpvfisuxmrbgijn")
    public suspend fun serverCertificates(vararg values: TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverCertificates = mapped
    }

    internal fun build(): TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs =
        TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationArgs(
            certificateAuthorityArn = certificateAuthorityArn,
            checkCertificateRevocationStatus = checkCertificateRevocationStatus,
            scopes = scopes,
            serverCertificates = serverCertificates,
        )
}
