@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property destinationPorts Set of configuration blocks describing the destination ports to inspect for. If not specified, this matches with any destination port. See Destination Ports below for details.
 * @property destinations Set of configuration blocks describing the destination IP address and address ranges to inspect for, in CIDR notation. If not specified, this matches with any destination address. See Destination below for details.
 * @property protocols Set of protocols to inspect for, specified using the protocol's assigned internet protocol number (IANA). Network Firewall currently supports TCP only. Valid values: `6`
 * @property sourcePorts Set of configuration blocks describing the source ports to inspect for. If not specified, this matches with any source port. See Source Ports below for details.
 * @property sources Set of configuration blocks describing the source IP address and address ranges to inspect for, in CIDR notation. If not specified, this matches with any source address. See Source below for details.
 */
public data class
TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs(
    public val destinationPorts: Output<List<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs>>? =
        null,
    public val destinations: Output<List<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgs>>? =
        null,
    public val protocols: Output<List<Int>>,
    public val sourcePorts: Output<List<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgs>>? =
        null,
    public val sources: Output<List<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs> {
    override fun toJava(): com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs =
        com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs.builder()
            .destinationPorts(
                destinationPorts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .destinations(
                destinations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .protocols(protocols.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourcePorts(
                sourcePorts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sources(
                sources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs].
 */
@PulumiTagMarker
public class
TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgsBuilder
internal constructor() {
    private var destinationPorts:
        Output<List<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs>>? =
        null

    private var destinations:
        Output<List<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgs>>? =
        null

    private var protocols: Output<List<Int>>? = null

    private var sourcePorts:
        Output<List<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgs>>? =
        null

    private var sources:
        Output<List<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs>>? =
        null

    /**
     * @param value Set of configuration blocks describing the destination ports to inspect for. If not specified, this matches with any destination port. See Destination Ports below for details.
     */
    @JvmName("gpyqrdwtodmxtcrx")
    public suspend fun destinationPorts(`value`: Output<List<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs>>) {
        this.destinationPorts = value
    }

    @JvmName("dispxdyniddcjcor")
    public suspend fun destinationPorts(vararg values: Output<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs>) {
        this.destinationPorts = Output.all(values.asList())
    }

    /**
     * @param values Set of configuration blocks describing the destination ports to inspect for. If not specified, this matches with any destination port. See Destination Ports below for details.
     */
    @JvmName("ibqqmnpipatyltbf")
    public suspend fun destinationPorts(values: List<Output<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs>>) {
        this.destinationPorts = Output.all(values)
    }

    /**
     * @param value Set of configuration blocks describing the destination IP address and address ranges to inspect for, in CIDR notation. If not specified, this matches with any destination address. See Destination below for details.
     */
    @JvmName("nlgswtqhvicdkaqv")
    public suspend fun destinations(`value`: Output<List<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgs>>) {
        this.destinations = value
    }

    @JvmName("yrcntkocwjfynftn")
    public suspend fun destinations(vararg values: Output<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgs>) {
        this.destinations = Output.all(values.asList())
    }

    /**
     * @param values Set of configuration blocks describing the destination IP address and address ranges to inspect for, in CIDR notation. If not specified, this matches with any destination address. See Destination below for details.
     */
    @JvmName("lhqtkatfbiwhfqbl")
    public suspend fun destinations(values: List<Output<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgs>>) {
        this.destinations = Output.all(values)
    }

    /**
     * @param value Set of protocols to inspect for, specified using the protocol's assigned internet protocol number (IANA). Network Firewall currently supports TCP only. Valid values: `6`
     */
    @JvmName("gjnwaufduldliuaj")
    public suspend fun protocols(`value`: Output<List<Int>>) {
        this.protocols = value
    }

    @JvmName("btxarulybngbbkyq")
    public suspend fun protocols(vararg values: Output<Int>) {
        this.protocols = Output.all(values.asList())
    }

    /**
     * @param values Set of protocols to inspect for, specified using the protocol's assigned internet protocol number (IANA). Network Firewall currently supports TCP only. Valid values: `6`
     */
    @JvmName("ukdhvooeultgbqjx")
    public suspend fun protocols(values: List<Output<Int>>) {
        this.protocols = Output.all(values)
    }

    /**
     * @param value Set of configuration blocks describing the source ports to inspect for. If not specified, this matches with any source port. See Source Ports below for details.
     */
    @JvmName("ietpgnymxgtdsyjo")
    public suspend fun sourcePorts(`value`: Output<List<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgs>>) {
        this.sourcePorts = value
    }

    @JvmName("tyyajdmromimdbgr")
    public suspend fun sourcePorts(vararg values: Output<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgs>) {
        this.sourcePorts = Output.all(values.asList())
    }

    /**
     * @param values Set of configuration blocks describing the source ports to inspect for. If not specified, this matches with any source port. See Source Ports below for details.
     */
    @JvmName("nugrndangfjxited")
    public suspend fun sourcePorts(values: List<Output<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgs>>) {
        this.sourcePorts = Output.all(values)
    }

    /**
     * @param value Set of configuration blocks describing the source IP address and address ranges to inspect for, in CIDR notation. If not specified, this matches with any source address. See Source below for details.
     */
    @JvmName("mdrsdejatigobfnq")
    public suspend fun sources(`value`: Output<List<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs>>) {
        this.sources = value
    }

    @JvmName("xgfbqprqwtmmrjwo")
    public suspend fun sources(vararg values: Output<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs>) {
        this.sources = Output.all(values.asList())
    }

    /**
     * @param values Set of configuration blocks describing the source IP address and address ranges to inspect for, in CIDR notation. If not specified, this matches with any source address. See Source below for details.
     */
    @JvmName("ymcepofrmcwoexwq")
    public suspend fun sources(values: List<Output<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs>>) {
        this.sources = Output.all(values)
    }

    /**
     * @param value Set of configuration blocks describing the destination ports to inspect for. If not specified, this matches with any destination port. See Destination Ports below for details.
     */
    @JvmName("eycjcdasfshrgnbh")
    public suspend fun destinationPorts(`value`: List<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPorts = mapped
    }

    /**
     * @param argument Set of configuration blocks describing the destination ports to inspect for. If not specified, this matches with any destination port. See Destination Ports below for details.
     */
    @JvmName("wmyvmbcwhecuohqg")
    public suspend fun destinationPorts(argument: List<suspend TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.destinationPorts = mapped
    }

    /**
     * @param argument Set of configuration blocks describing the destination ports to inspect for. If not specified, this matches with any destination port. See Destination Ports below for details.
     */
    @JvmName("ubshvbvkngqoogpx")
    public suspend fun destinationPorts(vararg argument: suspend TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.destinationPorts = mapped
    }

    /**
     * @param argument Set of configuration blocks describing the destination ports to inspect for. If not specified, this matches with any destination port. See Destination Ports below for details.
     */
    @JvmName("urxobypwkosuqeym")
    public suspend fun destinationPorts(argument: suspend TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.destinationPorts = mapped
    }

    /**
     * @param values Set of configuration blocks describing the destination ports to inspect for. If not specified, this matches with any destination port. See Destination Ports below for details.
     */
    @JvmName("vfrwuuvwprwhfrne")
    public suspend fun destinationPorts(vararg values: TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationPorts = mapped
    }

    /**
     * @param value Set of configuration blocks describing the destination IP address and address ranges to inspect for, in CIDR notation. If not specified, this matches with any destination address. See Destination below for details.
     */
    @JvmName("ltwjxtfwmlvvkkpd")
    public suspend fun destinations(`value`: List<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param argument Set of configuration blocks describing the destination IP address and address ranges to inspect for, in CIDR notation. If not specified, this matches with any destination address. See Destination below for details.
     */
    @JvmName("fgshjncpsddcgmnf")
    public suspend fun destinations(argument: List<suspend TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.destinations = mapped
    }

    /**
     * @param argument Set of configuration blocks describing the destination IP address and address ranges to inspect for, in CIDR notation. If not specified, this matches with any destination address. See Destination below for details.
     */
    @JvmName("kdusvgaahismdtrs")
    public suspend fun destinations(vararg argument: suspend TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.destinations = mapped
    }

    /**
     * @param argument Set of configuration blocks describing the destination IP address and address ranges to inspect for, in CIDR notation. If not specified, this matches with any destination address. See Destination below for details.
     */
    @JvmName("uepxanpfvaojsnby")
    public suspend fun destinations(argument: suspend TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.destinations = mapped
    }

    /**
     * @param values Set of configuration blocks describing the destination IP address and address ranges to inspect for, in CIDR notation. If not specified, this matches with any destination address. See Destination below for details.
     */
    @JvmName("iylcnarawcfowjoa")
    public suspend fun destinations(vararg values: TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param value Set of protocols to inspect for, specified using the protocol's assigned internet protocol number (IANA). Network Firewall currently supports TCP only. Valid values: `6`
     */
    @JvmName("hjnuqcxffkffyagk")
    public suspend fun protocols(`value`: List<Int>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocols = mapped
    }

    /**
     * @param values Set of protocols to inspect for, specified using the protocol's assigned internet protocol number (IANA). Network Firewall currently supports TCP only. Valid values: `6`
     */
    @JvmName("anektidqtcdywlid")
    public suspend fun protocols(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocols = mapped
    }

    /**
     * @param value Set of configuration blocks describing the source ports to inspect for. If not specified, this matches with any source port. See Source Ports below for details.
     */
    @JvmName("seafprgiopxcecfa")
    public suspend fun sourcePorts(`value`: List<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcePorts = mapped
    }

    /**
     * @param argument Set of configuration blocks describing the source ports to inspect for. If not specified, this matches with any source port. See Source Ports below for details.
     */
    @JvmName("toiicvfmdxixgbnj")
    public suspend fun sourcePorts(argument: List<suspend TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sourcePorts = mapped
    }

    /**
     * @param argument Set of configuration blocks describing the source ports to inspect for. If not specified, this matches with any source port. See Source Ports below for details.
     */
    @JvmName("vmbbvgrxbdjrruhk")
    public suspend fun sourcePorts(vararg argument: suspend TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sourcePorts = mapped
    }

    /**
     * @param argument Set of configuration blocks describing the source ports to inspect for. If not specified, this matches with any source port. See Source Ports below for details.
     */
    @JvmName("mpghxakuyykrlrcx")
    public suspend fun sourcePorts(argument: suspend TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.sourcePorts = mapped
    }

    /**
     * @param values Set of configuration blocks describing the source ports to inspect for. If not specified, this matches with any source port. See Source Ports below for details.
     */
    @JvmName("jgwedlsyjqxbisqe")
    public suspend fun sourcePorts(vararg values: TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePortArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourcePorts = mapped
    }

    /**
     * @param value Set of configuration blocks describing the source IP address and address ranges to inspect for, in CIDR notation. If not specified, this matches with any source address. See Source below for details.
     */
    @JvmName("ixktsyarifknojfb")
    public suspend fun sources(`value`: List<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param argument Set of configuration blocks describing the source IP address and address ranges to inspect for, in CIDR notation. If not specified, this matches with any source address. See Source below for details.
     */
    @JvmName("dlehyxifderthtup")
    public suspend fun sources(argument: List<suspend TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument Set of configuration blocks describing the source IP address and address ranges to inspect for, in CIDR notation. If not specified, this matches with any source address. See Source below for details.
     */
    @JvmName("jcdepsibdkubtnuc")
    public suspend fun sources(vararg argument: suspend TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument Set of configuration blocks describing the source IP address and address ranges to inspect for, in CIDR notation. If not specified, this matches with any source address. See Source below for details.
     */
    @JvmName("wwxcbquusbukrkhx")
    public suspend fun sources(argument: suspend TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param values Set of configuration blocks describing the source IP address and address ranges to inspect for, in CIDR notation. If not specified, this matches with any source address. See Source below for details.
     */
    @JvmName("unpqdnvmairhblxa")
    public suspend fun sources(vararg values: TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    internal fun build(): TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs =
        TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeArgs(
            destinationPorts = destinationPorts,
            destinations = destinations,
            protocols = protocols ?: throw PulumiNullFieldException("protocols"),
            sourcePorts = sourcePorts,
            sources = sources,
        )
}
