@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fromPort The lower limit of the port range. This must be less than or equal to the `to_port`.
 * @property toPort The upper limit of the port range. This must be greater than or equal to the `from_port`.
 */
public data class
TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs(
    public val fromPort: Output<Int>,
    public val toPort: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs> {
    override fun toJava(): com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs =
        com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs.builder()
            .fromPort(fromPort.applyValue({ args0 -> args0 }))
            .toPort(toPort.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs].
 */
@PulumiTagMarker
public class
TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgsBuilder
internal constructor() {
    private var fromPort: Output<Int>? = null

    private var toPort: Output<Int>? = null

    /**
     * @param value The lower limit of the port range. This must be less than or equal to the `to_port`.
     */
    @JvmName("hgbtioblxikcqfqr")
    public suspend fun fromPort(`value`: Output<Int>) {
        this.fromPort = value
    }

    /**
     * @param value The upper limit of the port range. This must be greater than or equal to the `from_port`.
     */
    @JvmName("glhaapkmmvldxhtc")
    public suspend fun toPort(`value`: Output<Int>) {
        this.toPort = value
    }

    /**
     * @param value The lower limit of the port range. This must be less than or equal to the `to_port`.
     */
    @JvmName("gnlbkeyslkhttesm")
    public suspend fun fromPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fromPort = mapped
    }

    /**
     * @param value The upper limit of the port range. This must be greater than or equal to the `from_port`.
     */
    @JvmName("rupxwcjuqvginywm")
    public suspend fun toPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.toPort = mapped
    }

    internal fun build(): TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs =
        TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPortArgs(
            fromPort = fromPort ?: throw PulumiNullFieldException("fromPort"),
            toPort = toPort ?: throw PulumiNullFieldException("toPort"),
        )
}
