@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property addressDefinition An IP address or a block of IP addresses in CIDR notation. AWS Network Firewall supports all address ranges for IPv4.
 */
public data class
TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs(
    public val addressDefinition: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs> {
    override fun toJava(): com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs =
        com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs.builder()
            .addressDefinition(addressDefinition.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs].
 */
@PulumiTagMarker
public class
TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgsBuilder
internal constructor() {
    private var addressDefinition: Output<String>? = null

    /**
     * @param value An IP address or a block of IP addresses in CIDR notation. AWS Network Firewall supports all address ranges for IPv4.
     */
    @JvmName("wkqtjbpulfimdydq")
    public suspend fun addressDefinition(`value`: Output<String>) {
        this.addressDefinition = value
    }

    /**
     * @param value An IP address or a block of IP addresses in CIDR notation. AWS Network Firewall supports all address ranges for IPv4.
     */
    @JvmName("fjihkyifbdsbtdrn")
    public suspend fun addressDefinition(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addressDefinition = mapped
    }

    internal fun build(): TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs =
        TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourceArgs(
            addressDefinition = addressDefinition ?: throw PulumiNullFieldException("addressDefinition"),
        )
}
