@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceArn ARN of the Certificate Manager SSL/TLS server certificate that's used for inbound SSL/TLS inspection.
 */
public data class
TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgs(
    public val resourceArn: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgs> {
    override fun toJava(): com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgs =
        com.pulumi.aws.networkfirewall.inputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgs.builder()
            .resourceArn(resourceArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgs].
 */
@PulumiTagMarker
public class
TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgsBuilder
internal constructor() {
    private var resourceArn: Output<String>? = null

    /**
     * @param value ARN of the Certificate Manager SSL/TLS server certificate that's used for inbound SSL/TLS inspection.
     */
    @JvmName("fyayuufpmjbwanpo")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value ARN of the Certificate Manager SSL/TLS server certificate that's used for inbound SSL/TLS inspection.
     */
    @JvmName("mtskovkrpadeoefi")
    public suspend fun resourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    internal fun build(): TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgs =
        TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificateArgs(
            resourceArn = resourceArn,
        )
}
