@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ruleOrder Indicates how to manage the order of stateful rule evaluation for the policy. Default value: `DEFAULT_ACTION_ORDER`. Valid values: `DEFAULT_ACTION_ORDER`, `STRICT_ORDER`.
 * @property streamExceptionPolicy Describes how to treat traffic which has broken midstream. Default value: `DROP`. Valid values: `DROP`, `CONTINUE`, `REJECT`.
 */
public data class FirewallPolicyFirewallPolicyStatefulEngineOptions(
    public val ruleOrder: String? = null,
    public val streamExceptionPolicy: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkfirewall.outputs.FirewallPolicyFirewallPolicyStatefulEngineOptions): FirewallPolicyFirewallPolicyStatefulEngineOptions =
            FirewallPolicyFirewallPolicyStatefulEngineOptions(
                ruleOrder = javaType.ruleOrder().map({ args0 -> args0 }).orElse(null),
                streamExceptionPolicy = javaType.streamExceptionPolicy().map({ args0 -> args0 }).orElse(null),
            )
    }
}
