@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ipAddressType The subnet's IP address type. Valida values: `"DUALSTACK"`, `"IPV4"`.
 * @property subnetId The unique identifier for the subnet.
 */
public data class FirewallSubnetMapping(
    public val ipAddressType: String? = null,
    public val subnetId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkfirewall.outputs.FirewallSubnetMapping): FirewallSubnetMapping = FirewallSubnetMapping(
            ipAddressType = javaType.ipAddressType().map({ args0 -> args0 }).orElse(null),
            subnetId = javaType.subnetId(),
        )
    }
}
