@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property capacityUsageSummaries Aggregated count of all resources used by reference sets in a firewall.
 * @property configurationSyncStateSummary Summary of sync states for all availability zones in which the firewall is configured.
 * @property status
 * @property syncStates Set of subnets configured for use by the firewall.
 */
public data class GetFirewallFirewallStatus(
    public val capacityUsageSummaries: List<GetFirewallFirewallStatusCapacityUsageSummary>,
    public val configurationSyncStateSummary: String,
    public val status: String,
    public val syncStates: List<GetFirewallFirewallStatusSyncState>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkfirewall.outputs.GetFirewallFirewallStatus): GetFirewallFirewallStatus = GetFirewallFirewallStatus(
            capacityUsageSummaries = javaType.capacityUsageSummaries().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkfirewall.kotlin.outputs.GetFirewallFirewallStatusCapacityUsageSummary.Companion.toKotlin(args0)
                })
            }),
            configurationSyncStateSummary = javaType.configurationSyncStateSummary(),
            status = javaType.status(),
            syncStates = javaType.syncStates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkfirewall.kotlin.outputs.GetFirewallFirewallStatusSyncState.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
