@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property availableCidrCount Available number of CIDR blocks available for use by the IP set references in a firewall.
 * @property ipSetReferences The list of IP set references used by a firewall.
 * @property utilizedCidrCount Number of CIDR blocks used by the IP set references in a firewall.
 */
public data class GetFirewallFirewallStatusCapacityUsageSummaryCidr(
    public val availableCidrCount: Int,
    public val ipSetReferences: List<GetFirewallFirewallStatusCapacityUsageSummaryCidrIpSetReference>,
    public val utilizedCidrCount: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkfirewall.outputs.GetFirewallFirewallStatusCapacityUsageSummaryCidr): GetFirewallFirewallStatusCapacityUsageSummaryCidr =
            GetFirewallFirewallStatusCapacityUsageSummaryCidr(
                availableCidrCount = javaType.availableCidrCount(),
                ipSetReferences = javaType.ipSetReferences().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.networkfirewall.kotlin.outputs.GetFirewallFirewallStatusCapacityUsageSummaryCidrIpSetReference.Companion.toKotlin(args0)
                    })
                }),
                utilizedCidrCount = javaType.utilizedCidrCount(),
            )
    }
}
