@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property attachments Nested list describing the attachment status of the firewall's association with a single VPC subnet.
 * @property availabilityZone The Availability Zone where the subnet is configured.
 */
public data class GetFirewallFirewallStatusSyncState(
    public val attachments: List<GetFirewallFirewallStatusSyncStateAttachment>,
    public val availabilityZone: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkfirewall.outputs.GetFirewallFirewallStatusSyncState): GetFirewallFirewallStatusSyncState = GetFirewallFirewallStatusSyncState(
            attachments = javaType.attachments().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkfirewall.kotlin.outputs.GetFirewallFirewallStatusSyncStateAttachment.Companion.toKotlin(args0)
                })
            }),
            availabilityZone = javaType.availabilityZone(),
        )
    }
}
